/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.Method;
import ghidra.async.AsyncFence;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelImpl;
import ghidra.dbg.jdi.model.JdiModelTargetConstantPool;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.jdi.model.JdiModelTargetSection;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="TargetSectionContainer", elements={@TargetElementType(type=JdiModelTargetSection.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetSectionContainer
extends JdiModelTargetObjectImpl
implements TargetMemory {
    protected final JdiModelTargetReferenceType reftype;
    private final Map<String, JdiModelTargetSection> sectionsByName = new HashMap<String, JdiModelTargetSection>();
    private JdiModelTargetConstantPool constantPool;

    public JdiModelTargetSectionContainer(JdiModelTargetReferenceType reftype) {
        super(reftype, "Sections");
        this.reftype = reftype;
        new JdiModelTargetSection(this);
    }

    protected void updateUsingSections(List<Method> methods) {
        this.setElements(this.sectionsByName.values(), Map.of(), "Refreshed");
    }

    protected CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        this.constantPool = new JdiModelTargetConstantPool(this, this.reftype.reftype.constantPool(), false);
        this.changeAttributes(List.of(), List.of(this.constantPool), Map.of(), "Initialized");
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        this.updateUsingSections(this.reftype.reftype.methods());
        return CompletableFuture.completedFuture(null);
    }

    protected synchronized JdiModelTargetSection getTargetSection(Method method) {
        return this.sectionsByName.computeIfAbsent(JdiModelImpl.methodToKey(method), n -> new JdiModelTargetSection(this, method, true));
    }

    public synchronized JdiModelTargetSection getTargetSectionIfPresent(String name) {
        return this.sectionsByName.get(name);
    }

    @Override
    public CompletableFuture<Void> init() {
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetSection method : this.sectionsByName.values()) {
            fence.include(method.init());
        }
        return fence.ready();
    }

    public JdiModelTargetReferenceType getClassType() {
        return this.reftype;
    }

    public void addSection(Method method) {
        if (this.impl.getAddressRange(method) != null) {
            JdiModelTargetSection targetSection = this.getTargetSection(method);
            this.sectionsByName.put(JdiModelImpl.methodToKey(method), targetSection);
            this.changeElements(List.of(), List.of(targetSection), Map.of(), "Refreshed");
        } else {
            System.err.println("addSection returned null: " + String.valueOf(method.location()));
        }
    }

    public CompletableFuture<byte[]> readMemory(Address address, int length) {
        AddressSpace addressSpace = address.getAddressSpace();
        if (addressSpace.equals((Object)this.impl.getAddressSpace("ram"))) {
            byte[] bytes = new byte[length];
            Method method = this.impl.getMethodForAddress(address);
            if (method != null && this.targetVM.vm.canGetBytecodes()) {
                byte[] bytecodes = method.bytecodes();
                int i = 0;
                for (byte b : bytecodes) {
                    bytes[i++] = b;
                    if (i < length) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    bytes[i] = -1;
                }
            }
            this.broadcast().memoryUpdated((TargetObject)this, address, bytes);
            return CompletableFuture.completedFuture(bytes);
        }
        if (addressSpace.equals((Object)this.impl.getAddressSpace("constantPool"))) {
            byte[] bytes = this.constantPool.getPool();
            this.broadcast().memoryUpdated((TargetObject)this, address, bytes);
            return CompletableFuture.completedFuture(bytes);
        }
        throw new RuntimeException();
    }

    public CompletableFuture<Void> writeMemory(Address address, byte[] data) {
        return CompletableFuture.completedFuture(null);
    }
}

