/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetStackFrame;
import ghidra.dbg.jdi.model.JdiModelTargetThread;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetStack;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Stack", elements={@TargetElementType(type=JdiModelTargetStackFrame.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetStack
extends JdiModelTargetObjectImpl
implements TargetStack {
    protected final JdiModelTargetThread thread;
    protected final Map<Location, JdiModelTargetStackFrame> framesByLocation = new WeakValueHashMap();
    protected final Map<Integer, JdiModelTargetStackFrame> framesByLevel = new WeakValueHashMap();

    public JdiModelTargetStack(JdiModelTargetThread thread) {
        super(thread, "Stack");
        this.thread = thread;
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        ArrayList<JdiModelTargetStackFrame> targetFrames = new ArrayList<JdiModelTargetStackFrame>();
        try {
            List<StackFrame> frames = this.thread.thread.frames();
            int i = 0;
            for (StackFrame frame : frames) {
                JdiModelTargetStackFrame targetFrame = this.getTargetFrame(i++, frame);
                targetFrames.add(targetFrame);
            }
            this.setElements(targetFrames, Map.of(), "Refreshed");
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(null);
    }

    protected synchronized JdiModelTargetStackFrame getTargetFrame(int level, StackFrame frame) {
        return this.framesByLocation.compute(frame.location(), (l, f) -> {
            if (f == null || f.getFrameLevel() != (long)level) {
                JdiModelTargetStackFrame tf = new JdiModelTargetStackFrame(this, this.thread, level, frame, true);
                this.framesByLevel.put(level, tf);
                return tf;
            }
            this.framesByLevel.put(level, (JdiModelTargetStackFrame)f);
            f.setFrame(level, frame);
            return f;
        });
    }

    public JdiModelTargetStackFrame getTargetFrame(StackFrame frame) {
        for (JdiModelTargetStackFrame f : this.framesByLocation.values()) {
            if (!f.frame.equals(frame)) continue;
            return f;
        }
        return null;
    }

    public JdiModelTargetStackFrame getTargetFrame(int level) {
        return this.framesByLevel.get(level);
    }

    protected CompletableFuture<?> update() {
        return this.fetchElements(DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS).exceptionally(e -> {
            Msg.error((Object)this, (Object)("Could not update stack " + String.valueOf(this) + " on STOPPED"));
            return null;
        });
    }

    public void invalidateRegisterCaches() {
        this.broadcast().invalidateCacheRequested((TargetObject)this);
    }
}

