/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMStartEvent;
import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.jdi.manager.JdiCause;
import ghidra.dbg.jdi.manager.JdiEventsListenerAdapter;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetRoot;
import ghidra.dbg.jdi.model.JdiModelTargetThread;
import ghidra.dbg.jdi.model.JdiModelTargetVM;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import ghidra.util.datastruct.WeakValueHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="VMContainer", elements={@TargetElementType(type=JdiModelTargetVM.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetVMContainer
extends JdiModelTargetObjectImpl
implements JdiEventsListenerAdapter {
    private JdiModelTargetRoot session;
    protected final Map<String, JdiModelTargetVM> vmsById = new WeakValueHashMap();

    public JdiModelTargetVMContainer(JdiModelTargetRoot session) {
        super(session, "VirtualMachines");
        this.session = session;
        this.impl.getManager().addEventsListener(null, this);
    }

    @Override
    public void vmStarted(VMStartEvent event, JdiCause cause) {
        VirtualMachine vm = event.virtualMachine();
        JdiModelTargetVM target = this.getTargetVM(vm);
        ((CompletableFuture)target.started(vm.name()).thenAccept(__ -> this.broadcast().event((TargetObject)this.session, null, TargetEventScope.TargetEventType.PROCESS_CREATED, "VM " + vm.name() + " started " + String.valueOf(vm.process()) + " pid=" + vm.name(), List.of(vm)))).exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Could not notify vm started", (Throwable)ex);
            return null;
        });
        this.changeElements(List.of(), List.of(target), Map.of(), "Added");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void vmDied(VMDeathEvent event, JdiCause cause) {
        VirtualMachine vm = event.virtualMachine();
        JdiModelTargetVM tgtVM = this.vmsById.get(vm.name());
        this.broadcast().event((TargetObject)this.session, null, TargetEventScope.TargetEventType.PROCESS_EXITED, "VM " + vm.name(), List.of(tgtVM));
        tgtVM.exited(vm);
        JdiModelTargetVMContainer jdiModelTargetVMContainer = this;
        synchronized (jdiModelTargetVMContainer) {
            this.vmsById.remove(vm.name());
            this.getManager().removeVM(vm);
        }
        this.changeElements(List.of(vm.name()), List.of(), Map.of(), "Removed");
    }

    protected void gatherThreads(List<? super JdiModelTargetThread> into, JdiModelTargetVM vm, Collection<? extends ThreadReference> from) {
        for (ThreadReference threadReference : from) {
            JdiModelTargetThread p = vm.threads.getTargetThread(threadReference);
            if (p == null) continue;
            into.add(p);
        }
    }

    @Override
    public void threadStarted(ThreadStartEvent event, JdiCause cause) {
        ThreadReference thread = event.thread();
        JdiModelTargetVM vm = this.getTargetVM(thread.threadGroup().virtualMachine());
        if (!this.vmsById.containsValue(vm)) {
            Msg.info((Object)this, (Object)(String.valueOf(event) + " ignored as vm may have exited"));
            return;
        }
        JdiModelTargetThread targetThread = vm.threads.threadCreated(thread);
        this.broadcast().event((TargetObject)this.session, (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_CREATED, "Thread " + thread.name() + " started", List.of(targetThread));
    }

    @Override
    public void threadExited(ThreadDeathEvent event, JdiCause cause) {
        ThreadReference thread = event.thread();
        JdiModelTargetVM tgtVM = this.vmsById.get(thread.virtualMachine().name());
        JdiModelTargetThread targetThread = tgtVM.threads.threadsById.get(thread.name());
        this.broadcast().event((TargetObject)this.session, (TargetThread)targetThread, TargetEventScope.TargetEventType.THREAD_EXITED, "Thread " + thread.name() + " exited", List.of(targetThread));
        tgtVM.threads.threadExited(thread);
    }

    @Override
    public void libraryLoaded(VirtualMachine vm, String name, JdiCause cause) {
    }

    @Override
    public void libraryUnloaded(VirtualMachine vm, String name, JdiCause cause) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUsingVMs(Map<String, VirtualMachine> byName) {
        List vms;
        JdiModelTargetVMContainer jdiModelTargetVMContainer = this;
        synchronized (jdiModelTargetVMContainer) {
            vms = byName.values().stream().map(this::getTargetVM).collect(Collectors.toList());
        }
        this.setElements(vms, Map.of(), "Refreshed");
    }

    public CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        if (!refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            this.updateUsingVMs(this.impl.getManager().getKnownVMs());
            return AsyncUtils.nil();
        }
        return this.impl.getManager().listVMs().thenAccept(this::updateUsingVMs);
    }

    public synchronized JdiModelTargetVM getTargetVM(VirtualMachine vm) {
        return this.vmsById.computeIfAbsent(vm.name(), i -> new JdiModelTargetVM(this, this.impl.getManager().getKnownVMs().get(i), true));
    }

    public synchronized JdiModelTargetVM getTargetVMByName(String name) {
        return this.vmsById.computeIfAbsent(name, i -> new JdiModelTargetVM(this, this.impl.getManager().getKnownVMs().get(i), true));
    }

    protected void invalidateMemoryAndRegisterCaches() {
        for (JdiModelTargetVM inf : this.vmsById.values()) {
            inf.invalidateMemoryAndRegisterCaches();
        }
    }
}

