/*
 * Decompiled with CFR 0.152.
 */
package generic;

import generic.RangeMapSetter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public interface Span<N, S extends Span<N, S>>
extends Comparable<S> {
    default public String doToString() {
        return this.domain().toString(this);
    }

    public Domain<N, S> domain();

    public N min();

    public N max();

    default public boolean minIsFinite() {
        return !this.min().equals(this.domain().min());
    }

    default public boolean maxIsFinite() {
        return !this.max().equals(this.domain().max());
    }

    default public boolean isEmpty() {
        return false;
    }

    default public boolean contains(N n) {
        return this.domain().compare(this.min(), n) <= 0 && this.domain().compare(n, this.max()) <= 0;
    }

    default public S intersect(S s) {
        return (S)this.domain().intersect(this, (Span)s);
    }

    default public boolean intersects(S s) {
        return this.domain().intersects(this, (Span)s);
    }

    default public boolean encloses(S s) {
        return this.domain().encloses(this, (Span)s);
    }

    default public S bound(S s) {
        return (S)this.domain().bound(this, (Span)s);
    }

    default public List<S> subtract(S s) {
        return this.domain().subtract(this, (Span)s);
    }

    @Override
    default public int compareTo(S that) {
        if (this.isEmpty()) {
            if (that.isEmpty()) {
                return 0;
            }
            return -1;
        }
        if (that.isEmpty()) {
            return 1;
        }
        int result = this.domain().compare(this.min(), that.min());
        if (result != 0) {
            return result;
        }
        result = this.domain().compare(this.max(), that.max());
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public static interface Domain<N, S extends Span<N, S>> {
        default public S closed(N min, N max) {
            if (this.compare(min, max) > 0) {
                throw new IllegalArgumentException("min > max: min=" + String.valueOf(min) + ",max=" + String.valueOf(max));
            }
            return this.newSpan(min, max);
        }

        public S newSpan(N var1, N var2);

        default public S value(N n) {
            return this.closed(n, n);
        }

        default public S atMost(N max) {
            return this.closed(this.min(), max);
        }

        default public S atLeast(N min) {
            return this.closed(min, this.max());
        }

        public S all();

        public S empty();

        default public String toString(N n) {
            return n.toString();
        }

        default public String toString(S s) {
            return s.isEmpty() ? "(empty)" : this.toMinString(s.min()) + ".." + this.toMaxString(s.max());
        }

        default public String toMinString(N min) {
            return this.min().equals(min) ? "(-inf" : "[" + this.toString((S)min);
        }

        default public String toMaxString(N max) {
            return this.max().equals(max) ? "+inf)" : this.toString((S)max) + "]";
        }

        public int compare(N var1, N var2);

        public N min();

        public N max();

        public N inc(N var1);

        public N dec(N var1);

        default public N min(N n1, N n2) {
            return this.compare(n1, n2) < 0 ? n1 : n2;
        }

        default public N max(N n1, N n2) {
            return this.compare(n1, n2) < 0 ? n2 : n1;
        }

        default public S intersect(S s1, S s2) {
            if (!this.intersects(s1, s2)) {
                return this.empty();
            }
            return this.closed(this.max(s1.min(), s2.min()), this.min(s1.max(), s2.max()));
        }

        default public boolean intersects(S s1, S s2) {
            if (s1.isEmpty() || s2.isEmpty()) {
                return false;
            }
            return this.compare(s1.max(), s2.min()) >= 0 && this.compare(s2.max(), s1.min()) >= 0;
        }

        default public boolean encloses(S s1, S s2) {
            if (s1.isEmpty()) {
                return false;
            }
            if (s2.isEmpty()) {
                return true;
            }
            return this.compare(s1.min(), s2.min()) <= 0 && this.compare(s1.max(), s2.max()) >= 0;
        }

        default public S bound(S s1, S s2) {
            if (s1.isEmpty()) {
                return s2;
            }
            if (s2.isEmpty()) {
                return s1;
            }
            return this.closed(this.min(s1.min(), s2.min()), this.max(s1.max(), s2.max()));
        }

        default public List<S> subtract(S s1, S s2) {
            if (s1.isEmpty()) {
                return List.of();
            }
            if (s2.isEmpty()) {
                return List.of(s1);
            }
            if (this.compare(s1.max(), s2.min()) < 0 || this.compare(s2.max(), s1.min()) < 0) {
                return List.of(s1);
            }
            if (this.compare(s1.min(), s2.min()) < 0) {
                if (this.compare(s1.max(), s2.max()) > 0) {
                    return List.of(this.closed(s1.min(), this.dec(s2.min())), this.closed(this.inc(s2.max()), s1.max()));
                }
                return List.of(this.closed(s1.min(), this.dec(s2.min())));
            }
            if (this.compare(s1.max(), s2.max()) > 0) {
                return List.of(this.closed(this.inc(s2.max()), s1.max()));
            }
            return List.of();
        }
    }

    public static class DefaultSpanSet<N, S extends Span<N, S>>
    implements MutableSpanSet<N, S> {
        private final MutableSpanMap<N, S, Boolean> map;
        private final Domain<N, S> domain;

        public DefaultSpanSet(Domain<N, S> domain) {
            this.map = this.newSpanMap(domain);
            this.domain = domain;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DefaultSpanSet)) {
                return false;
            }
            DefaultSpanSet that = (DefaultSpanSet)obj;
            return Objects.equals(this.map, that.map);
        }

        public String toString() {
            return "[" + this.map.spans().stream().map(s -> this.domain.toString((Span)s)).collect(Collectors.joining(",")) + "]";
        }

        protected MutableSpanMap<N, S, Boolean> newSpanMap(Domain<N, S> domain) {
            return new DefaultSpanMap(domain);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterable<S> spans() {
            return this.map.spans();
        }

        @Override
        public S bound() {
            return this.map.bound();
        }

        @Override
        public boolean contains(N n) {
            return Boolean.TRUE.equals(this.map.get(n));
        }

        @Override
        public S spanContaining(N n) {
            Map.Entry entry = this.map.getEntry(n);
            return (S)(entry == null ? null : (Span)entry.getKey());
        }

        @Override
        public Iterable<S> intersecting(S s) {
            return this.map.intersectingSpans(s);
        }

        @Override
        public boolean intersects(S s) {
            return this.map.intersects(s);
        }

        @Override
        public void add(S s) {
            this.map.put(s, true);
        }

        @Override
        public void addAll(SpanSet<N, S> set) {
            for (Span s : set.spans()) {
                this.add(s);
            }
        }

        @Override
        public void remove(S s) {
            this.map.remove(s);
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    public static class DefaultSpanMap<N, S extends Span<N, S>, V>
    implements MutableSpanMap<N, S, V> {
        private final Domain<N, S> domain;
        private final Setter setter;
        private final NavigableMap<N, Map.Entry<S, V>> spanTree;

        public DefaultSpanMap(Domain<N, S> domain) {
            this.domain = domain;
            this.setter = new Setter(domain);
            this.spanTree = new TreeMap<N, Map.Entry<S, V>>(domain::compare);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DefaultSpanMap)) {
                return false;
            }
            DefaultSpanMap that = (DefaultSpanMap)obj;
            if (this.domain != that.domain) {
                return false;
            }
            return Objects.equals(this.spanTree, that.spanTree);
        }

        public String toString() {
            return "{" + this.spanTree.values().stream().map(e -> this.domain.toString((Span)e.getKey()) + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(",")) + "}";
        }

        @Override
        public boolean isEmpty() {
            return this.spanTree.isEmpty();
        }

        @Override
        public Set<S> spans() {
            return this.spanTree.values().stream().map(e -> (Span)e.getKey()).collect(Collectors.toSet());
        }

        @Override
        public S bound() {
            if (this.spanTree.isEmpty()) {
                return this.domain.empty();
            }
            Span first = (Span)this.spanTree.firstEntry().getValue().getKey();
            Span last = (Span)this.spanTree.lastEntry().getValue().getKey();
            return (S)first.bound(last);
        }

        @Override
        public Collection<V> values() {
            return this.spanTree.values().stream().map(e -> e.getValue()).collect(Collectors.toSet());
        }

        @Override
        public Set<Map.Entry<S, V>> entries() {
            return Set.copyOf(this.spanTree.values());
        }

        @Override
        public Map.Entry<S, V> getEntry(N n) {
            Map.Entry<N, Map.Entry<S, V>> floor = this.spanTree.floorEntry(n);
            if (floor == null) {
                return null;
            }
            Map.Entry<S, V> ent = floor.getValue();
            if (!((Span)ent.getKey()).contains(n)) {
                return null;
            }
            return ent;
        }

        @Override
        public V get(N n) {
            Map.Entry<S, V> ent = this.getEntry(n);
            return ent == null ? null : (V)ent.getValue();
        }

        protected NavigableMap<N, Map.Entry<S, V>> subMap(N min, N max) {
            Map.Entry<N, Map.Entry<S, V>> adjEnt = this.spanTree.floorEntry(min);
            if (adjEnt != null && ((Span)adjEnt.getValue().getKey()).contains(min)) {
                min = adjEnt.getKey();
            }
            return this.spanTree.subMap(min, true, max, true);
        }

        @Override
        public Collection<Map.Entry<S, V>> intersectingEntries(S s) {
            return this.subMap(s.min(), s.max()).values();
        }

        @Override
        public Iterable<S> intersectingSpans(S s) {
            return this.intersectingEntries((Span)s).stream().map(e -> (Span)e.getKey()).collect(Collectors.toList());
        }

        @Override
        public boolean intersects(S s) {
            Map.Entry<N, Map.Entry<S, V>> entry = this.spanTree.floorEntry(s.max());
            return entry != null && ((Span)entry.getValue().getKey()).intersects(s);
        }

        @Override
        public void put(S s, V v) {
            if (s.isEmpty()) {
                return;
            }
            this.setter.set(s, v);
        }

        @Override
        public void putAll(SpanMap<N, S, V> map) {
            for (Map.Entry<S, V> entry : map.entries()) {
                this.put((Span)entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void remove(S s) {
            this.setter.set(s, null);
        }

        @Override
        public void clear() {
            this.spanTree.clear();
        }

        private class Setter
        extends SpanMapSetter<Map.Entry<N, Map.Entry<S, V>>, N, S, V> {
            private final Domain<N, S> domain;

            public Setter(Domain<N, S> domain) {
                this.domain = domain;
            }

            @Override
            protected Domain<N, S> domain() {
                return this.domain;
            }

            @Override
            protected S getRange(Map.Entry<N, Map.Entry<S, V>> entry) {
                return (Span)entry.getValue().getKey();
            }

            @Override
            protected V getValue(Map.Entry<N, Map.Entry<S, V>> entry) {
                return entry.getValue().getValue();
            }

            @Override
            protected void remove(Map.Entry<N, Map.Entry<S, V>> entry) {
                DefaultSpanMap.this.spanTree.remove(entry.getKey());
            }

            @Override
            protected Iterable<Map.Entry<N, Map.Entry<S, V>>> getIntersecting(N lower, N upper) {
                return DefaultSpanMap.this.subMap(lower, upper).entrySet();
            }

            @Override
            protected Map.Entry<N, Map.Entry<S, V>> put(S range, V value) {
                if (value != null) {
                    DefaultSpanMap.this.spanTree.put(range.min(), Map.entry(range, value));
                }
                return null;
            }
        }
    }

    public static abstract class SpanMapSetter<E, N, S extends Span<N, S>, V>
    extends RangeMapSetter<E, N, S, V> {
        protected abstract Domain<N, S> domain();

        @Override
        protected int compare(N d1, N d2) {
            return this.domain().compare(d1, d2);
        }

        @Override
        protected N getLower(S range) {
            return range.min();
        }

        @Override
        protected N getUpper(S range) {
            return range.max();
        }

        @Override
        protected S toSpan(N lower, N upper) {
            return this.domain().closed(lower, upper);
        }

        @Override
        protected N getPrevious(N d) {
            if (this.domain().min().equals(d)) {
                return null;
            }
            return this.domain().dec(d);
        }

        @Override
        protected N getNext(N d) {
            if (this.domain().max().equals(d)) {
                return null;
            }
            return this.domain().inc(d);
        }
    }

    public static interface MutableSpanSet<N, S extends Span<N, S>>
    extends SpanSet<N, S> {
        public void add(S var1);

        public void addAll(SpanSet<N, S> var1);

        public void remove(S var1);

        public void clear();
    }

    public static interface SpanSet<N, S extends Span<N, S>> {
        public boolean isEmpty();

        public Iterable<S> spans();

        public S bound();

        public boolean contains(N var1);

        public S spanContaining(N var1);

        public Iterable<S> intersecting(S var1);

        default public Iterable<S> complement(S s) {
            Domain dom = s.domain();
            Object min = s.min();
            ArrayList result = new ArrayList();
            for (Span i : this.intersecting(s)) {
                if (dom.compare(i.min(), min) > 0) {
                    result.add(dom.closed(min, dom.dec(i.min())));
                }
                if (!i.maxIsFinite()) {
                    return result;
                }
                min = dom.inc(i.max());
            }
            if (dom.compare(min, s.max()) <= 0) {
                result.add(dom.closed(min, s.max()));
            }
            return result;
        }

        public boolean intersects(S var1);

        default public boolean encloses(S s) {
            S c = this.spanContaining(s.min());
            if (c == null) {
                return false;
            }
            return c.contains(s.max());
        }
    }

    public static interface MutableSpanMap<N, S extends Span<N, S>, V>
    extends SpanMap<N, S, V> {
        public void put(S var1, V var2);

        public void putAll(SpanMap<N, S, V> var1);

        public void remove(S var1);

        public void clear();
    }

    public static interface SpanMap<N, S extends Span<N, S>, V> {
        public boolean isEmpty();

        public Set<S> spans();

        public Collection<V> values();

        public S bound();

        public Set<Map.Entry<S, V>> entries();

        public Map.Entry<S, V> getEntry(N var1);

        public V get(N var1);

        public Iterable<Map.Entry<S, V>> intersectingEntries(S var1);

        public Iterable<S> intersectingSpans(S var1);

        public boolean intersects(S var1);
    }

    public static interface Empty<N, S extends Span<N, S>>
    extends Span<N, S> {
        @Override
        default public N min() {
            throw new NoSuchElementException();
        }

        @Override
        default public N max() {
            throw new NoSuchElementException();
        }

        @Override
        default public boolean isEmpty() {
            return true;
        }

        @Override
        default public boolean contains(N c) {
            return false;
        }
    }
}

