/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.DefaultPcodeThread;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeStateInitializer;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.emu.SparseAddressRangeMap;
import ghidra.pcode.exec.ConcretionError;
import ghidra.pcode.exec.InterruptPcodeExecutionException;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.util.classfinder.ClassSearcher;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractPcodeMachine<T>
implements PcodeMachine<T> {
    protected final SleighLanguage language;
    protected final PcodeArithmetic<T> arithmetic;
    protected final PcodeUseropLibrary<T> library;
    protected final PcodeUseropLibrary<T> stubLibrary;
    protected PcodeMachine.SwiMode swiMode = PcodeMachine.SwiMode.ACTIVE;
    PcodeStateInitializer initializer;
    private PcodeExecutorState<T> sharedState;
    protected final Map<String, PcodeThread<T>> threads = new LinkedHashMap<String, PcodeThread<T>>();
    protected final Collection<PcodeThread<T>> threadsView = Collections.unmodifiableCollection(this.threads.values());
    protected volatile boolean suspended = false;
    protected final Map<Address, PcodeProgram> injects = new HashMap<Address, PcodeProgram>();
    protected final SparseAddressRangeMap<PcodeMachine.AccessKind> accessBreakpoints = new SparseAddressRangeMap();

    protected static SleighLanguage assertSleigh(Language language) {
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Emulation requires a sleigh language");
        }
        return (SleighLanguage)language;
    }

    public AbstractPcodeMachine(Language language) {
        this.language = AbstractPcodeMachine.assertSleigh(language);
        this.arithmetic = this.createArithmetic();
        this.library = this.createUseropLibrary();
        this.stubLibrary = this.createThreadStubLibrary().compose(this.library);
        this.initializer = AbstractPcodeMachine.getPluggableInitializer(language);
    }

    protected abstract PcodeArithmetic<T> createArithmetic();

    protected abstract PcodeUseropLibrary<T> createUseropLibrary();

    @Override
    public SleighLanguage getLanguage() {
        return this.language;
    }

    @Override
    public PcodeArithmetic<T> getArithmetic() {
        return this.arithmetic;
    }

    @Override
    public PcodeUseropLibrary<T> getUseropLibrary() {
        return this.library;
    }

    @Override
    public PcodeUseropLibrary<T> getStubUseropLibrary() {
        return this.stubLibrary;
    }

    protected abstract PcodeExecutorState<T> createSharedState();

    protected abstract PcodeExecutorState<T> createLocalState(PcodeThread<T> var1);

    protected PcodeUseropLibrary<T> createThreadStubLibrary() {
        return new DefaultPcodeThread.PcodeEmulationLibrary(null);
    }

    @Override
    public void setSoftwareInterruptMode(PcodeMachine.SwiMode mode) {
        this.swiMode = mode;
    }

    @Override
    public PcodeMachine.SwiMode getSoftwareInterruptMode() {
        return this.swiMode;
    }

    protected PcodeThread<T> createThread(String name) {
        return new DefaultPcodeThread(name, this);
    }

    protected static PcodeStateInitializer getPluggableInitializer(Language language) {
        for (PcodeStateInitializer init : ClassSearcher.getInstances(PcodeStateInitializer.class)) {
            if (!init.isApplicable(language)) continue;
            return init;
        }
        return null;
    }

    protected void doPluggableInitialization() {
        if (this.initializer != null) {
            this.initializer.initializeMachine(this);
        }
    }

    @Override
    public PcodeThread<T> newThread() {
        return this.newThread("Thread " + this.threads.size());
    }

    @Override
    public PcodeThread<T> newThread(String name) {
        if (this.threads.containsKey(name)) {
            throw new IllegalStateException("Thread with name '" + name + "' already exists");
        }
        PcodeThread<T> thread = this.createThread(name);
        this.threads.put(name, thread);
        return thread;
    }

    @Override
    public PcodeThread<T> getThread(String name, boolean createIfAbsent) {
        PcodeThread<T> thread = this.threads.get(name);
        if (thread == null && createIfAbsent) {
            thread = this.newThread(name);
        }
        return thread;
    }

    @Override
    public Collection<? extends PcodeThread<T>> getAllThreads() {
        return this.threadsView;
    }

    @Override
    public PcodeExecutorState<T> getSharedState() {
        if (this.sharedState == null) {
            this.sharedState = this.createSharedState();
            this.doPluggableInitialization();
        }
        return this.sharedState;
    }

    @Override
    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    @Override
    public boolean isSuspended() {
        return this.suspended;
    }

    protected PcodeProgram getInject(Address address) {
        return this.injects.get(address);
    }

    @Override
    public PcodeProgram compileSleigh(String sourceName, String source) {
        return SleighProgramCompiler.compileProgram(this.language, sourceName, source, this.stubLibrary);
    }

    @Override
    public void inject(Address address, String source) {
        PcodeProgram pcode = this.compileSleigh("machine_inject:" + String.valueOf(address), source);
        this.injects.put(address, pcode);
    }

    @Override
    public void clearInject(Address address) {
        this.injects.remove(address);
    }

    @Override
    public void clearAllInjects() {
        this.injects.clear();
    }

    @Override
    public void addBreakpoint(Address address, String sleighCondition) {
        PcodeProgram pcode = this.compileSleigh("breakpoint:" + String.valueOf(address), String.format("if (!(%s)) goto <nobreak>;\n\temu_swi();\n<nobreak>\n\temu_exec_decoded();\n", sleighCondition));
        this.injects.put(address, pcode);
    }

    @Override
    public void addAccessBreakpoint(AddressRange range, PcodeMachine.AccessKind kind) {
        this.accessBreakpoints.put(range, kind);
    }

    @Override
    public void clearAccessBreakpoints() {
        this.accessBreakpoints.clear();
    }

    protected void checkLoad(AddressSpace space, T offset, int size) {
        if (this.accessBreakpoints.isEmpty()) {
            return;
        }
        try {
            long concrete = this.arithmetic.toLong(offset, PcodeArithmetic.Purpose.LOAD);
            if (this.accessBreakpoints.hasEntry(space.getAddress(concrete), PcodeMachine.AccessKind::trapsRead)) {
                throw new InterruptPcodeExecutionException(null, null);
            }
        }
        catch (ConcretionError concretionError) {
            // empty catch block
        }
    }

    protected void checkStore(AddressSpace space, T offset, int size) {
        if (this.accessBreakpoints.isEmpty()) {
            return;
        }
        try {
            long concrete = this.arithmetic.toLong(offset, PcodeArithmetic.Purpose.LOAD);
            if (this.accessBreakpoints.hasEntry(space.getAddress(concrete), PcodeMachine.AccessKind::trapsWrite)) {
                throw new InterruptPcodeExecutionException(null, null);
            }
        }
        catch (ConcretionError concretionError) {
            // empty catch block
        }
    }

    protected void swi() {
        if (this.swiMode == PcodeMachine.SwiMode.ACTIVE) {
            throw new InterruptPcodeExecutionException(null, null);
        }
    }

    protected void stepped() {
        if (this.swiMode == PcodeMachine.SwiMode.IGNORE_STEP) {
            this.swiMode = PcodeMachine.SwiMode.ACTIVE;
        }
    }
}

