/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import generic.ULongSpan;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.util.Msg;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BytesPcodeExecutorStateSpace<B> {
    protected static final byte[] EMPTY = new byte[0];
    protected final SemisparseByteArray bytes;
    protected final Language language;
    protected final AddressSpace space;
    protected final B backing;

    public BytesPcodeExecutorStateSpace(Language language, AddressSpace space, B backing) {
        this.language = language;
        this.space = space;
        this.backing = backing;
        this.bytes = new SemisparseByteArray();
    }

    protected BytesPcodeExecutorStateSpace(Language language, AddressSpace space, B backing, SemisparseByteArray bytes) {
        this.language = language;
        this.space = space;
        this.backing = backing;
        this.bytes = bytes;
    }

    public BytesPcodeExecutorStateSpace<B> fork() {
        return new BytesPcodeExecutorStateSpace<B>(this.language, this.space, this.backing, this.bytes.fork());
    }

    public void write(long offset, byte[] val, int srcOffset, int length) {
        this.bytes.putData(offset, val, srcOffset, length);
    }

    protected ULongSpan.ULongSpanSet readUninitializedFromBacking(ULongSpan.ULongSpanSet uninitialized) {
        return uninitialized;
    }

    protected byte[] readBytes(long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        byte[] data = new byte[size];
        this.bytes.getData(offset, data);
        return data;
    }

    protected AddressRange addrRng(ULongSpan span) {
        return new AddressRangeImpl(this.space.getAddress(((Long)span.min()).longValue()), this.space.getAddress(((Long)span.max()).longValue()));
    }

    protected ULongSpan spanRng(AddressRange range) {
        return ULongSpan.span(range.getMinAddress().getOffset(), range.getMaxAddress().getOffset());
    }

    protected AddressSet addrSet(ULongSpan.ULongSpanSet set) {
        AddressSet result = new AddressSet();
        for (ULongSpan span : set.spans()) {
            result.add(this.addrRng(span));
        }
        return result;
    }

    protected ULongSpan.ULongSpanSet spanSet(AddressSetView set) {
        ULongSpan.DefaultULongSpanSet result = new ULongSpan.DefaultULongSpanSet();
        for (AddressRange range : set) {
            result.add(this.spanRng(range));
        }
        return result;
    }

    protected Set<Register> getRegs(AddressSetView set) {
        TreeSet<Register> regs = new TreeSet<Register>();
        for (AddressRange rng : set) {
            Register r = this.language.getRegister(rng.getMinAddress(), (int)rng.getLength());
            if (r != null) {
                regs.add(r);
                continue;
            }
            regs.addAll(Arrays.asList(this.language.getRegisters(rng.getMinAddress())));
        }
        return regs;
    }

    protected void warnAddressSet(String message, AddressSetView set) {
        Set<Register> regs = this.getRegs(set);
        if (regs.isEmpty()) {
            Msg.warn((Object)this, (Object)(message + ": " + String.valueOf(set)));
        } else {
            Msg.warn((Object)this, (Object)(message + ": " + String.valueOf(set) + " (registers " + String.valueOf(regs) + ")"));
        }
    }

    protected void warnUninit(ULongSpan.ULongSpanSet uninit) {
        AddressSet uninitialized = this.addrSet(uninit);
        this.warnAddressSet("Emulator read from uninitialized state", (AddressSetView)uninitialized);
    }

    public byte[] read(long offset, int size, PcodeExecutorStatePiece.Reason reason) {
        ULongSpan init;
        Iterator<ULongSpan> it;
        ULongSpan.ULongSpanSet uninitialized = this.bytes.getUninitialized(offset, offset + (long)size - 1L);
        if (uninitialized.isEmpty()) {
            return this.readBytes(offset, size, reason);
        }
        if (this.backing != null && (uninitialized = this.readUninitializedFromBacking(uninitialized)).isEmpty()) {
            return this.readBytes(offset, size, reason);
        }
        if (reason == PcodeExecutorStatePiece.Reason.EXECUTE_DECODE && (it = uninitialized.complement(ULongSpan.extent(offset, size)).iterator()).hasNext() && (Long)(init = it.next()).min() == offset) {
            return this.readBytes(offset, (int)init.length(), reason);
        }
        if (reason == PcodeExecutorStatePiece.Reason.EXECUTE_READ) {
            this.warnUninit(uninitialized);
        } else if (reason == PcodeExecutorStatePiece.Reason.EXECUTE_DECODE) {
            return EMPTY;
        }
        return this.readBytes(offset, size, reason);
    }

    public Map<Register, byte[]> getRegisterValues(List<Register> registers) {
        HashMap<Register, byte[]> result = new HashMap<Register, byte[]>();
        for (Register reg : registers) {
            long max;
            long min = reg.getAddress().getOffset();
            if (!this.bytes.isInitialized(min, max = min + (long)reg.getNumBytes())) continue;
            byte[] data = new byte[reg.getNumBytes()];
            this.bytes.getData(min, data);
            result.put(reg, data);
        }
        return result;
    }

    public void clear() {
        this.bytes.clear();
    }
}

