/*
 * Decompiled with CFR 0.152.
 */
package ghidra.jython;

import ghidra.framework.Application;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import utilities.util.FileUtilities;

public class JythonUtils {
    public static final String JYTHON_NAME = "jython-2.7.3";
    public static final String JYTHON_CACHEDIR = "jython_cachedir";
    public static final String JYTHON_SRC = "jython-src";

    public static File setupJythonHomeDir() throws IOException {
        File jythonModuleDir = Application.getMyModuleRootDirectory().getFile(false);
        File jythonHomeDir = Application.getModuleDataSubDirectory((String)jythonModuleDir.getName(), (String)JYTHON_NAME).getFile(false);
        if (!jythonHomeDir.exists()) {
            throw new IOException("Failed to find the jython home directory at: " + String.valueOf(jythonHomeDir));
        }
        System.setProperty("jython.home", jythonHomeDir.getAbsolutePath());
        return jythonHomeDir;
    }

    public static File setupJythonCacheDir(TaskMonitor monitor) throws CancelledException, IOException {
        File devDir = new File(Application.getUserSettingsDirectory(), "dev");
        File cacheDir = new File(devDir, JYTHON_CACHEDIR);
        if (!FileUtilities.mkdirs((File)cacheDir)) {
            throw new IOException("Failed to create the jython cache directory at: " + String.valueOf(cacheDir));
        }
        File jythonSrcDestDir = new File(cacheDir, JYTHON_SRC);
        if (!FileUtilities.createDir((File)jythonSrcDestDir)) {
            throw new IOException("Failed to create the jython-src directory at: " + String.valueOf(jythonSrcDestDir));
        }
        File jythonModuleDir = Application.getMyModuleRootDirectory().getFile(false);
        File jythonSrcDir = new File(jythonModuleDir, JYTHON_SRC);
        if (!jythonSrcDir.exists()) {
            try {
                jythonSrcDir = Application.getModuleDataSubDirectory((String)jythonModuleDir.getName(), (String)JYTHON_SRC).getFile(false);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Failed to find the module's jython-src directory");
            }
        }
        try {
            FileUtilities.copyDir((File)jythonSrcDir, (File)jythonSrcDestDir, f -> f.getName().endsWith(".py"), (TaskMonitor)monitor);
        }
        catch (IOException e) {
            throw new IOException("Failed to copy jython-src files to: " + String.valueOf(jythonSrcDestDir));
        }
        System.setProperty("python.cachedir.skip", "false");
        System.setProperty("python.cachedir", cacheDir.getAbsolutePath());
        System.setProperty("python.path", jythonSrcDestDir.getAbsolutePath());
        return cacheDir;
    }
}

