/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.options.OptionsService;
import generic.theme.GIcon;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.features.base.codecompare.panel.CodeComparisonPanel;
import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.features.codecompare.decompile.CDisplay;
import ghidra.features.codecompare.decompile.CodeDiffFieldPanelCoordinator;
import ghidra.features.codecompare.decompile.CompareFuncsFromMatchedTokensAction;
import ghidra.features.codecompare.decompile.DecompileDataDiff;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonOptions;
import ghidra.features.codecompare.decompile.DecompilerDiffViewFindAction;
import ghidra.features.codecompare.decompile.DetermineDecompilerDifferencesTask;
import ghidra.features.codecompare.decompile.DiffClangHighlightController;
import ghidra.features.codecompare.decompile.DualDecompilerActionContext;
import ghidra.features.codecompare.graphanalysis.TokenBin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Duo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import resources.Icons;
import resources.MultiIcon;

public class DecompilerCodeComparisonPanel
extends CodeComparisonPanel {
    public static final String NAME = "Decompiler View";
    private boolean isStale = true;
    private Duo<CDisplay> cDisplays = new Duo();
    private DecompilerCodeComparisonOptions comparisonOptions;
    private CodeDiffFieldPanelCoordinator coordinator;
    private DecompileDataDiff decompileDataDiff;
    private ToggleExactConstantMatching toggleExactConstantMatchingAction;
    private List<DockingAction> actions = new ArrayList<DockingAction>();
    private Duo<Function> functions = new Duo();

    public DecompilerCodeComparisonPanel(String owner, PluginTool tool) {
        super(owner, tool);
        this.comparisonOptions = new DecompilerCodeComparisonOptions(tool, () -> this.repaint());
        this.cDisplays = new Duo((Object)this.buildCDisplay(Duo.Side.LEFT), (Object)this.buildCDisplay(Duo.Side.RIGHT));
        ((CDisplay)this.cDisplays.get(Duo.Side.LEFT)).initializeOptions(tool, this.getFunction(Duo.Side.LEFT));
        ((CDisplay)this.cDisplays.get(Duo.Side.RIGHT)).initializeOptions(tool, this.getFunction(Duo.Side.RIGHT));
        this.buildPanel();
        this.setSynchronizedScrolling(true);
        this.linkHighlightControllers();
        this.createActions();
    }

    public String getName() {
        return NAME;
    }

    protected void comparisonDataChanged() {
        this.maybeLoadFunction(Duo.Side.LEFT, ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getFunction());
        this.maybeLoadFunction(Duo.Side.RIGHT, ((ComparisonData)this.comparisonData.get(Duo.Side.RIGHT)).getFunction());
        if (this.coordinator != null) {
            this.coordinator.leftLocationChanged(null);
        }
    }

    public void maybeLoadFunction(Duo.Side side, Function function) {
        if (this.functions.get(side) == function) {
            return;
        }
        this.loadFunction(side, null);
        this.loadFunction(side, function);
    }

    public void dispose() {
        this.setSynchronizedScrolling(false);
        this.cDisplays.each(CDisplay::dispose);
        this.comparisonOptions = null;
    }

    public CDisplay getActiveDisplay() {
        return (CDisplay)this.cDisplays.get(this.activeSide);
    }

    public CDisplay getLeftPanel() {
        return (CDisplay)this.cDisplays.get(Duo.Side.LEFT);
    }

    public CDisplay getRightPanel() {
        return (CDisplay)this.cDisplays.get(Duo.Side.RIGHT);
    }

    public List<DockingAction> getActions() {
        List allActions = super.getActions();
        allActions.addAll(this.actions);
        return allActions;
    }

    public ActionContext getActionContext(ComponentProvider provider, MouseEvent event) {
        Component component = event != null ? event.getComponent() : this.getActiveDisplay().getDecompilerPanel().getFieldPanel();
        DualDecompilerActionContext dualDecompContext = new DualDecompilerActionContext(provider, this, component);
        return dualDecompContext;
    }

    public void programClosed(Program program) {
        this.cDisplays.each(c -> c.programClosed(program));
    }

    public JComponent getComparisonComponent(Duo.Side side) {
        return ((CDisplay)this.cDisplays.get(side)).getDecompilerPanel();
    }

    private void createActions() {
        this.toggleExactConstantMatchingAction = new ToggleExactConstantMatching(((Object)((Object)this)).getClass().getName());
        this.actions.add(new DecompilerDiffViewFindAction(this.owner, this.tool));
        this.actions.add(new DecompilerCodeComparisonOptionsAction());
        this.actions.add((DockingAction)this.toggleExactConstantMatchingAction);
        this.actions.add(new CompareFuncsFromMatchedTokensAction(this, this.tool));
    }

    private void decompileDataSet(Duo.Side side, DecompileData dcompileData) {
        ((CDisplay)this.cDisplays.get(side)).restoreCursorPosition();
        this.updateDiffs();
    }

    private boolean isMatchingConstantsExactly() {
        return !this.toggleExactConstantMatchingAction.isSelected();
    }

    private void loadFunction(Duo.Side side, Function function) {
        if (this.functions.get(side) != function) {
            this.functions = this.functions.with(side, (Object)function);
            ((CDisplay)this.cDisplays.get(side)).showFunction(this.tool, function);
        }
    }

    private void locationChanged(Duo.Side side, ProgramLocation location) {
        if (this.coordinator != null) {
            if (side == Duo.Side.LEFT) {
                this.coordinator.leftLocationChanged(location);
            } else {
                this.coordinator.rightLocationChanged(location);
            }
        }
    }

    private void updateDiffs() {
        DecompileData leftDecompileData = ((CDisplay)this.cDisplays.get(Duo.Side.LEFT)).getDecompileData();
        DecompileData rightDecompileData = ((CDisplay)this.cDisplays.get(Duo.Side.RIGHT)).getDecompileData();
        if (this.isValid(leftDecompileData) && this.isValid(rightDecompileData)) {
            this.decompileDataDiff = new DecompileDataDiff(leftDecompileData, rightDecompileData);
            this.determineDecompilerDifferences();
        }
    }

    private boolean isValid(DecompileData decompileData) {
        return decompileData != null && decompileData.isValid();
    }

    private CDisplay buildCDisplay(Duo.Side side) {
        return new CDisplay(this.comparisonOptions, decompileData -> this.decompileDataSet(side, decompileData), l -> this.locationChanged(side, (ProgramLocation)l));
    }

    private void linkHighlightControllers() {
        DiffClangHighlightController left = ((CDisplay)this.cDisplays.get(Duo.Side.LEFT)).getHighlightController();
        DiffClangHighlightController right = ((CDisplay)this.cDisplays.get(Duo.Side.RIGHT)).getHighlightController();
        left.addListener(right);
        right.addListener(left);
    }

    public void setSynchronizedScrolling(boolean synchronize) {
        if (this.coordinator != null) {
            this.coordinator.dispose();
            this.coordinator = null;
        }
        if (synchronize) {
            this.coordinator = this.createCoordinator();
            this.doSynchronize();
        }
    }

    private void doSynchronize() {
        CDisplay activeDisplay = this.getActiveDisplay();
        ProgramLocation programLocation = activeDisplay.getDecompilerPanel().getCurrentLocation();
        if (activeDisplay == this.cDisplays.get(Duo.Side.LEFT)) {
            this.coordinator.leftLocationChanged(programLocation);
        } else {
            this.coordinator.rightLocationChanged(programLocation);
        }
    }

    private CodeDiffFieldPanelCoordinator createCoordinator() {
        CodeDiffFieldPanelCoordinator panelCoordinator = new CodeDiffFieldPanelCoordinator(this);
        if (this.decompileDataDiff != null) {
            TaskBuilder.withRunnable(monitor -> {
                try {
                    panelCoordinator.replaceDecompileDataDiff(this.decompileDataDiff, this.isMatchingConstantsExactly(), monitor);
                }
                catch (CancelledException e) {
                    panelCoordinator.clearLineNumberPairing();
                }
            }).setTitle("Initializing Code Compare").launchNonModal();
        }
        return panelCoordinator;
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b && this.isStale) {
            this.determineDecompilerDifferences();
            this.isStale = false;
        }
        this.updateActionEnablement();
    }

    List<TokenBin> getHighBins() {
        return this.coordinator == null ? null : this.coordinator.getHighBins();
    }

    private void determineDecompilerDifferences() {
        if (this.decompileDataDiff == null) {
            return;
        }
        DiffClangHighlightController leftHighlights = ((CDisplay)this.cDisplays.get(Duo.Side.LEFT)).getHighlightController();
        DiffClangHighlightController rightHighlights = ((CDisplay)this.cDisplays.get(Duo.Side.RIGHT)).getHighlightController();
        DetermineDecompilerDifferencesTask task = new DetermineDecompilerDifferencesTask(this.decompileDataDiff, this.isMatchingConstantsExactly(), leftHighlights, rightHighlights, this.coordinator);
        new TaskLauncher((Task)task, (Component)((Object)this));
    }

    public void updateActionEnablement() {
        this.toggleExactConstantMatchingAction.setEnabled(this.isVisible());
    }

    public boolean isBusy() {
        return ((CDisplay)this.cDisplays.get(Duo.Side.LEFT)).isBusy() || ((CDisplay)this.cDisplays.get(Duo.Side.RIGHT)).isBusy();
    }

    public DecompilerPanel getDecompilerPanel(Duo.Side side) {
        return ((CDisplay)this.cDisplays.get(side)).getDecompilerPanel();
    }

    public class ToggleExactConstantMatching
    extends ToggleDockingAction {
        private final Icon EXACT_CONSTANT_MATCHING_ICON;
        private final Icon NO_EXACT_CONSTANT_MATCHING_ICON;

        public ToggleExactConstantMatching(String owner) {
            super("Toggle Exact Constant Matching", owner);
            this.EXACT_CONSTANT_MATCHING_ICON = new GIcon("icon.base.source.c");
            this.NO_EXACT_CONSTANT_MATCHING_ICON = new MultiIcon(this.EXACT_CONSTANT_MATCHING_ICON, new Icon[]{Icons.NOT_ALLOWED_ICON});
            this.setHelpLocation(new HelpLocation("FunctionComparison", "Toggle Exact Constant Matching"));
            this.setToolBarData(new ToolBarData(this.NO_EXACT_CONSTANT_MATCHING_ICON, "toggles"));
            this.setDescription(HTMLUtilities.toHTML((String)"Toggle whether or not constants must\nbe exactly the same value to be a match\nin the Decomiler Diff View."));
            this.setSelected(false);
            this.setEnabled(true);
        }

        public boolean isEnabledForContext(ActionContext context) {
            return context instanceof DualDecompilerActionContext;
        }

        public void actionPerformed(ActionContext context) {
            if (DecompilerCodeComparisonPanel.this.isVisible()) {
                DecompilerCodeComparisonPanel.this.determineDecompilerDifferences();
            }
        }

        public void setSelected(boolean selected) {
            this.getToolBarData().setIcon(selected ? this.NO_EXACT_CONSTANT_MATCHING_ICON : this.EXACT_CONSTANT_MATCHING_ICON);
            super.setSelected(selected);
        }
    }

    private class DecompilerCodeComparisonOptionsAction
    extends DockingAction {
        DecompilerCodeComparisonOptionsAction() {
            super("Decompiler Code Comparison Options", DecompilerCodeComparisonPanel.this.owner);
            this.setDescription("Show the tool options for the Decompiler Code Comparison.");
            this.setPopupMenuData(new MenuData(new String[]{"Properties"}, null, "Z_Properties"));
            this.setHelpLocation(new HelpLocation("FunctionComparison", "Decompiler_Code_Comparison_Options"));
        }

        public boolean isEnabledForContext(ActionContext context) {
            return context instanceof DualDecompilerActionContext;
        }

        public void actionPerformed(ActionContext context) {
            OptionsService service = (OptionsService)DecompilerCodeComparisonPanel.this.tool.getService(OptionsService.class);
            service.showOptionsDialog("FunctionComparison", "Decompiler Code Comparison");
        }
    }
}

