/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.FindDialog;
import docking.widgets.FindDialogSearcher;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearcher;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonPanel;
import ghidra.features.codecompare.decompile.DualDecompilerActionContext;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Duo;
import org.apache.commons.lang3.StringUtils;

public class DecompilerDiffViewFindAction
extends DockingAction {
    private Duo<FindDialog> findDialogs;
    private PluginTool tool;

    public DecompilerDiffViewFindAction(String owner, PluginTool tool) {
        super("Find", owner, true);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFind"));
        this.setPopupMenuData(new MenuData(new String[]{"Find..."}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(70, DockingUtils.CONTROL_KEY_MODIFIER_MASK));
        this.setEnabled(true);
        this.tool = tool;
    }

    public boolean isAddToPopup(ActionContext context) {
        return context instanceof DualDecompilerActionContext;
    }

    public boolean isEnabledForContext(ActionContext context) {
        return context instanceof DualDecompilerActionContext;
    }

    public void actionPerformed(ActionContext context) {
        String text;
        DualDecompilerActionContext dualContext = (DualDecompilerActionContext)context;
        DecompilerCodeComparisonPanel decompilerCompPanel = dualContext.getCodeComparisonPanel();
        Duo.Side focusedSide = decompilerCompPanel.getActiveSide();
        DecompilerPanel focusedPanel = decompilerCompPanel.getDecompilerPanel(focusedSide);
        FindDialog dialog = (FindDialog)this.findDialogs.get(focusedSide);
        if (dialog == null) {
            dialog = this.createFindDialog(focusedPanel, focusedSide);
            this.findDialogs = this.findDialogs.with(focusedSide, (Object)dialog);
        }
        if (!StringUtils.isBlank((CharSequence)(text = focusedPanel.getSelectedText()))) {
            dialog.setSearchText(text);
        }
        this.tool.showDialog((DialogComponentProvider)dialog);
    }

    private FindDialog createFindDialog(final DecompilerPanel decompilerPanel, Duo.Side side) {
        Object title = side == Duo.Side.LEFT ? "Left" : "Right";
        title = (String)title + " Decompiler Find Text";
        FindDialog dialog = new FindDialog(this, (String)title, (FindDialogSearcher)new DecompilerSearcher(decompilerPanel)){

            protected void dialogClosed() {
                decompilerPanel.setSearchResults(null);
            }
        };
        dialog.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFind"));
        return dialog;
    }
}

