/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.graphanalysis;

import ghidra.features.codecompare.graphanalysis.DataVertex;
import ghidra.features.codecompare.graphanalysis.Pinning;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataGraph {
    Pinning.Side side;
    HighFunction hfunc;
    ArrayList<DataVertex> nodeList;
    Map<PcodeOpAST, DataVertex> opToVert;
    Map<VarnodeAST, DataVertex> vnToVert;
    Map<Associate, ArrayList<DataVertex>> associates;
    boolean constCaring;
    boolean ramCaring;
    boolean sizeCollapse;
    int pointerSize;
    long pointerMin;

    public DataGraph(Pinning.Side side, HighFunction hfunc, boolean constCaring, boolean ramCaring, boolean castCollapse, boolean sizeCollapse) {
        this.side = side;
        this.constCaring = constCaring;
        this.ramCaring = ramCaring;
        this.sizeCollapse = sizeCollapse;
        this.pointerSize = hfunc.getFunction().getProgram().getDefaultPointerSize();
        this.pointerMin = this.pointerSize < 3 ? 255L : 65535L;
        ArrayList<DataVertex> ptrsubs = new ArrayList<DataVertex>();
        ArrayList<DataVertex> casts = new ArrayList<DataVertex>();
        this.nodeList = new ArrayList();
        this.hfunc = hfunc;
        this.opToVert = new HashMap<PcodeOpAST, DataVertex>();
        this.vnToVert = new HashMap<VarnodeAST, DataVertex>();
        this.associates = new HashMap<Associate, ArrayList<DataVertex>>();
        int uidCounter = 0;
        Iterator vnIter = this.hfunc.locRange();
        while (vnIter.hasNext()) {
            VarnodeAST currentVn = (VarnodeAST)vnIter.next();
            if (currentVn.getDef() == null && currentVn.hasNoDescend()) continue;
            DataVertex temp = new DataVertex(currentVn, this, uidCounter++);
            this.nodeList.add(temp);
            this.vnToVert.put(currentVn, temp);
        }
        Iterator opIter = this.hfunc.getPcodeOps();
        while (opIter.hasNext()) {
            PcodeOpAST currentOp = (PcodeOpAST)opIter.next();
            DataVertex temp = new DataVertex(currentOp, this, uidCounter++);
            this.nodeList.add(temp);
            this.opToVert.put(currentOp, temp);
            if (currentOp.getOpcode() == 66) {
                ptrsubs.add(temp);
            }
            if (currentOp.getOpcode() != 64) continue;
            casts.add(temp);
        }
        opIter = this.hfunc.getPcodeOps();
        while (opIter.hasNext()) {
            PcodeOpAST op = (PcodeOpAST)opIter.next();
            DataVertex node = this.opToVert.get(op);
            for (int i = 0; i < op.getNumInputs(); ++i) {
                DataVertex sourceNode = this.vnToVert.get(op.getInput(i));
                if (sourceNode == null) continue;
                node.sources.add(sourceNode);
                sourceNode.sinks.add(node);
            }
            DataVertex sinkNode = this.vnToVert.get(op.getOutput());
            if (sinkNode == null) continue;
            node.sinks.add(sinkNode);
            sinkNode.sources.add(node);
        }
        this.eliminatePtrsubs(ptrsubs);
        if (castCollapse) {
            this.eliminateCasts(casts);
        }
    }

    public HighFunction getHighFunction() {
        return this.hfunc;
    }

    public boolean isConstantNonPointer(Varnode vn) {
        if (!vn.isConstant()) {
            return false;
        }
        if (vn.getSize() != this.pointerSize) {
            return true;
        }
        long off = vn.getOffset();
        return off >= 0L && off <= this.pointerMin;
    }

    private void eliminatePtrsubs(ArrayList<DataVertex> ptrsubs) {
        for (DataVertex subop : ptrsubs) {
            DataVertex in0Node = subop.sources.get(0);
            if (!in0Node.vn.isConstant() || in0Node.vn.getOffset() != 0L) continue;
            DataVertex in1Node = subop.sources.get(1);
            DataVertex outNode = subop.sinks.get(0);
            in1Node.sinks.clear();
            this.replaceNodeInOutEdges(outNode, in1Node);
            in0Node.collapse();
            subop.collapse();
            outNode.collapse();
            this.makeAssociation(subop, outNode, in1Node, 0);
        }
    }

    private void eliminateCasts(ArrayList<DataVertex> casts) {
        for (DataVertex castNode : casts) {
            DataVertex in = castNode.sources.get(0);
            DataVertex out = castNode.sinks.get(0);
            DataVertex assoc = null;
            int assocSlot = 0;
            if (out.sinks.size() == 1) {
                assoc = out.sinks.get(0);
                for (assocSlot = 0; assocSlot < assoc.sources.size() && assoc.sources.get(assocSlot) != out; ++assocSlot) {
                }
            }
            boolean outCast = true;
            if (out.sinks.size() == 1 && out.vn.isUnique() || in.sources.size() == 0) {
                outCast = false;
            }
            if (outCast) {
                DataVertex topOp = in.sources.get(0);
                topOp.sinks.clear();
                out.sources.clear();
                topOp.sinks.add(out);
                out.sources.add(topOp);
                in.collapse();
                if (assoc == null) {
                    assoc = out;
                }
                this.makeAssociation(castNode, in, assoc, assocSlot);
            } else {
                this.removeInEdge(castNode, 0);
                this.replaceNodeInOutEdges(out, in);
                out.collapse();
                if (assoc == null) {
                    assoc = in;
                }
                this.makeAssociation(castNode, out, assoc, assocSlot);
            }
            castNode.collapse();
        }
    }

    public void makeNGrams(int numNGrams) {
        for (int i = 0; i < numNGrams - 1; ++i) {
            for (DataVertex node : this.nodeList) {
                if (node.isCollapsed()) continue;
                node.nextNGramSource(i);
            }
        }
    }

    private void makeAssociation(DataVertex op, DataVertex var, DataVertex assoc, int assocSlot) {
        Associate key = new Associate(assoc, assocSlot);
        ArrayList<DataVertex> assocList = this.associates.get(key);
        if (assocList == null) {
            assocList = new ArrayList();
            this.associates.put(key, assocList);
        }
        assocList.add(op);
        assocList.add(var);
    }

    private void replaceNodeInOutEdges(DataVertex node, DataVertex replacement) {
        for (DataVertex outNode : node.sinks) {
            for (int i = 0; i < outNode.sources.size(); ++i) {
                if (outNode.sources.get(i) != node) continue;
                outNode.sources.set(i, replacement);
            }
            replacement.sinks.add(outNode);
        }
        node.sinks = new ArrayList();
    }

    private void removeInEdge(DataVertex node, int inEdge) {
        int outEdge;
        DataVertex inNode = node.sources.get(inEdge);
        for (outEdge = 0; outEdge < inNode.sinks.size() && inNode.sinks.get(outEdge) != node; ++outEdge) {
        }
        node.sources.remove(inEdge);
        inNode.sinks.remove(outEdge);
    }

    public void dump(Writer writer) throws IOException {
        for (DataVertex vertex : this.nodeList) {
            writer.append(vertex.toString());
            writer.append('\n');
        }
    }

    public static class Associate {
        DataVertex node;
        int slot;

        public Associate(DataVertex n, int sl) {
            this.node = n;
            this.slot = sl;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Associate)) {
                return false;
            }
            Associate other = (Associate)obj;
            if (this.node.uid != other.node.uid) {
                return false;
            }
            return this.slot == other.slot;
        }

        public int hashCode() {
            int val = this.node.hashCode();
            val = val * 31 + this.slot;
            return val;
        }
    }
}

