/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.plugin;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.actions.PopupActionProvider;
import docking.widgets.dialogs.TableSelectionDialog;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GIcon;
import ghidra.app.plugin.core.functionwindow.FunctionTableModel;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.features.base.codecompare.listing.ListingCodeComparisonPanel;
import ghidra.features.base.codecompare.model.AnyToAnyFunctionComparisonModel;
import ghidra.features.base.codecompare.model.FunctionComparisonModel;
import ghidra.features.base.codecompare.model.FunctionComparisonModelListener;
import ghidra.features.base.codecompare.panel.CodeComparisonPanel;
import ghidra.features.base.codecompare.panel.FunctionComparisonPanel;
import ghidra.features.codecompare.plugin.FunctionComparisonPlugin;
import ghidra.features.codecompare.plugin.MultiFunctionComparisonPanel;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.datastruct.Duo;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import resources.Icons;
import util.CollectionUtils;
import utility.function.Callback;

public class FunctionComparisonProvider
extends ComponentProviderAdapter
implements PopupActionProvider,
FunctionComparisonModelListener {
    private static final String ADD_COMPARISON_GROUP = "A9_AddToComparison";
    private static final String NAV_GROUP = "A9 FunctionNavigate";
    private static final String REMOVE_FUNCTIONS_GROUP = "A9_RemoveFunctions";
    private static final Icon ADD_TO_COMPARISON_ICON = new GIcon("icon.plugin.functioncompare.open.function.table");
    private static final Icon NAV_FUNCTION_ICON = Icons.NAVIGATE_ON_INCOMING_EVENT_ICON;
    private static final Icon NEXT_FUNCTION_ICON = new GIcon("icon.plugin.functioncompare.function.next");
    private static final Icon PREVIOUS_FUNCTION_ICON = new GIcon("icon.plugin.functioncompare.function.previous");
    private static final Icon REMOVE_FUNCTION_ICON = new GIcon("icon.plugin.functioncompare.function.remove");
    private static final String HELP_TOPIC = "FunctionComparison";
    private FunctionComparisonPlugin plugin;
    private FunctionComparisonModel model;
    private MultiFunctionComparisonPanel functionComparisonPanel;
    private Callback closeListener = Callback.dummy();
    private ToggleDockingAction navigateToAction;

    public FunctionComparisonProvider(FunctionComparisonPlugin plugin, FunctionComparisonModel model, Callback closeListener) {
        super(plugin.getTool(), "Function Comparison Provider", plugin.getName());
        this.plugin = plugin;
        this.model = model;
        this.closeListener = Callback.dummyIfNull((Callback)closeListener);
        this.functionComparisonPanel = new MultiFunctionComparisonPanel(this, this.tool, model);
        model.addFunctionComparisonModelListener((FunctionComparisonModelListener)this);
        this.setTabText(this.functionComparisonPanel.getDescription());
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        this.setHelpLocation(new HelpLocation(HELP_TOPIC, "Function Comparison"));
        this.createActions();
        this.addSpecificCodeComparisonActions();
        this.setTransient();
        this.addToTool();
        this.setVisible(true);
    }

    public FunctionComparisonPanel getComponent() {
        return this.functionComparisonPanel;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("FunctionComparisonProvider\n");
        buff.append("Name: ");
        buff.append(this.getName() + "\n");
        buff.append("Tab Text: ");
        buff.append(this.getTabText() + "\n");
        buff.append(this.functionComparisonPanel.getDescription());
        buff.append("tool = " + String.valueOf(this.tool) + "\n");
        return buff.toString();
    }

    public ActionContext getActionContext(MouseEvent event) {
        CodeComparisonPanel currentComponent = this.functionComparisonPanel.getCurrentComponent();
        return currentComponent.getActionContext((ComponentProvider)this, event);
    }

    public void modelDataChanged() {
        this.updateTabAndTitle();
        this.tool.contextChanged((ComponentProvider)this);
        Swing.runLater(this::closeIfEmpty);
    }

    public void activeFunctionChanged(Duo.Side side, Function function) {
        this.updateTabAndTitle();
        this.tool.contextChanged((ComponentProvider)this);
        if (this.navigateToAction.isSelected()) {
            this.goToFunction(function);
        }
    }

    public void contextChanged() {
        super.contextChanged();
        this.maybeGoToActiveFunction();
    }

    public List<DockingActionIf> getPopupActions(Tool t, ActionContext context) {
        ListingCodeComparisonPanel dualListingPanel;
        if (context.getComponentProvider() == this && (dualListingPanel = this.functionComparisonPanel.getDualListingPanel()) != null) {
            ListingPanel leftPanel = dualListingPanel.getListingPanel(Duo.Side.LEFT);
            return leftPanel.getHeaderActions(this.getName());
        }
        return new ArrayList<DockingActionIf>();
    }

    public FunctionComparisonModel getModel() {
        return this.model;
    }

    public void programClosed(Program program) {
        this.functionComparisonPanel.programClosed(program);
        this.model.removeFunctions(program);
        this.closeIfEmpty();
    }

    public void removeFunctions(Program program) {
        this.model.removeFunctions(program);
        this.closeIfEmpty();
    }

    public void removeFunctions(Set<Function> functions) {
        this.model.removeFunctions(functions);
        this.closeIfEmpty();
    }

    public void programRestored(Program program) {
        CodeComparisonPanel comparePanel = this.functionComparisonPanel.getCurrentComponent();
        comparePanel.programRestored(program);
    }

    public void readConfigState(SaveState saveState) {
        this.functionComparisonPanel.readConfigState(this.getName(), saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.functionComparisonPanel.writeConfigState(this.getName(), saveState);
    }

    public void removeFromTool() {
        this.tool.removePopupActionProvider((PopupActionProvider)this);
        super.removeFromTool();
        this.dispose();
    }

    private void updateTabAndTitle() {
        String description = this.functionComparisonPanel.getDescription();
        this.setTabText(description);
        this.setTitle(description);
    }

    private void createActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Compare Next Function", this.plugin.getName()).description("Compare the next function for the side with focus.")).helpLocation(new HelpLocation(HELP_TOPIC, "Navigate Next"))).keyBinding("control shift N")).popupMenuPath(new String[]{"Compare Next Function"})).popupMenuGroup(NAV_GROUP)).toolBarIcon(NEXT_FUNCTION_ICON)).toolBarGroup(NAV_GROUP)).enabledWhen(c -> this.functionComparisonPanel.canCompareNextFunction())).onAction(c -> this.functionComparisonPanel.compareNextFunction())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Compare Previous Function", this.plugin.getName()).description("Compare the previous function for the side with focus.")).helpLocation(new HelpLocation(HELP_TOPIC, "Navigate Previous"))).keyBinding("control shift P")).popupMenuPath(new String[]{"Compare Previous Function"})).popupMenuGroup(NAV_GROUP)).toolBarIcon(PREVIOUS_FUNCTION_ICON)).toolBarGroup(NAV_GROUP)).enabledWhen(c -> this.functionComparisonPanel.canComparePreviousFunction())).onAction(c -> this.functionComparisonPanel.comparePreviousFunction())).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Remove Function", this.plugin.getName()).description("Removes the active function from the comparison")).helpLocation(new HelpLocation(HELP_TOPIC, "Remove_From_Comparison"))).keyBinding("control shift R")).popupMenuPath(new String[]{"Remove Function"})).popupMenuGroup(REMOVE_FUNCTIONS_GROUP)).toolBarIcon(REMOVE_FUNCTION_ICON)).toolBarGroup(REMOVE_FUNCTIONS_GROUP)).enabledWhen(c -> this.functionComparisonPanel.canRemoveActiveFunction())).onAction(c -> this.functionComparisonPanel.removeActiveFunction())).buildAndInstallLocal((ComponentProvider)this);
        this.navigateToAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Navigate to Selected Function", this.plugin.getName()).description(HTMLUtilities.toHTML((String)"Toggle <b>On</b> means to navigate to whatever function is selected in the comparison panel, when focus changes or a new function is selected."))).helpLocation(new HelpLocation(HELP_TOPIC, "Navigate_To_Function"))).toolBarIcon(NAV_FUNCTION_ICON)).onAction(c -> this.maybeGoToActiveFunction())).buildAndInstallLocal((ComponentProvider)this);
        if (this.model instanceof AnyToAnyFunctionComparisonModel) {
            this.createDefaultModelActions();
        }
    }

    private void createDefaultModelActions() {
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Add Functions To Comparison", this.plugin.getName()).description("Add functions to this comparison")).helpLocation(new HelpLocation(HELP_TOPIC, "Add_To_Comparison"))).popupMenuPath(new String[]{"Add Functions"})).popupMenuGroup(ADD_COMPARISON_GROUP)).toolBarIcon(ADD_TO_COMPARISON_ICON)).toolBarGroup(ADD_COMPARISON_GROUP)).enabledWhen(c -> this.model instanceof AnyToAnyFunctionComparisonModel)).onAction(c -> this.addFunctions())).buildAndInstallLocal((ComponentProvider)this);
    }

    private void addFunctions() {
        ProgramManager service = (ProgramManager)this.tool.getService(ProgramManager.class);
        Program currentProgram = service.getCurrentProgram();
        FunctionTableModel functionTableModel = new FunctionTableModel(this.tool, currentProgram);
        TableSelectionDialog diag = new TableSelectionDialog("Select Functions: " + currentProgram.getName(), (RowObjectTableModel)functionTableModel, true);
        this.tool.showDialog((DialogComponentProvider)diag);
        List rows = diag.getSelectionItems();
        if (CollectionUtils.isBlank((Collection)rows)) {
            return;
        }
        List functions = rows.stream().map(row -> row.getFunction()).collect(Collectors.toList());
        FunctionComparisonModel functionComparisonModel = this.model;
        if (functionComparisonModel instanceof AnyToAnyFunctionComparisonModel) {
            AnyToAnyFunctionComparisonModel defaultModel = (AnyToAnyFunctionComparisonModel)functionComparisonModel;
            defaultModel.addFunctions(functions);
        }
    }

    private void maybeGoToActiveFunction() {
        if (this.navigateToAction.isSelected()) {
            Duo.Side activeSide = this.functionComparisonPanel.getActiveSide();
            Function function = this.model.getActiveFunction(activeSide);
            this.goToFunction(function);
        }
    }

    private void goToFunction(Function function) {
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        if (goToService == null) {
            Msg.warn((Object)((Object)this), (Object)"Can't navigate to selected function because GoToService is missing!");
            return;
        }
        goToService.goTo(function.getEntryPoint(), function.getProgram());
    }

    private void closeIfEmpty() {
        if (this.model.isEmpty()) {
            this.closeComponent();
        }
    }

    private void addSpecificCodeComparisonActions() {
        DockingAction[] actions;
        for (DockingAction dockingAction : actions = this.functionComparisonPanel.getCodeComparisonActions()) {
            this.addLocalAction((DockingActionIf)dockingAction);
        }
    }

    public CodeComparisonPanel getCodeComparisonPanelByName(String name) {
        return this.functionComparisonPanel.getCodeComparisonPanelByName(name);
    }

    private void dispose() {
        this.plugin.providerClosed(this);
        this.closeListener.call();
        this.closeListener = Callback.dummy();
        this.functionComparisonPanel.dispose();
    }

    public void componentActivated() {
        this.plugin.providerActivated(this);
    }

    public boolean supportsAddingFunctions() {
        return this.model instanceof AnyToAnyFunctionComparisonModel;
    }

    public void addFunctions(Collection<Function> functions) {
        FunctionComparisonModel functionComparisonModel = this.model;
        if (functionComparisonModel instanceof AnyToAnyFunctionComparisonModel) {
            AnyToAnyFunctionComparisonModel anyToAnyModel = (AnyToAnyFunctionComparisonModel)functionComparisonModel;
            anyToAnyModel.addFunctions(functions);
        }
    }
}

