/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.commands.ExportTrie;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.task.TaskMonitor;

public class MachoExtractProgramBuilder
extends MachoProgramBuilder {
    protected MachoExtractProgramBuilder(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) throws Exception {
        super(program, provider, fileBytes, log, monitor);
    }

    public static void buildProgram(Program program, ByteProvider provider, FileBytes fileBytes, MessageLog log, TaskMonitor monitor) throws Exception {
        MachoExtractProgramBuilder programBuilder = new MachoExtractProgramBuilder(program, provider, fileBytes, log, monitor);
        programBuilder.build();
    }

    protected void setProgramImageBase() throws Exception {
        this.program.setImageBase(this.space.getAddress(0L), true);
    }

    protected void fixupProgramTree(String suffix) throws Exception {
        super.fixupProgramTree(" - " + this.provider.getAbsolutePath());
        ProgramModule rootModule = this.listing.getDefaultRootModule();
        String tag = ".extract";
        String newName = this.provider.getAbsolutePath() + tag;
        ProgramModule newRootModule = rootModule.createModule(newName);
        for (Group group : rootModule.getChildren()) {
            if (group.getName().endsWith(tag)) continue;
            newRootModule.reparent(group.getName(), rootModule);
        }
    }

    protected void processNewExport(Address baseAddr, ExportTrie.ExportEntry export, String name) throws AddressOutOfBoundsException, Exception {
        SymbolTable symbolTable = this.program.getSymbolTable();
        FunctionManager funcManager = this.program.getFunctionManager();
        ExternalManager extManager = this.program.getExternalManager();
        super.processNewExport(baseAddr, export, name);
        Address exportAddr = baseAddr.add(export.address());
        for (Symbol sym : symbolTable.getGlobalSymbols(name)) {
            Function func = funcManager.getFunctionAt(sym.getAddress());
            if (func == null || func.getThunkedFunction(false) == null) continue;
            func.setThunkedFunction(this.createOneByteFunction(name, exportAddr));
            ExternalLocation loc = extManager.getUniqueExternalLocation("<EXTERNAL>", name);
            if (loc == null || !loc.getSymbol().delete() || (loc = extManager.getUniqueExternalLocation("<EXTERNAL>", name)) == null) continue;
            loc.getSymbol().delete();
        }
    }
}

