/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.oat;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.analyzers.FileFormatAnalyzer;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.oat.OatHeader;
import ghidra.file.formats.android.oat.OatHeaderFactory;
import ghidra.file.formats.android.oat.OatInstructionSet;
import ghidra.file.formats.android.oat.OatUtilities;
import ghidra.file.formats.android.oat.UnsupportedOatVersionException;
import ghidra.file.formats.android.oat.oatdexfile.OatDexFile;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class OatHeaderAnalyzer
extends FileFormatAnalyzer {
    public String getName() {
        return "Android OAT Header Format";
    }

    public boolean getDefaultEnablement(Program program) {
        return true;
    }

    public String getDescription() {
        return "Analyzes the Android OAT sections (oatdata and oatexec) in this program.";
    }

    public boolean canAnalyze(Program program) {
        return OatUtilities.isOAT(program);
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws Exception {
        this.clearIfNeeded(program, monitor, log);
        Symbol oatDataSymbol = OatUtilities.getOatDataSymbol(program);
        Address address = oatDataSymbol.getAddress();
        BinaryReader reader = OatUtilities.getBinaryReader(program);
        if (reader == null) {
            return false;
        }
        OatHeader oatHeader = null;
        try {
            oatHeader = OatHeaderFactory.newOatHeader(reader);
            OatHeaderFactory.parseOatHeader(oatHeader, program, reader, monitor, log);
        }
        catch (UnsupportedOatVersionException e) {
            log.appendMsg(e.getMessage());
            return false;
        }
        try {
            DataType headerDataType = oatHeader.toDataType();
            Data headerData = this.createData(program, address, headerDataType);
            address = address.add((long)headerDataType.getLength());
            this.markupClassOffsets(program, oatDataSymbol, oatHeader, headerData, monitor, log);
            monitor.setMessage("Applying OAT DEX headers...");
            monitor.initialize((long)oatHeader.getOatDexFileList().size());
            for (int i = 0; i < oatHeader.getOatDexFileList().size(); ++i) {
                monitor.checkCancelled();
                monitor.setMessage("Applying OAT DEX class offsets [ Pass " + i + " of " + oatHeader.getOatDexFileList().size() + " ]...");
                monitor.incrementProgress(1L);
                OatDexFile oatDexFileHeader = oatHeader.getOatDexFileList().get(i);
                oatDexFileHeader.markup(oatHeader, program, monitor, log);
                this.applyDexHeader(program, oatDexFileHeader, oatDataSymbol, i);
            }
            this.markupOatPatches(program, oatHeader, monitor, log);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            oatHeader = null;
        }
        return true;
    }

    private void clearIfNeeded(Program program, TaskMonitor monitor, MessageLog log) {
        Data oatLastWordSymbolData;
        Symbol oatLastWordSymbol;
        Array array;
        Data oatExecSymbolData;
        Symbol oatExecSymbol;
        Array array2;
        Symbol oatDataSymbol = OatUtilities.getOatDataSymbol(program);
        Data oatDataSymbolData = program.getListing().getDefinedDataAt(oatDataSymbol.getAddress());
        if (oatDataSymbolData != null && oatDataSymbolData.isArray() && (array2 = (Array)oatDataSymbolData.getDataType()).getDataType().isEquivalent((DataType)new Undefined1DataType())) {
            program.getListing().clearCodeUnits(oatDataSymbolData.getMinAddress(), oatDataSymbolData.getMaxAddress(), false);
        }
        if ((oatExecSymbol = OatUtilities.getOatExecSymbol(program)) != null && (oatExecSymbolData = program.getListing().getDefinedDataAt(oatExecSymbol.getAddress())) != null && oatExecSymbolData.isArray() && (array = (Array)oatExecSymbolData.getBaseDataType()).getDataType().isEquivalent((DataType)new Undefined1DataType())) {
            program.getListing().clearCodeUnits(oatExecSymbolData.getMinAddress(), oatExecSymbolData.getMaxAddress(), false);
        }
        if ((oatLastWordSymbol = OatUtilities.getOatLastWordSymbol(program)) != null && (oatLastWordSymbolData = program.getListing().getDefinedDataAt(oatLastWordSymbol.getAddress())) != null) {
            program.getListing().clearCodeUnits(oatLastWordSymbolData.getMinAddress(), oatLastWordSymbolData.getMaxAddress(), false);
        }
    }

    private void markupOatPatches(Program program, OatHeader oatHeader, TaskMonitor monitor, MessageLog log) throws CancelledException {
        monitor.setMessage("Annotating OAT Patches...");
        Memory memory = program.getMemory();
        if (oatHeader.getVersion().equals("045")) {
            MemoryBlock oatBlock = memory.getBlock(".oat_patches");
            MemoryBlock destinationBlock = this.findOatPatchesDestinationBlock(program, oatBlock);
            if (oatBlock == null || destinationBlock == null) {
                log.appendMsg("Could not locate OAT patches source / destination block.");
                return;
            }
            DWordDataType dataType = new DWordDataType();
            monitor.setProgress(0L);
            long numberOfElements = oatBlock.getSize() / (long)dataType.getLength();
            monitor.setMaximum(numberOfElements);
            int i = 0;
            while ((long)i < numberOfElements) {
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                try {
                    Address address = oatBlock.getStart().add((long)(i * dataType.getLength()));
                    Data data = this.createData(program, address, (DataType)dataType);
                    Scalar scalar = data.getScalar(0);
                    Address toAddr = destinationBlock.getStart().add(scalar.getUnsignedValue());
                    program.getListing().setComment(address, 0, "->" + String.valueOf(toAddr));
                }
                catch (Exception e) {
                    log.appendException((Throwable)e);
                    return;
                }
                ++i;
            }
        } else if (oatHeader.getVersion().equals("064") || oatHeader.getVersion().equals("088") || oatHeader.getVersion().equals("124") || oatHeader.getVersion().equals("131")) {
            // empty if block
        }
    }

    private MemoryBlock findOatPatchesDestinationBlock(Program program, MemoryBlock oatPatchesBlock) {
        int pos = oatPatchesBlock.getName().indexOf(".oat_patches");
        if (pos == 0) {
            return program.getMemory().getBlock(".text");
        }
        String destinationBlockName = oatPatchesBlock.getName().substring(0, pos);
        return program.getMemory().getBlock(destinationBlockName);
    }

    private void applyDexHeader(Program program, OatDexFile oatDexFileHeader, Symbol oatDataSymbol, int index) throws Exception {
        Address address = oatDataSymbol.getAddress().add((long)oatDexFileHeader.getDexFileOffset());
        DexHeader dexHeader = oatDexFileHeader.getDexHeader();
        if (dexHeader == null) {
            return;
        }
        if (oatDexFileHeader.isDexHeaderExternal()) {
            return;
        }
        DataType dexHeaderDataType = dexHeader.toDataType();
        try {
            dexHeaderDataType.setName(dexHeaderDataType.getName() + "_" + index);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createData(program, address, dexHeaderDataType);
        address = address.add((long)dexHeaderDataType.getLength());
        int dexRemainder = dexHeader.getFileSize() - dexHeaderDataType.getLength();
        if (dexRemainder > 0) {
            ArrayDataType paddingDataType = new ArrayDataType(StructConverter.BYTE, dexRemainder, StructConverter.BYTE.getLength());
            this.createData(program, address, (DataType)paddingDataType);
        }
    }

    private void markupClassOffsets(Program program, Symbol oatDataSymbol, OatHeader oatHeader, Data headerData, TaskMonitor monitor, MessageLog log) throws CancelledException {
        SymbolTable symbolTable = program.getSymbolTable();
        ReferenceManager referenceManager = program.getReferenceManager();
        EquateTable equateTable = program.getEquateTable();
        for (int i = 0; i < headerData.getNumComponents(); ++i) {
            Scalar scalar;
            monitor.checkCancelled();
            if (!headerData.getComponent(i).getFieldName().equals("executable_offset_") && headerData.getComponent(i).getFieldName().endsWith("_offset_")) {
                scalar = headerData.getComponent(i).getScalar(0);
                if (scalar.getUnsignedValue() <= 0L) continue;
                Address toAddr = oatDataSymbol.getAddress().add(scalar.getUnsignedValue());
                toAddr = OatUtilities.adjustForThumbAsNeeded(oatHeader, program, toAddr, log);
                referenceManager.addMemoryReference(headerData.getComponent(i).getMinAddress(), toAddr, RefType.DATA, SourceType.ANALYSIS, 0);
                try {
                    symbolTable.createLabel(toAddr, headerData.getComponent(i).getFieldName(), SourceType.ANALYSIS);
                    this.disassembleAsNeeded(program, toAddr);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!headerData.getComponent(i).getFieldName().equals("instruction_set_")) continue;
            try {
                scalar = headerData.getComponent(i).getScalar(0);
                OatInstructionSet instructionSet = OatInstructionSet.valueOf((int)scalar.getUnsignedValue());
                Equate equate = equateTable.createEquate(instructionSet.name(), scalar.getUnsignedValue());
                equate.addReference(headerData.getComponent(i).getMinAddress(), 0);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void disassembleAsNeeded(Program program, Address toAddr) {
        if (program.getMemory().contains(toAddr) && program.getMemory().getBlock(toAddr).isExecute() && program.getListing().isUndefined(toAddr, toAddr)) {
            DisassembleCommand cmd = new DisassembleCommand(toAddr, null, false);
            cmd.applyTo((DomainObject)program);
        }
    }
}

