/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.complzss;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.complzss.CompLzssFileSystemFactory;
import ghidra.file.formats.lzss.LzssCodec;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.SingleFileSystemIndexHelper;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

@FileSystemInfo(type="lzss", description="LZSS Compression", factory=CompLzssFileSystemFactory.class)
public class CompLzssFileSystem
implements GFileSystem {
    private FSRLRoot fsFSRL;
    private SingleFileSystemIndexHelper fsIndex;
    private FileSystemRefManager fsRefManager = new FileSystemRefManager((GFileSystem)this);
    private ByteProvider payloadProvider;

    public CompLzssFileSystem(FSRLRoot fsrl, ByteProvider provider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        this.fsFSRL = fsrl;
        monitor.setMessage("Decompressing LZSS...");
        try (ByteProviderWrapper tmpBP = new ByteProviderWrapper(provider, 384L, provider.length() - 384L);
             InputStream tmpIS = tmpBP.getInputStream(0L);){
            this.payloadProvider = fsService.getDerivedByteProviderPush(provider.getFSRL(), null, "decompressed lzss", -1L, os -> LzssCodec.decompress(os, tmpIS), monitor);
            this.fsIndex = new SingleFileSystemIndexHelper((GFileSystem)this, this.fsFSRL, "lzss_decompressed", this.payloadProvider.length(), this.payloadProvider.getFSRL().getMD5());
        }
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FileSystemRefManager getRefManager() {
        return this.fsRefManager;
    }

    public boolean isClosed() {
        return this.payloadProvider == null;
    }

    public void close() throws IOException {
        this.fsRefManager.onClose();
        if (this.payloadProvider != null) {
            this.payloadProvider.close();
            this.payloadProvider = null;
        }
        this.fsIndex.clear();
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException {
        return this.fsIndex.isPayloadFile(file) ? new ByteProviderWrapper(this.payloadProvider, file.getFSRL()) : null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndex.getListing(directory);
    }

    public GFile lookup(String path) throws IOException {
        return this.fsIndex.lookup(path);
    }
}

