/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldArchitecture;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheLocalSymbolsInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingAndSlideInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.file.formats.ios.ExtractedMacho;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DyldCacheExtractor {
    public static final byte[] FOOTER_V1 = "Ghidra DYLD extraction v1".getBytes(StandardCharsets.US_ASCII);

    public static ByteProvider extractDylib(long dylibOffset, DyldCacheUtils.SplitDyldCache splitDyldCache, int index, Map<DyldCacheSlideInfoCommon, List<DyldFixup>> slideFixupMap, FSRL fsrl, TaskMonitor monitor) throws IOException, MachException, CancelledException {
        DyldPackedSegments extractedMacho = new DyldPackedSegments(dylibOffset, splitDyldCache, index, FOOTER_V1, slideFixupMap, monitor);
        ((ExtractedMacho)extractedMacho).pack();
        return extractedMacho.getByteProvider(fsrl);
    }

    public static ByteProvider extractMapping(MappingRange mappingRange, String segmentName, DyldCacheUtils.SplitDyldCache splitDyldCache, int index, Map<DyldCacheSlideInfoCommon, List<DyldFixup>> slideFixupMap, FSRL fsrl, TaskMonitor monitor) throws IOException, MachException, CancelledException {
        int magic = -17958193;
        ArrayList ranges = new ArrayList(mappingRange.rangeSet().asRanges());
        DyldCacheMappingAndSlideInfo mappingInfo = mappingRange.mappingInfo();
        int allSegmentsSize = SegmentCommand.size((int)magic) * ranges.size();
        ByteProvider origProvider = splitDyldCache.getProvider(index);
        byte[] fixedProviderBytes = origProvider.readBytes(0L, origProvider.length());
        DyldCacheSlideInfoCommon slideInfo = slideFixupMap.keySet().stream().filter(e -> e.getMappingAddress() == mappingInfo.getAddress()).findFirst().orElse(null);
        if (slideInfo != null) {
            List<DyldFixup> slideFixups = slideFixupMap.get(slideInfo);
            monitor.initialize((long)slideFixups.size(), "Fixing slide pointers...");
            for (DyldFixup fixup : slideFixups) {
                monitor.increment();
                long fileOffset = slideInfo.getMappingFileOffset() + fixup.offset();
                byte[] newBytes = ExtractedMacho.toBytes(fixup.value(), fixup.size());
                System.arraycopy(newBytes, 0, fixedProviderBytes, (int)fileOffset, newBytes.length);
            }
        }
        byte[] header = MachHeader.create((int)magic, (int)0x100000C, (int)-2147483646, (int)6, (int)ranges.size(), (int)allSegmentsSize, (int)1108344965, (int)0);
        ArrayList<byte[]> segments = new ArrayList<byte[]>();
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        int current = header.length + allSegmentsSize;
        try (ByteArrayProvider fixedProvider = new ByteArrayProvider(fixedProviderBytes);){
            for (int i = 0; i < ranges.size(); ++i) {
                Range range = (Range)ranges.get(i);
                long dataSize = (Long)range.upperEndpoint() - (Long)range.lowerEndpoint();
                segments.add(SegmentCommand.create((int)magic, (String)"%s.%d.%d".formatted(segmentName, index, i), (long)((Long)range.lowerEndpoint()), (long)dataSize, (long)current, (long)dataSize, (int)mappingInfo.getMaxProtection(), (int)mappingInfo.getMaxProtection(), (int)0, (int)0));
                data.add(fixedProvider.readBytes((Long)range.lowerEndpoint() - mappingInfo.getAddress() + mappingInfo.getFileOffset(), dataSize));
                current = (int)((long)current + dataSize);
            }
        }
        int dataSize = data.stream().mapToInt(d -> ((byte[])d).length).sum();
        int totalSize = header.length + allSegmentsSize + dataSize;
        byte[] result = new byte[totalSize + FOOTER_V1.length];
        System.arraycopy(header, 0, result, 0, header.length);
        current = header.length;
        for (byte[] segment : segments) {
            System.arraycopy(segment, 0, result, current, segment.length);
            current += segment.length;
        }
        for (byte[] d2 : data) {
            System.arraycopy(d2, 0, result, current, d2.length);
            current += d2.length;
        }
        System.arraycopy(FOOTER_V1, 0, result, result.length - FOOTER_V1.length, FOOTER_V1.length);
        return new ByteArrayProvider(result, fsrl);
    }

    public static Map<DyldCacheSlideInfoCommon, List<DyldFixup>> getSlideFixups(DyldCacheUtils.SplitDyldCache splitDyldCache, TaskMonitor monitor) throws CancelledException, IOException {
        HashMap<DyldCacheSlideInfoCommon, List<DyldFixup>> slideFixupMap = new HashMap<DyldCacheSlideInfoCommon, List<DyldFixup>>();
        MessageLog log = new MessageLog();
        for (int i = 0; i < splitDyldCache.size(); ++i) {
            DyldCacheHeader header = splitDyldCache.getDyldCacheHeader(i);
            ByteProvider bp = splitDyldCache.getProvider(i);
            DyldArchitecture arch = header.getArchitecture();
            for (DyldCacheSlideInfoCommon slideInfo : header.getSlideInfos()) {
                try (ByteProviderWrapper wrapper = new ByteProviderWrapper(bp, slideInfo.getMappingFileOffset(), slideInfo.getMappingSize());){
                    BinaryReader wrapperReader = new BinaryReader((ByteProvider)wrapper, !arch.getEndianness().isBigEndian());
                    List fixups = slideInfo.getSlideFixups(wrapperReader, arch.is64bit() ? 8 : 4, log, monitor);
                    slideFixupMap.put(slideInfo, fixups);
                }
            }
        }
        return slideFixupMap;
    }

    private static class DyldPackedSegments
    extends ExtractedMacho {
        private DyldCacheUtils.SplitDyldCache splitDyldCache;
        private Map<DyldCacheSlideInfoCommon, List<DyldFixup>> slideFixupMap;

        public DyldPackedSegments(long dylibOffset, DyldCacheUtils.SplitDyldCache splitDyldCache, int index, byte[] footer, Map<DyldCacheSlideInfoCommon, List<DyldFixup>> slideFixupMap, TaskMonitor monitor) throws MachException, IOException, CancelledException {
            super(splitDyldCache.getProvider(index), dylibOffset, new MachHeader(splitDyldCache.getProvider(index), dylibOffset, false).parse(splitDyldCache), footer, monitor);
            this.splitDyldCache = splitDyldCache;
            this.slideFixupMap = slideFixupMap;
        }

        @Override
        public void pack() throws IOException, CancelledException {
            super.pack();
            this.fixupSlidePointers();
        }

        @Override
        protected ByteProvider getSegmentProvider(SegmentCommand segment) throws IOException {
            for (int i = 0; i < this.splitDyldCache.size(); ++i) {
                DyldCacheHeader dyldCacheheader = this.splitDyldCache.getDyldCacheHeader(i);
                for (DyldCacheMappingInfo mappingInfo : dyldCacheheader.getMappingInfos()) {
                    if (!mappingInfo.contains(segment.getVMaddress())) continue;
                    return this.splitDyldCache.getProvider(i);
                }
            }
            throw new IOException("Failed to find provider for segment: " + segment.getSegmentName());
        }

        @Override
        protected List<NList> getExtraSymbols() {
            long base = this.splitDyldCache.getBaseAddress();
            DyldCacheLocalSymbolsInfo info = this.splitDyldCache.getLocalSymbolInfo();
            return info != null ? info.getNList(this.textSegment.getVMaddress() - base) : List.of();
        }

        private void fixupSlidePointers() throws IOException, CancelledException {
            long total = this.slideFixupMap.values().stream().flatMap(Collection::stream).count();
            this.monitor.initialize(total, "Fixing slide pointers...");
            for (DyldCacheSlideInfoCommon slideInfo : this.slideFixupMap.keySet()) {
                for (DyldFixup fixup : this.slideFixupMap.get(slideInfo)) {
                    this.monitor.increment();
                    long addr = slideInfo.getMappingAddress() + fixup.offset();
                    long fileOffset = slideInfo.getMappingFileOffset() + fixup.offset();
                    SegmentCommand segment = this.getSegmentContaining(addr);
                    if (segment == null) continue;
                    byte[] newBytes = ExtractedMacho.toBytes(fixup.value(), fixup.size());
                    try {
                        System.arraycopy(newBytes, 0, this.packed, (int)this.getPackedOffset(fileOffset, segment), newBytes.length);
                    }
                    catch (NotFoundException e) {
                        throw new IOException(e);
                    }
                }
            }
        }

        private SegmentCommand getSegmentContaining(long addr) {
            for (SegmentCommand segment : this.machoHeader.getAllSegments()) {
                if (addr < segment.getVMaddress() || addr >= segment.getVMaddress() + segment.getVMsize()) continue;
                return segment;
            }
            return null;
        }
    }

    public record MappingRange(DyldCacheMappingAndSlideInfo mappingInfo, RangeSet<Long> rangeSet) {
    }
}

