/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheImage;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingAndSlideInfo;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfoCommon;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.DyldCacheUtils;
import ghidra.file.formats.ios.dyldcache.DyldCacheExtractor;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

@FileSystemInfo(type="dyldcachev1", description="iOS DYLD Cache Version 1", factory=GFileSystemBaseFactory.class)
public class DyldCacheFileSystem
extends GFileSystemBase {
    public static final String DYLD_CACHE_FSTYPE = "dyldcachev1";
    private DyldCacheUtils.SplitDyldCache splitDyldCache;
    private boolean parsedLocalSymbols = false;
    private Map<DyldCacheSlideInfoCommon, List<DyldFixup>> slideFixupMap;
    private Map<GFile, Long> addrMap = new HashMap<GFile, Long>();
    private Map<GFile, Integer> indexMap = new HashMap<GFile, Integer>();
    private Map<Long, DyldCacheExtractor.MappingRange> stubMap = new HashMap<Long, DyldCacheExtractor.MappingRange>();
    private Map<Long, DyldCacheExtractor.MappingRange> dyldDataMap = new HashMap<Long, DyldCacheExtractor.MappingRange>();

    public DyldCacheFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public void close() throws IOException {
        this.slideFixupMap = null;
        this.parsedLocalSymbols = false;
        this.addrMap.clear();
        this.indexMap.clear();
        this.stubMap.clear();
        this.dyldDataMap.clear();
        if (this.splitDyldCache != null) {
            this.splitDyldCache.close();
            this.splitDyldCache = null;
        }
        super.close();
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws CancelledException, IOException {
        Long addr = this.addrMap.get(file);
        if (addr == null) {
            return null;
        }
        int index = this.indexMap.get(file);
        long machHeaderStartIndexInProvider = addr - this.splitDyldCache.getDyldCacheHeader(index).getBaseAddress();
        if (this.slideFixupMap == null) {
            this.slideFixupMap = DyldCacheExtractor.getSlideFixups(this.splitDyldCache, monitor);
        }
        if (!this.parsedLocalSymbols) {
            for (int i = 0; i < this.splitDyldCache.size(); ++i) {
                this.splitDyldCache.getDyldCacheHeader(i).parseLocalSymbolsInfo(true, new MessageLog(), monitor);
            }
            this.parsedLocalSymbols = true;
        }
        try {
            if (this.stubMap.containsKey(addr)) {
                DyldCacheExtractor.MappingRange mappingRange = this.stubMap.get(addr);
                return DyldCacheExtractor.extractMapping(mappingRange, "_STUBS", this.splitDyldCache, index, this.slideFixupMap, file.getFSRL(), monitor);
            }
            if (this.dyldDataMap.containsKey(addr)) {
                DyldCacheExtractor.MappingRange mappingRange = this.dyldDataMap.get(addr);
                return DyldCacheExtractor.extractMapping(mappingRange, "__DATA", this.splitDyldCache, index, this.slideFixupMap, file.getFSRL(), monitor);
            }
            return DyldCacheExtractor.extractDylib(machHeaderStartIndexInProvider, this.splitDyldCache, index, this.slideFixupMap, file.getFSRL(), monitor);
        }
        catch (MachException e) {
            throw new IOException("Invalid Mach-O header detected at 0x" + Long.toHexString(machHeaderStartIndexInProvider));
        }
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        if (directory == null || directory.equals((Object)this.root)) {
            ArrayList<GFile> roots = new ArrayList<GFile>();
            for (GFile file : this.addrMap.keySet()) {
                if (file.getParentFile() != this.root && !file.getParentFile().equals((Object)this.root)) continue;
                roots.add(file);
            }
            return roots;
        }
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        for (GFile file : this.addrMap.keySet()) {
            if (file.getParentFile() == null || !file.getParentFile().equals((Object)directory)) continue;
            tmp.add(file);
        }
        return tmp;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        if (!DyldCacheUtils.isDyldCache((ByteProvider)this.provider)) {
            return false;
        }
        try {
            DyldCacheHeader header = new DyldCacheHeader(new BinaryReader(this.provider, true));
            return !header.isSubcache();
        }
        catch (IOException e) {
            return false;
        }
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        GFileImpl file;
        DyldCacheMappingAndSlideInfo mappingInfo2;
        List mappingInfos;
        DyldCacheHeader header;
        String name;
        int i;
        this.splitDyldCache = new DyldCacheUtils.SplitDyldCache(this.provider, false, new MessageLog(), monitor);
        HashMap dyldDataMappingRanges = new HashMap();
        monitor.initialize((long)this.splitDyldCache.size(), "Find DYLD data...");
        for (i = 0; i < this.splitDyldCache.size(); ++i) {
            monitor.increment();
            name = this.splitDyldCache.getName(i);
            header = this.splitDyldCache.getDyldCacheHeader(i);
            mappingInfos = header.getCacheMappingAndSlideInfos();
            ArrayList<DyldCacheExtractor.MappingRange> mappingRangeList = new ArrayList<DyldCacheExtractor.MappingRange>();
            if (!name.endsWith(".dylddata")) continue;
            dyldDataMappingRanges.put(i, mappingRangeList);
            for (int j = 0; j < mappingInfos.size(); ++j) {
                mappingInfo2 = (DyldCacheMappingAndSlideInfo)mappingInfos.get(j);
                mappingRangeList.add(new DyldCacheExtractor.MappingRange(mappingInfo2, this.getRangeSet(mappingInfo2)));
            }
        }
        monitor.initialize((long)this.splitDyldCache.size(), "Find DYLD components...");
        block2: for (i = 0; i < this.splitDyldCache.size(); ++i) {
            monitor.increment();
            name = this.splitDyldCache.getName(i);
            header = this.splitDyldCache.getDyldCacheHeader(i);
            mappingInfos = header.getCacheMappingAndSlideInfos();
            List mappedImages = header.getMappedImages();
            for (DyldCacheImage mappedImage : mappedImages) {
                file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)mappedImage.getPath(), null, (boolean)false, (long)-1L);
                this.storeFile((GFile)file, mappedImage.getAddress(), i);
                this.reduceOverlappingSegments(i, mappedImage, dyldDataMappingRanges.values());
            }
            for (DyldCacheMappingAndSlideInfo mappingInfo2 : mappingInfos) {
                if (!mappingInfo2.isTextStubs()) continue;
                file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)DyldCacheFileSystem.getStubPath(name), null, (boolean)false, (long)-1L);
                this.storeFile((GFile)file, mappingInfo2.getAddress(), i);
                this.stubMap.put(mappingInfo2.getAddress(), new DyldCacheExtractor.MappingRange(mappingInfo2, this.getRangeSet(mappingInfo2)));
                continue block2;
            }
        }
        for (Integer i2 : dyldDataMappingRanges.keySet()) {
            String name2 = this.splitDyldCache.getName(i2.intValue());
            List mappingRangeList = (List)dyldDataMappingRanges.get(i2);
            for (int j = 0; j < mappingRangeList.size(); ++j) {
                monitor.checkCancelled();
                DyldCacheExtractor.MappingRange mappingRange = (DyldCacheExtractor.MappingRange)mappingRangeList.get(j);
                mappingInfo2 = mappingRange.mappingInfo();
                file = GFileImpl.fromPathString((GFileSystem)this, (GFile)this.root, (String)DyldCacheFileSystem.getDyldDataPath(name2, j), null, (boolean)false, (long)-1L);
                this.storeFile((GFile)file, mappingInfo2.getAddress(), i2);
                this.dyldDataMap.put(mappingInfo2.getAddress(), mappingRange);
            }
        }
    }

    public DyldCacheUtils.SplitDyldCache getSplitDyldCache() {
        return this.splitDyldCache;
    }

    public static String getStubPath(String dyldCacheName) {
        return "/STUBS/STUBS." + FilenameUtils.getExtension((String)dyldCacheName);
    }

    public static String getDyldDataPath(String dyldCacheName, int mappingIndex) {
        return "/DYLD_DATA/DYLD_DATA.%s.%d".formatted(FilenameUtils.getExtension((String)dyldCacheName.substring(0, dyldCacheName.length() - ".dylddata".length())), mappingIndex);
    }

    private void storeFile(GFile file, Long address, Integer splitDyldCacheIndex) {
        if (file == null) {
            return;
        }
        if (file.equals((Object)this.root)) {
            return;
        }
        if (!this.addrMap.containsKey(file) || this.addrMap.get(file) == null) {
            this.addrMap.put(file, address);
            this.indexMap.put(file, splitDyldCacheIndex);
        }
        GFile parentFile = file.getParentFile();
        this.storeFile(parentFile, null, null);
    }

    private RangeSet<Long> getRangeSet(DyldCacheMappingAndSlideInfo mappingInfo) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        rangeSet.add(Range.openClosed((Comparable)Long.valueOf(mappingInfo.getAddress()), (Comparable)Long.valueOf(mappingInfo.getAddress() + mappingInfo.getSize())));
        return rangeSet;
    }

    private void reduceOverlappingSegments(int splitDyldCacheIndex, DyldCacheImage mappedImage, Collection<List<DyldCacheExtractor.MappingRange>> ranges) throws IOException {
        DyldCacheHeader dyldCacheHeader = this.splitDyldCache.getDyldCacheHeader(splitDyldCacheIndex);
        ByteProvider p = this.splitDyldCache.getProvider(splitDyldCacheIndex);
        try {
            MachHeader machoHeader = new MachHeader(p, mappedImage.getAddress() - dyldCacheHeader.getBaseAddress());
            for (SegmentCommand segment : machoHeader.parseSegments()) {
                for (List<DyldCacheExtractor.MappingRange> mappingRanges : ranges) {
                    for (DyldCacheExtractor.MappingRange mappingRange : mappingRanges) {
                        Range range = Range.closedOpen((Comparable)Long.valueOf(segment.getVMaddress()), (Comparable)Long.valueOf(segment.getVMaddress() + segment.getVMsize()));
                        mappingRange.rangeSet().remove(range);
                    }
                }
            }
        }
        catch (MachException e) {
            throw new IOException(e);
        }
    }
}

