/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.fileset;

import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.file.formats.ios.ExtractedMacho;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class MachoFileSetExtractor {
    public static final byte[] FOOTER_V1 = "Ghidra Mach-O file set extraction v1".getBytes(StandardCharsets.US_ASCII);

    public static ByteProvider extractFileSetEntry(ByteProvider provider, long providerOffset, FSRL fsrl, TaskMonitor monitor) throws IOException, MachException, CancelledException {
        ExtractedMacho extractedMacho = new ExtractedMacho(provider, providerOffset, new MachHeader(provider, providerOffset, false).parse(), FOOTER_V1, monitor);
        extractedMacho.pack();
        return extractedMacho.getByteProvider(fsrl);
    }

    public static ByteProvider extractSegment(ByteProvider provider, SegmentCommand segment, FSRL fsrl, TaskMonitor monitor) throws IOException, MachException, CancelledException {
        int magic = -17958193;
        int allSegmentsSize = SegmentCommand.size((int)magic);
        byte[] header = MachHeader.create((int)magic, (int)0x100000C, (int)-2147483646, (int)6, (int)1, (int)allSegmentsSize, (int)1108344965, (int)0);
        byte[] segmentCommandBytes = SegmentCommand.create((int)magic, (String)segment.getSegmentName(), (long)segment.getVMaddress(), (long)segment.getVMsize(), (long)(header.length + allSegmentsSize), (long)segment.getFileSize(), (int)segment.getMaxProtection(), (int)segment.getInitProtection(), (int)0, (int)segment.getFlags());
        byte[] segmentDataBytes = provider.readBytes(segment.getFileOffset(), segment.getFileSize());
        int totalSize = header.length + allSegmentsSize + segmentDataBytes.length;
        byte[] result = new byte[totalSize + FOOTER_V1.length];
        System.arraycopy(header, 0, result, 0, header.length);
        System.arraycopy(segmentCommandBytes, 0, result, header.length, segmentCommandBytes.length);
        System.arraycopy(segmentDataBytes, 0, result, header.length + segmentCommandBytes.length, segmentDataBytes.length);
        System.arraycopy(FOOTER_V1, 0, result, result.length - FOOTER_V1.length, FOOTER_V1.length);
        return new ByteArrayProvider(result, fsrl);
    }
}

