/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img2;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.ios.img2.Img2;
import ghidra.file.formats.ios.img2.Img2FileSystemFactory;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.SingleFileSystemIndexHelper;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

@FileSystemInfo(type="img2", description="iOS Img2", factory=Img2FileSystemFactory.class)
public class Img2FileSystem
implements GFileSystem {
    private final FSRLRoot fsFSRL;
    private SingleFileSystemIndexHelper fsIndexHelper;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private ByteProvider provider;
    private Img2 img2;

    public Img2FileSystem(FSRLRoot fsFSRL, ByteProvider provider, TaskMonitor monitor) throws IOException, CancelledException {
        this.fsFSRL = fsFSRL;
        this.provider = provider;
        this.img2 = new Img2(provider);
        if (!this.img2.isValid()) {
            throw new IOException("Unable to decrypt file: invalid IMG2 file!");
        }
        try (ByteProviderWrapper tmpBP = new ByteProviderWrapper(provider, 1024L, (long)this.img2.getDataLen(), null);){
            String payloadMD5 = FSUtilities.getMD5((ByteProvider)tmpBP, (TaskMonitor)monitor);
            this.fsIndexHelper = new SingleFileSystemIndexHelper((GFileSystem)this, fsFSRL, this.img2.getImageType(), (long)this.img2.getDataLen(), payloadMD5);
        }
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public void close() throws IOException {
        this.refManager.onClose();
        this.fsIndexHelper.clear();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) {
        if (this.fsIndexHelper.isPayloadFile(file)) {
            return new ByteProviderWrapper(this.provider, 1024L, (long)this.img2.getDataLen(), this.fsIndexHelper.getPayloadFile().getFSRL());
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsIndexHelper.getListing(directory);
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public boolean isClosed() {
        return this.fsIndexHelper.isClosed();
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public GFile lookup(String path) {
        return this.fsIndexHelper.lookup(path);
    }
}

