/*
 * Decompiled with CFR 0.152.
 */
package ghidra.macosx.plugins;

import docking.Tool;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.file.formats.ios.fileset.MachoFileSetEntry;
import ghidra.file.formats.ios.fileset.MachoFileSetFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Mach-O LC_FILESET_ENTRY Builder", description="This plugin provides actions for adding Mach-O file set entries to the program")
public class MachoFileSetBuilderPlugin
extends Plugin {
    public MachoFileSetBuilderPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        String actionName = "Add To Program";
        new ActionBuilder(actionName, this.getName()).withContext(ProgramLocationActionContext.class).enabledWhen(p -> p.getProgram().getExecutableFormat().equals("Extracted Mach-O File Set Entry")).onAction(plac -> TaskLauncher.launchModal((String)actionName, monitor -> this.addMissingMachoFileSetEntry(plac.getLocation(), monitor))).popupMenuPath(new String[]{"References", actionName}).popupMenuGroup("Add").helpLocation(new HelpLocation("ImporterPlugin", "Add_To_Program")).buildAndInstall((Tool)this.tool);
    }

    private void addMissingMachoFileSetEntry(ProgramLocation location, TaskMonitor monitor) {
        Program program = location.getProgram();
        Address refAddress = location.getRefAddress();
        if (refAddress == null) {
            Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"No referenced address selected");
            return;
        }
        if (refAddress.getAddressSpace().isExternalSpace()) {
            Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"External locations are not currently supported");
            return;
        }
        if (program.getMemory().contains(refAddress)) {
            Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"Referenced address already exists in memory");
            return;
        }
        long refAddr = refAddress.getOffset();
        try (FileSystemRef fsRef2 = this.openMachoFileSet(program, monitor);){
            MachoFileSetFileSystem fs = (MachoFileSetFileSystem)fsRef2.getFilesystem();
            Map<MachoFileSetEntry, List<SegmentCommand>> entrySegmentMap = fs.getEntrySegmentMap();
            String fsPath = null;
            block8: for (MachoFileSetEntry entry : entrySegmentMap.keySet()) {
                for (SegmentCommand segment : entrySegmentMap.get(entry)) {
                    if (!segment.contains(refAddr)) continue;
                    fsPath = entry.id();
                    continue block8;
                }
            }
            if (fsPath != null) {
                ImporterUtilities.showAddToProgramDialog((FSRL)fs.getFSRL().appendPath(fsPath), (Program)program, (PluginTool)this.tool, (TaskMonitor)monitor);
            } else {
                Msg.showInfo((Object)((Object)this), null, (String)this.name, (Object)"Address %s not found in %s".formatted(refAddress, ((Object)((Object)fs)).toString()));
            }
        }
        catch (CancelledException fsRef2) {
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)this.name, (Object)e.getMessage(), (Throwable)e);
        }
    }

    private FileSystemRef openMachoFileSet(Program program, TaskMonitor monitor) throws IOException, CancelledException {
        FSRL fsrl = FSRL.fromProgram((Program)program);
        if (fsrl == null) {
            throw new IOException("The program does not have an FSRL property");
        }
        String requiredProtocol = "machofileset";
        if (!fsrl.getFS().getProtocol().equals(requiredProtocol)) {
            throw new IOException("The program's FSRL protocol is '%s' but '%s' is required".formatted(fsrl.getFS().getProtocol(), requiredProtocol));
        }
        FSRLRoot fsrlRoot = fsrl.getFS();
        return FileSystemService.getInstance().getFilesystem(fsrlRoot, monitor);
    }
}

