/*
 * Decompiled with CFR 0.152.
 */
package help.validator;

import generic.jar.ResourceFile;
import ghidra.framework.Application;
import help.HelpBuildUtils;
import help.validator.DuplicateAnchorCollectionByHelpFile;
import help.validator.DuplicateAnchorCollectionByHelpTopic;
import help.validator.LinkDatabase;
import help.validator.links.IncorrectIMGFilenameCaseInvalidLink;
import help.validator.links.InvalidHREFLink;
import help.validator.links.InvalidLink;
import help.validator.links.InvalidRuntimeIMGFileInvalidLink;
import help.validator.links.MissingAnchorInvalidLink;
import help.validator.links.MissingFileInvalidLink;
import help.validator.links.MissingTOCDefinitionInvalidLink;
import help.validator.links.MissingTOCTargetIDInvalidLink;
import help.validator.links.NonExistentIMGFileInvalidLink;
import help.validator.location.HelpModuleCollection;
import help.validator.model.AnchorDefinition;
import help.validator.model.HREF;
import help.validator.model.HelpFile;
import help.validator.model.HelpTopic;
import help.validator.model.IMG;
import help.validator.model.TOCItem;
import help.validator.model.TOCItemReference;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JavaHelpValidator {
    private static boolean debug;
    private static Set<String> EXCLUDED_FILE_NAMES;
    private String moduleName;
    private HelpModuleCollection help;

    private static Set<String> createExcludedFileSet() {
        HashSet<String> set = new HashSet<String>();
        set.add("help/topics/Misc/Tips");
        set.add("docs/WhatsNew");
        set.add("docs/README_PDB");
        return set;
    }

    public JavaHelpValidator(String moduleName, HelpModuleCollection help) {
        this.moduleName = moduleName;
        this.help = help;
    }

    private void validateInternalFileLinks(LinkDatabase linkDatabase) {
        this.validateHelpDirectoryInternalLinks(this.help, linkDatabase);
    }

    private void validateHelpDirectoryInternalLinks(HelpModuleCollection helpCollection, LinkDatabase linkDatabase) {
        JavaHelpValidator.debug("validating internal help links for module: " + String.valueOf(helpCollection));
        ArrayList<InvalidLink> unresolvedLinks = new ArrayList<InvalidLink>();
        Collection<HREF> helpDirHREFs = helpCollection.getAllHREFs();
        JavaHelpValidator.debug("\tHREF count: " + helpDirHREFs.size());
        for (HREF hREF : helpDirHREFs) {
            if (hREF.isRemote()) continue;
            Path path = hREF.getReferenceFileHelpPath();
            HelpFile helpFile = helpCollection.getHelpFile(path);
            this.validateHREFHelpFile(hREF, helpFile, unresolvedLinks);
        }
        Collection<IMG> helpDirIMGs = helpCollection.getAllIMGs();
        JavaHelpValidator.debug("\tIMG count: " + helpDirIMGs.size());
        for (IMG iMG : helpDirIMGs) {
            this.validateIMGFile(iMG, unresolvedLinks);
        }
        linkDatabase.addUnresolvedLinks(unresolvedLinks);
        Map<HelpFile, Map<String, List<AnchorDefinition>>> map = helpCollection.getDuplicateAnchorsByFile();
        JavaHelpValidator.debug("\tHelp files with duplicate anchors: " + map.size());
        for (Map.Entry<HelpFile, Map<String, List<AnchorDefinition>>> entry : map.entrySet()) {
            HelpFile helpFile = entry.getKey();
            Map<String, List<AnchorDefinition>> list = entry.getValue();
            linkDatabase.addDuplicateAnchors(new DuplicateAnchorCollectionByHelpFile(helpFile, list));
        }
        Map<HelpTopic, List<AnchorDefinition>> map2 = helpCollection.getDuplicateAnchorsByTopic();
        JavaHelpValidator.debug("\tHelp topics with duplicate anchors: " + map2.size());
        Set<Map.Entry<HelpTopic, List<AnchorDefinition>>> set = map2.entrySet();
        for (Map.Entry<HelpTopic, List<AnchorDefinition>> entry : set) {
            linkDatabase.addDuplicateAnchors(new DuplicateAnchorCollectionByHelpTopic(entry.getKey(), entry.getValue()));
        }
    }

    private void validateIMGFile(IMG img, List<InvalidLink> unresolvedLinks) {
        if (img.isRemote()) {
            return;
        }
        if (img.isRuntime()) {
            if (img.isInvalid()) {
                unresolvedLinks.add(new InvalidRuntimeIMGFileInvalidLink(img));
                return;
            }
            return;
        }
        Path imagePath = img.getImageFile();
        if (imagePath == null) {
            unresolvedLinks.add(new NonExistentIMGFileInvalidLink(img));
            return;
        }
        Path testPath = this.findPathInHelp(img);
        if (testPath == null) {
            testPath = this.findPathInModules(img);
        }
        if (testPath == null) {
            unresolvedLinks.add(new NonExistentIMGFileInvalidLink(img));
            return;
        }
        if (!this.caseMatches(img, testPath)) {
            unresolvedLinks.add(new IncorrectIMGFilenameCaseInvalidLink(img));
        }
    }

    private Path findPathInHelp(IMG img) {
        Path imagePath = img.getImageFile();
        for (Path helpDir : this.help.getHelpRoots()) {
            Path toCheck = this.makePath(helpDir, imagePath);
            if (toCheck == null) continue;
            return toCheck;
        }
        return null;
    }

    private Path findPathInModules(IMG img) {
        ResourceFile myModule;
        ResourceFile resourceDir;
        Path toCheck;
        String src = img.getSrcAttribute();
        if (src.startsWith("help/shared/") && (toCheck = this.makePath(resourceDir = new ResourceFile(myModule = Application.getMyModuleRootDirectory(), "src/main/resources"), src)) != null) {
            return toCheck;
        }
        return this.doFindPathInModules(src);
    }

    private Path doFindPathInModules(String path) {
        Collection moduleRoots = Application.getModuleRootDirectories();
        for (ResourceFile root : moduleRoots) {
            ResourceFile resourceDir = new ResourceFile(root, "src/main/resources");
            Path toCheck = this.makePath(resourceDir, path);
            if (toCheck == null) continue;
            return toCheck;
        }
        return null;
    }

    private Path makePath(ResourceFile dir, String imgSrc) {
        Path imagePath;
        Path imageFileFS;
        if (!dir.exists()) {
            return null;
        }
        Path dirPath = Paths.get(dir.getAbsolutePath(), new String[0]);
        Path toCheck = dirPath.resolve(imageFileFS = HelpBuildUtils.toFS(dirPath, imagePath = Paths.get(imgSrc, new String[0])));
        if (Files.exists(toCheck, new LinkOption[0])) {
            return toCheck;
        }
        return null;
    }

    private Path makePath(Path helpDir, Path imagePath) {
        Path imageFileFS = HelpBuildUtils.toFS(helpDir, imagePath);
        Path toCheck = helpDir.resolve(imageFileFS = this.removeRedundantHelp(helpDir, imageFileFS));
        if (Files.exists(toCheck, new LinkOption[0])) {
            return toCheck;
        }
        return null;
    }

    private boolean caseMatches(IMG img, Path path) {
        Path realPath;
        try {
            realPath = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return false;
        }
        String realFilename = realPath.getFileName().toString();
        Path imagePath = img.getImageFile();
        String imageFilename = imagePath.getFileName().toString();
        return realFilename.equals(imageFilename);
    }

    private Path removeRedundantHelp(Path root, Path p) {
        if (p.startsWith("help") && root.endsWith("help")) {
            p = p.subpath(1, p.getNameCount());
        }
        return p;
    }

    private void validateHREFHelpFile(HREF href, HelpFile helpFile, List<InvalidLink> unresolvedLinks) {
        if (helpFile == null) {
            if (this.isExcludedHREF(href)) {
                return;
            }
            unresolvedLinks.add(new MissingFileInvalidLink(href));
            return;
        }
        String anchorName = href.getAnchorName();
        if (anchorName == null) {
            return;
        }
        if (!helpFile.containsAnchor(anchorName)) {
            unresolvedLinks.add(new MissingAnchorInvalidLink(href));
        }
    }

    private boolean isExcludedHREF(HREF href) {
        String path = href.getRefString();
        return this.isExcludedPath(path);
    }

    private boolean isExcludedPath(String path) {
        if (path.indexOf("/docs/api/") != -1) {
            return true;
        }
        int index = path.lastIndexOf(".");
        if (index != -1) {
            path = path.substring(0, index);
        }
        return EXCLUDED_FILE_NAMES.contains(path);
    }

    private void validateExternalFileLinks(LinkDatabase linkDatabase) {
        Collection<InvalidLink> unresolvedLinks = linkDatabase.getUnresolvedLinks();
        JavaHelpValidator.debug("validating " + unresolvedLinks.size() + " unresolved external links");
        TreeSet<InvalidLink> remainingInvalidLinks = new TreeSet<InvalidLink>();
        Iterator<InvalidLink> iterator = unresolvedLinks.iterator();
        while (iterator.hasNext()) {
            InvalidLink link = iterator.next();
            if (!(link instanceof InvalidHREFLink)) continue;
            InvalidHREFLink invalidHREFLink = (InvalidHREFLink)link;
            if (invalidHREFLink instanceof MissingAnchorInvalidLink) {
                remainingInvalidLinks.add(link);
                continue;
            }
            HelpFile referencedHelpFile = linkDatabase.resolveLink(link);
            if (referencedHelpFile == null) continue;
            iterator.remove();
        }
        linkDatabase.addUnresolvedLinks(remainingInvalidLinks);
    }

    private void validateExternalImageFileLinks(LinkDatabase linkDatabase) {
        Collection<InvalidLink> unresolvedLinks = linkDatabase.getUnresolvedLinks();
        JavaHelpValidator.debug("validating " + unresolvedLinks.size() + " unresolved external image links");
        TreeSet<InvalidLink> remainingInvalidLinks = new TreeSet<InvalidLink>();
        for (InvalidLink link : unresolvedLinks) {
            if (!(link instanceof NonExistentIMGFileInvalidLink)) continue;
            remainingInvalidLinks.add(link);
        }
        linkDatabase.addUnresolvedLinks(remainingInvalidLinks);
    }

    private void validateTOCItemIDs(LinkDatabase linkDatabase) {
        JavaHelpValidator.debug("Validating TOC item IDs...");
        ArrayList<InvalidLink> unresolvedLinks = new ArrayList<InvalidLink>();
        Collection<TOCItem> items = this.help.getInputTOCItems();
        JavaHelpValidator.debug("\tvalidating " + items.size() + " TOC item references for module: " + this.moduleName);
        for (TOCItem item : items) {
            if (item.validate(linkDatabase)) continue;
            if (item instanceof TOCItemReference) {
                TOCItemReference reference = (TOCItemReference)item;
                unresolvedLinks.add(new MissingTOCDefinitionInvalidLink(this.help, reference));
                continue;
            }
            String targetPath = item.getTargetAttribute();
            if (this.isExcludedPath(targetPath)) continue;
            unresolvedLinks.add(new MissingTOCTargetIDInvalidLink(this.help, item));
        }
        Collection<HREF> TOC_HREFs = this.help.getTOC_HREFs();
        JavaHelpValidator.debug("\tvalidating TOC links: " + TOC_HREFs.size());
        for (HREF href : TOC_HREFs) {
            Path referenceFileHelpPath = href.getReferenceFileHelpPath();
            HelpFile helpFile = linkDatabase.resolveFile(referenceFileHelpPath);
            this.validateHREFHelpFile(href, helpFile, unresolvedLinks);
        }
        linkDatabase.addUnresolvedLinks(unresolvedLinks);
        JavaHelpValidator.debug("\tfinished validating TOC item IDs...");
    }

    public Collection<InvalidLink> validate(LinkDatabase linkDatabase) {
        this.validateInternalFileLinks(linkDatabase);
        this.validateExternalFileLinks(linkDatabase);
        this.validateExternalImageFileLinks(linkDatabase);
        this.validateTOCItemIDs(linkDatabase);
        return linkDatabase.getUnresolvedLinks();
    }

    private static void debug(String message) {
        if (debug) {
            JavaHelpValidator.flush();
            System.out.println("[" + JavaHelpValidator.class.getSimpleName() + "] " + message);
        }
    }

    private static void flush() {
        System.out.flush();
        System.out.println();
        System.out.flush();
        System.err.flush();
        System.err.println();
        System.err.flush();
    }

    public void setDebugEnabled(boolean debug) {
        JavaHelpValidator.debug = debug;
    }

    static {
        EXCLUDED_FILE_NAMES = JavaHelpValidator.createExcludedFileSet();
    }
}

