/*
 * Decompiled with CFR 0.152.
 */
package help.validator.model;

import ghidra.util.exception.AssertException;
import help.HelpBuildUtils;
import java.nio.file.Path;

public class AnchorDefinition {
    private final Path sourceFile;
    private final Path helpRelativePath;
    private final String anchorName;
    private final int lineNum;
    private final String ID;

    public AnchorDefinition(Path file, String anchorName, int lineNum) {
        this.sourceFile = file;
        this.anchorName = anchorName;
        this.lineNum = lineNum;
        String prefix = this.getAnchorDefinitionPrefix(this.sourceFile);
        String anchor = anchorName;
        if (anchor == null) {
            anchor = this.getDefaultAnchor(this.sourceFile);
        }
        String rawID = prefix + "_" + anchor;
        this.ID = rawID.replace(' ', '_').replace('-', '_').replace('.', '_');
        this.helpRelativePath = HelpBuildUtils.relativizeWithHelpTopics(file);
    }

    private String getAnchorDefinitionPrefix(Path anchorSourceFile) {
        Path topicDir = HelpBuildUtils.getHelpTopicDir(anchorSourceFile);
        if (topicDir == null) {
            throw new AssertException("Anchor defined in a file that does not live inside of a help topic");
        }
        return topicDir.getFileName().toString();
    }

    private String getDefaultAnchor(Path file) {
        String filename = file.getFileName().toString();
        int extension = filename.toLowerCase().indexOf(".htm");
        if (extension != -1) {
            return filename.substring(0, extension);
        }
        throw new AssertException("Cannot have HTML file without an .html extension");
    }

    public String getAnchorName() {
        return this.anchorName;
    }

    public Path getSrcFile() {
        return this.sourceFile;
    }

    public String getId() {
        return this.ID;
    }

    public int getLineNumber() {
        return this.lineNum;
    }

    private String getSource() {
        if (this.lineNum >= 0) {
            return "(line " + this.lineNum + ") in " + String.valueOf(this.sourceFile.getFileName());
        }
        return "(File ID) in " + String.valueOf(this.sourceFile.getFileName());
    }

    public String getHelpPath() {
        if (this.anchorName == null) {
            return this.helpRelativePath.toString();
        }
        return this.helpRelativePath.toString() + "#" + this.anchorName;
    }

    public String toString() {
        if (this.lineNum < 0) {
            return "Anchor Definition: " + this.ID + this.getSource();
        }
        return "<a name=\"" + this.anchorName + "\"> " + this.getSource();
    }
}

