/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.DecompileCallback;
import ghidra.app.plugin.processors.sleigh.ContextCache;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.symbol.ContextSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;
import ghidra.app.util.DataTypeDependencyOrderer;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.ProcessorContextView;
import ghidra.program.model.lang.ProgramProcessorContext;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.XmlEncode;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.Msg;
import ghidra.util.xml.SpecXmlUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class DecompileDebug {
    private Function func = null;
    private Program program;
    private File debugFile;
    private Map<String, Object> specExtensions;
    private ArrayList<Namespace> dbscope;
    private ArrayList<String> database;
    private ArrayList<DataType> dtypes;
    private ArrayList<String> context;
    private ArrayList<String> cpool;
    private ArrayList<String> flowoverride;
    private ArrayList<String> inject;
    private TreeSet<ByteChunk> byteset;
    private TreeSet<Address> contextchange;
    private TreeMap<Address, DecompileCallback.StringData> stringmap;
    private Register contextRegister;
    private ProgramContext progctx;
    private String comments;
    private Namespace globalnamespace;
    private AddressRange readonlycache;
    private boolean readonlycacheval;
    private PcodeDataTypeManager dtmanage;

    public DecompileDebug(File debugf) {
        this.debugFile = debugf;
        this.specExtensions = new TreeMap<String, Object>();
        this.dbscope = new ArrayList();
        this.database = new ArrayList();
        this.dtypes = new ArrayList();
        this.context = new ArrayList();
        this.cpool = new ArrayList();
        this.byteset = new TreeSet();
        this.contextchange = new TreeSet();
        this.stringmap = new TreeMap();
        this.flowoverride = new ArrayList();
        this.inject = new ArrayList();
        this.contextRegister = null;
        this.comments = null;
        this.globalnamespace = null;
        this.readonlycache = null;
        this.readonlycacheval = false;
    }

    public void setFunction(Function f) {
        this.func = f;
        this.program = f.getProgram();
        this.progctx = this.program.getProgramContext();
        this.contextRegister = this.progctx.getBaseContextRegister();
        this.globalnamespace = this.program.getGlobalNamespace();
    }

    public void setPcodeDataTypeManager(PcodeDataTypeManager dtm) {
        this.dtmanage = dtm;
    }

    public void shutdown(Language pcodelanguage, String xmlOptions) {
        BufferedOutputStream debugStream;
        if (this.debugFile.exists()) {
            this.debugFile.delete();
        }
        try {
            debugStream = new BufferedOutputStream(new FileOutputStream(this.debugFile));
        }
        catch (FileNotFoundException e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            return;
        }
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("<xml_savefile");
            SpecXmlUtils.xmlEscapeAttribute((StringBuilder)buf, (String)"name", (String)this.func.getName());
            SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"target", (String)"default");
            SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)buf, (String)"adjustvma", (long)0L);
            buf.append(">\n");
            ((OutputStream)debugStream).write(buf.toString().getBytes());
            this.dumpImage(debugStream, pcodelanguage);
            this.dumpExtensions(debugStream);
            this.dumpCoretypes(debugStream);
            ((OutputStream)debugStream).write("<save_state>\n".getBytes());
            this.dumpDataTypes(debugStream);
            this.dumpDatabases(debugStream);
            ((OutputStream)debugStream).write("<context_points>\n".getBytes());
            this.dumpPointsetContext(debugStream);
            this.dumpTrackedContext(debugStream);
            ((OutputStream)debugStream).write("</context_points>\n".getBytes());
            this.dumpComments(debugStream);
            this.dumpStringData(debugStream);
            this.dumpCPool(debugStream);
            this.dumpConfiguration(debugStream, xmlOptions);
            this.dumpFlowOverride(debugStream);
            this.dumpInject(debugStream);
            ((OutputStream)debugStream).write("</save_state>\n".getBytes());
            ((OutputStream)debugStream).write("</xml_savefile>\n".getBytes());
            ((OutputStream)debugStream).close();
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    private void dumpImage(OutputStream debugStream, Language pcodelanguage) throws IOException {
        Object binimage = "<binaryimage arch=\"";
        binimage = (String)binimage + String.valueOf(pcodelanguage.getLanguageID());
        binimage = (String)binimage + ":";
        binimage = (String)binimage + String.valueOf(this.program.getCompilerSpec().getCompilerSpecID());
        binimage = (String)binimage + "\">\n";
        debugStream.write(((String)binimage).getBytes());
        this.dumpBytes(debugStream);
        debugStream.write("</binaryimage>\n".getBytes());
    }

    private boolean isReadOnly(Address addr) {
        if (this.readonlycache != null && this.readonlycache.contains(addr)) {
            return this.readonlycacheval;
        }
        MemoryBlock block = this.program.getMemory().getBlock(addr);
        this.readonlycache = null;
        this.readonlycacheval = false;
        if (block != null) {
            this.readonlycacheval = !block.isWrite();
            this.readonlycache = new AddressRangeImpl(block.getStart(), block.getEnd());
        }
        return this.readonlycacheval;
    }

    private void dumpBytes(OutputStream debugStream) throws IOException {
        StringBuilder buf = new StringBuilder();
        Iterator<ByteChunk> iter = this.byteset.iterator();
        AddressSpace lastspace = null;
        long lastoffset = 0L;
        boolean lastreadonly = false;
        boolean tagstarted = false;
        while (iter.hasNext()) {
            int i;
            ByteChunk chunk = iter.next();
            AddressSpace space = chunk.addr.getAddressSpace();
            boolean readval = this.isReadOnly(chunk.addr);
            if (lastreadonly != readval) {
                lastspace = null;
                lastreadonly = readval;
            }
            if (tagstarted && (chunk.min != 0 || lastspace != space || lastoffset != chunk.addr.getOffset())) {
                buf.append("\n</bytechunk>\n");
                tagstarted = false;
            }
            if (!tagstarted) {
                buf.append("<bytechunk");
                SpecXmlUtils.encodeStringAttribute((StringBuilder)buf, (String)"space", (String)space.getName());
                SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"offset", (long)(chunk.addr.getOffset() + (long)chunk.min));
                if (lastreadonly) {
                    SpecXmlUtils.encodeBooleanAttribute((StringBuilder)buf, (String)"readonly", (boolean)lastreadonly);
                }
                buf.append(">\n");
                tagstarted = true;
            }
            for (i = 0; i < chunk.min; ++i) {
                buf.append("  ");
            }
            for (i = chunk.min; i < chunk.max; ++i) {
                int hi = chunk.val[i] >> 4 & 0xF;
                int lo = chunk.val[i] & 0xF;
                hi = hi > 9 ? (hi += 87) : (hi += 48);
                lo = lo > 9 ? (lo += 87) : (lo += 48);
                buf.append((char)hi);
                buf.append((char)lo);
            }
            buf.append('\n');
            if (chunk.max != 16) {
                buf.append("</bytechunk>\n");
                tagstarted = false;
                continue;
            }
            lastoffset = chunk.addr.getOffset() + 16L;
            lastspace = space;
        }
        if (tagstarted) {
            buf.append("</bytechunk>\n");
        }
        debugStream.write(buf.toString().getBytes());
    }

    private void dumpStringData(OutputStream debugStream) throws IOException {
        if (this.stringmap.isEmpty()) {
            return;
        }
        XmlEncode encoder = new XmlEncode();
        encoder.openElement(ElementId.ELEM_STRINGMANAGE);
        for (Map.Entry<Address, DecompileCallback.StringData> entry : this.stringmap.entrySet()) {
            encoder.openElement(ElementId.ELEM_STRING);
            AddressXML.encode((Encoder)encoder, (Address)entry.getKey());
            encoder.openElement(ElementId.ELEM_BYTES);
            encoder.writeBool(AttributeId.ATTRIB_TRUNC, entry.getValue().isTruncated);
            StringBuilder buf = new StringBuilder();
            int count = 0;
            for (byte element : entry.getValue().byteData) {
                int hi = element >> 4 & 0xF;
                int lo = element & 0xF;
                hi = hi > 9 ? (hi += 87) : (hi += 48);
                lo = lo > 9 ? (lo += 87) : (lo += 48);
                buf.append((char)hi);
                buf.append((char)lo);
                if (count % 20 == 19) {
                    buf.append("\n  ");
                }
                ++count;
            }
            buf.append("00\n");
            encoder.writeString(AttributeId.ATTRIB_CONTENT, buf.toString());
            encoder.closeElement(ElementId.ELEM_BYTES);
            encoder.closeElement(ElementId.ELEM_STRING);
        }
        encoder.closeElement(ElementId.ELEM_STRINGMANAGE);
        encoder.writeTo(debugStream);
    }

    private void dumpDataTypes(OutputStream debugStream) throws IOException {
        XmlEncode encoder = new XmlEncode();
        encoder.openElement(ElementId.ELEM_TYPEGRP);
        encoder.writeSignedInteger(AttributeId.ATTRIB_STRUCTALIGN, 4L);
        DataTypeDependencyOrderer TypeOrderer = new DataTypeDependencyOrderer((DataTypeManager)this.program.getDataTypeManager(), this.dtypes);
        for (DataType dataType : TypeOrderer.getCompositeList()) {
            this.dtmanage.encodeCompositeZeroSizePlaceholder((Encoder)encoder, dataType);
        }
        for (DataType dataType : TypeOrderer.getDependencyList()) {
            if (dataType instanceof BuiltIn) continue;
            this.dtmanage.encodeType((Encoder)encoder, dataType, dataType.getLength());
        }
        encoder.closeElement(ElementId.ELEM_TYPEGRP);
        encoder.writeTo(debugStream);
    }

    private void dumpTrackedContext(OutputStream debugStream) throws IOException {
        for (String element : this.context) {
            debugStream.write(element.getBytes());
        }
    }

    private ArrayList<ContextSymbol> getContextSymbols() {
        Symbol[] list;
        Language lang = this.program.getLanguage();
        if (!(lang instanceof SleighLanguage)) {
            return null;
        }
        ArrayList<ContextSymbol> res = new ArrayList<ContextSymbol>();
        for (Symbol element : list = ((SleighLanguage)lang).getSymbolTable().getSymbolList()) {
            if (!(element instanceof ContextSymbol)) continue;
            res.add((ContextSymbol)element);
        }
        return res;
    }

    private void getContextChangePoints(Address addr) {
        AddressRange addrrange = this.progctx.getRegisterValueRangeContaining(this.contextRegister, addr);
        if (addrrange == null) {
            return;
        }
        this.contextchange.add(addrrange.getMinAddress());
        try {
            Address nextaddr = addrrange.getMaxAddress().add(1L);
            this.contextchange.add(nextaddr);
        }
        catch (AddressOutOfBoundsException addressOutOfBoundsException) {
            // empty catch block
        }
    }

    private void dumpPointsetContext(OutputStream debugStream) throws IOException {
        ArrayList<ContextSymbol> ctxsymbols = this.getContextSymbols();
        if (ctxsymbols == null) {
            return;
        }
        ContextCache ctxcache = new ContextCache();
        ctxcache.registerVariable(this.contextRegister);
        int[] buf = new int[ctxcache.getContextSize()];
        int[] lastbuf = null;
        for (Address addr : this.contextchange) {
            int i;
            ProgramProcessorContext procctx = new ProgramProcessorContext(this.progctx, addr);
            ctxcache.getContext((ProcessorContextView)procctx, buf);
            if (lastbuf != null) {
                for (i = 0; i < buf.length && buf[i] == lastbuf[i]; ++i) {
                }
                if (i == buf.length) {
                    continue;
                }
            } else {
                lastbuf = new int[buf.length];
            }
            for (i = 0; i < buf.length; ++i) {
                lastbuf[i] = buf[i];
            }
            XmlEncode encoder = new XmlEncode();
            encoder.openElement(ElementId.ELEM_CONTEXT_POINTSET);
            AddressXML.encodeAttributes((Encoder)encoder, (Address)addr);
            for (ContextSymbol sym : ctxsymbols) {
                int sbit = sym.getInternalLow();
                int ebit = sym.getInternalHigh();
                int word = sbit / 32;
                int startbit = sbit - word * 32;
                int endbit = ebit - word * 32;
                int shift = 32 - endbit - 1;
                int mask = -1 >>> startbit + shift;
                int val = buf[word] >>> shift & mask;
                encoder.openElement(ElementId.ELEM_SET);
                encoder.writeString(AttributeId.ATTRIB_NAME, sym.getName());
                encoder.writeSignedInteger(AttributeId.ATTRIB_VAL, (long)val);
                encoder.closeElement(ElementId.ELEM_SET);
            }
            encoder.closeElement(ElementId.ELEM_CONTEXT_POINTSET);
            encoder.writeTo(debugStream);
        }
    }

    private void dumpCPool(OutputStream debugStream) throws IOException {
        if (this.cpool.size() == 0) {
            return;
        }
        debugStream.write("<constantpool>\n".getBytes());
        for (String rec : this.cpool) {
            debugStream.write(rec.getBytes());
        }
        debugStream.write("</constantpool>\n".getBytes());
    }

    private void dumpComments(OutputStream debugStream) throws IOException {
        if (this.comments != null) {
            debugStream.write(this.comments.getBytes());
        }
    }

    private void dumpConfiguration(OutputStream debugStream, String xmlOptions) throws IOException {
        if (xmlOptions != null && xmlOptions.length() != 0) {
            debugStream.write(xmlOptions.getBytes());
        }
    }

    private void dumpFlowOverride(OutputStream debugStream) throws IOException {
        if (this.flowoverride.size() == 0) {
            return;
        }
        debugStream.write("<flowoverridelist>\n".getBytes());
        for (String element : this.flowoverride) {
            debugStream.write(element.getBytes());
        }
        debugStream.write("</flowoverridelist>\n".getBytes());
    }

    private void dumpInject(OutputStream debugStream) throws IOException {
        if (this.inject.size() == 0) {
            return;
        }
        debugStream.write("<injectdebug>\n".getBytes());
        for (String element : this.inject) {
            debugStream.write(element.getBytes());
        }
        debugStream.write("</injectdebug>\n".getBytes());
    }

    private ArrayList<Namespace> orderNamespaces() {
        TreeMap<Long, Namespace> namespaceMap = new TreeMap<Long, Namespace>();
        for (Namespace namespace : this.dbscope) {
            namespaceMap.put(namespace.getID(), namespace);
        }
        ArrayList<Namespace> res = new ArrayList<Namespace>();
        while (!namespaceMap.isEmpty()) {
            Long key;
            Namespace parent;
            Map.Entry entry = namespaceMap.firstEntry();
            Long curKey = (Long)entry.getKey();
            Namespace curSpace = (Namespace)entry.getValue();
            while ((parent = curSpace.getParentNamespace()) != null && (parent = (Namespace)namespaceMap.get(key = HighFunction.collapseToGlobal((Namespace)parent) ? Long.valueOf(0L) : Long.valueOf(parent.getID()))) != null) {
                curKey = key;
                curSpace = parent;
            }
            res.add(curSpace);
            namespaceMap.remove(curKey);
        }
        return res;
    }

    private void dumpDatabases(OutputStream debugStream) throws IOException {
        Namespace scopename = null;
        ArrayList<Namespace> spaceList = this.orderNamespaces();
        debugStream.write("<db scopeidbyname=\"false\">\n".getBytes());
        Iterator<Namespace> iterator = spaceList.iterator();
        while (iterator.hasNext()) {
            Namespace parentNamespace;
            Namespace element;
            scopename = element = iterator.next();
            StringBuilder datahead = new StringBuilder();
            datahead.append("<scope");
            if (scopename != this.globalnamespace) {
                SpecXmlUtils.xmlEscapeAttribute((StringBuilder)datahead, (String)"name", (String)scopename.getName());
                parentNamespace = scopename.getParentNamespace();
                SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)datahead, (String)"id", (long)scopename.getID());
            } else {
                SpecXmlUtils.encodeStringAttribute((StringBuilder)datahead, (String)"name", (String)"");
                SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)datahead, (String)"id", (long)0L);
                parentNamespace = null;
            }
            datahead.append(">\n");
            if (parentNamespace != null) {
                long parentId = HighFunction.collapseToGlobal((Namespace)parentNamespace) ? 0L : parentNamespace.getID();
                datahead.append("<parent");
                SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)datahead, (String)"id", (long)parentId);
                datahead.append("/>\n");
            }
            if (scopename != this.globalnamespace) {
                datahead.append("<rangeequalssymbols/>\n");
            }
            datahead.append("<symbollist>\n");
            debugStream.write(datahead.toString().getBytes());
            for (int j = 0; j < this.database.size(); ++j) {
                String entry;
                Namespace namespc = this.dbscope.get(j);
                if (namespc != scopename || (entry = this.database.get(j)) == null) continue;
                debugStream.write(entry.getBytes());
            }
            debugStream.write("</symbollist>\n</scope>\n".getBytes());
        }
        debugStream.write("</db>\n".getBytes());
    }

    private void dumpExtensions(OutputStream debugStream) throws IOException {
        if (this.specExtensions.isEmpty()) {
            return;
        }
        PcodeInjectLibrary library = this.program.getCompilerSpec().getPcodeInjectLibrary();
        XmlEncode encoder = new XmlEncode();
        encoder.openElement(ElementId.ELEM_SPECEXTENSIONS);
        for (Object obj : this.specExtensions.values()) {
            if (obj instanceof PrototypeModel) {
                PrototypeModel model = (PrototypeModel)obj;
                model.encode((Encoder)encoder, library);
                continue;
            }
            if (!(obj instanceof InjectPayload)) continue;
            InjectPayload payload = (InjectPayload)obj;
            payload.encode((Encoder)encoder);
        }
        encoder.closeElement(ElementId.ELEM_SPECEXTENSIONS);
        encoder.writeTo(debugStream);
    }

    private void dumpCoretypes(OutputStream debugStream) throws IOException {
        XmlEncode encoder = new XmlEncode();
        this.dtmanage.encodeCoreTypes((Encoder)encoder);
        encoder.writeTo(debugStream);
    }

    public void getPcode(Address addr, Instruction instr) {
        if (instr != null) {
            try {
                byte[] bytes;
                int delaySlotsCnt = instr.getDelaySlotDepth();
                if (delaySlotsCnt == 0) {
                    bytes = instr.getBytes();
                } else {
                    int i;
                    Listing listing = instr.getProgram().getListing();
                    int byteCnt = instr.getLength();
                    Instruction[] instructions = new Instruction[delaySlotsCnt + 1];
                    instructions[0] = instr;
                    Address nextAddr = instr.getMaxAddress().add(1L);
                    for (i = 1; i <= delaySlotsCnt; ++i) {
                        instructions[i] = listing.getInstructionAt(nextAddr);
                        int len = instructions[i].getLength();
                        byteCnt += len;
                        nextAddr.add((long)len);
                    }
                    bytes = new byte[byteCnt];
                    byteCnt = 0;
                    for (i = 0; i <= delaySlotsCnt; ++i) {
                        byte[] b = instructions[i].getBytes();
                        System.arraycopy(b, 0, bytes, byteCnt, b.length);
                        byteCnt += b.length;
                    }
                }
                this.getBytes(addr, bytes);
                this.getContextChangePoints(addr);
            }
            catch (MemoryAccessException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void getBytes(Address addr, byte[] res) {
        int off = 0;
        while (off < res.length) {
            ByteChunk chunk = new ByteChunk(this, addr, off, res);
            if (this.byteset.contains(chunk)) {
                ByteChunk match = this.byteset.tailSet(chunk).first();
                match.merge(chunk);
            } else {
                this.byteset.add(chunk);
            }
            Address newaddr = chunk.addr.add((long)chunk.max);
            off = (int)((long)off + (newaddr.getOffset() - addr.getOffset()));
            addr = newaddr;
        }
    }

    public void getStringData(Address addr, DecompileCallback.StringData stringData) {
        this.stringmap.put(addr, stringData);
    }

    public void getComments(String comm) {
        this.comments = comm;
    }

    public void getCodeSymbol(Address addr, long id, String name, Namespace namespace) throws IOException {
        XmlEncode encoder = new XmlEncode();
        encoder.openElement(ElementId.ELEM_MAPSYM);
        encoder.openElement(ElementId.ELEM_LABELSYM);
        encoder.writeString(AttributeId.ATTRIB_NAME, name);
        encoder.writeUnsignedInteger(AttributeId.ATTRIB_ID, id);
        encoder.closeElement(ElementId.ELEM_LABELSYM);
        AddressXML.encode((Encoder)encoder, (Address)addr);
        encoder.openElement(ElementId.ELEM_RANGELIST);
        encoder.closeElement(ElementId.ELEM_RANGELIST);
        encoder.closeElement(ElementId.ELEM_MAPSYM);
        this.getMapped(namespace, encoder.toString());
    }

    public void getNamespacePath(Namespace namespace) {
        while (namespace != null && !HighFunction.collapseToGlobal((Namespace)namespace)) {
            this.dbscope.add(namespace);
            this.database.add(null);
            namespace = namespace.getParentNamespace();
        }
    }

    public void getMapped(Namespace namespc, String res) {
        if (namespc == null || HighFunction.collapseToGlobal((Namespace)namespc)) {
            this.dbscope.add(this.globalnamespace);
        } else {
            this.dbscope.add(namespc);
        }
        this.database.add(res);
    }

    public void getType(DataType dt) {
        this.dtypes.add(dt);
    }

    public void getFNTypes(HighFunction hfunc) {
        this.getType(hfunc.getFunctionPrototype().getReturnType());
        for (int i = 0; i < hfunc.getFunctionPrototype().getNumParams(); ++i) {
            this.getType(hfunc.getFunctionPrototype().getParam(i).getDataType());
        }
    }

    public void getTrackedRegisters(String doc) {
        this.context.add(doc);
    }

    public void getCPoolRef(String rec, long[] refs) {
        StringBuilder buf = new StringBuilder();
        buf.append("<ref");
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"a", (long)refs[0]);
        long val = 0L;
        if (refs.length > 1) {
            val = refs[1];
        }
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"b", (long)val);
        buf.append("/>\n");
        buf.append(rec);
        this.cpool.add(buf.toString());
    }

    public void nameIsUsed(Namespace spc, String nm) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<collision");
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)buffer, (String)"name", (String)nm);
        buffer.append("/>\n");
        this.getMapped(spc, buffer.toString());
    }

    public void addFlowOverride(Address addr, FlowOverride fo) throws IOException {
        XmlEncode encoder = new XmlEncode();
        encoder.openElement(ElementId.ELEM_FLOW);
        if (fo == FlowOverride.BRANCH) {
            encoder.writeString(AttributeId.ATTRIB_TYPE, "branch");
        } else if (fo == FlowOverride.CALL) {
            encoder.writeString(AttributeId.ATTRIB_TYPE, "call");
        } else if (fo == FlowOverride.CALL_RETURN) {
            encoder.writeString(AttributeId.ATTRIB_TYPE, "callreturn");
        } else if (fo == FlowOverride.RETURN) {
            encoder.writeString(AttributeId.ATTRIB_TYPE, "return");
        } else {
            encoder.writeString(AttributeId.ATTRIB_TYPE, "none");
        }
        AddressXML.encode((Encoder)encoder, (Address)this.func.getEntryPoint());
        AddressXML.encode((Encoder)encoder, (Address)addr);
        encoder.closeElement(ElementId.ELEM_FLOW);
        this.flowoverride.add(encoder.toString());
    }

    public void addInject(Address addr, String name, int injectType, String payload) throws IOException {
        XmlEncode encoder = new XmlEncode();
        encoder.openElement(ElementId.ELEM_INJECT);
        encoder.writeString(AttributeId.ATTRIB_NAME, name);
        encoder.writeSignedInteger(AttributeId.ATTRIB_TYPE, (long)injectType);
        AddressXML.encode((Encoder)encoder, (Address)addr);
        encoder.openElement(ElementId.ELEM_PAYLOAD);
        encoder.writeString(AttributeId.ATTRIB_CONTENT, payload);
        encoder.closeElement(ElementId.ELEM_PAYLOAD);
        encoder.closeElement(ElementId.ELEM_INJECT);
        this.inject.add(encoder.toString());
        PcodeInjectLibrary library = this.program.getCompilerSpec().getPcodeInjectLibrary();
        if (library.hasProgramPayload(name, injectType)) {
            InjectPayload programPayload = library.getPayload(injectType, name);
            Object title = injectType == 1 ? "callfixup_" : "callotherfixup_";
            title = (String)title + name;
            this.specExtensions.put((String)title, programPayload);
        }
    }

    public void addPossiblePrototypeExtension(Function testFunc) {
        PrototypeModel model = testFunc.getCallingConvention();
        if (model == null) {
            return;
        }
        if (model.isProgramExtension()) {
            String title = "prototype_" + model.getName();
            this.specExtensions.put(title, model);
        }
    }

    class ByteChunk
    implements Comparable<ByteChunk> {
        public Address addr;
        public int min;
        public int max;
        public byte[] val;

        public ByteChunk(DecompileDebug this$0, Address ad, int off, byte[] v) {
            int i;
            this.addr = ad.getNewAddress(ad.getOffset() & 0xFFFFFFFFFFFFFFF0L);
            this.val = new byte[16];
            this.min = (int)ad.getOffset() & 0xF;
            int len = v.length - off;
            if (this.min + len >= 16) {
                len = 16 - this.min;
            }
            this.max = this.min + len;
            for (i = 0; i < 16; ++i) {
                this.val[i] = 0;
            }
            for (i = 0; i < len; ++i) {
                this.val[this.min + i] = v[off + i];
            }
        }

        public void merge(ByteChunk op2) {
            for (int i = op2.min; i < op2.max; ++i) {
                this.val[i] = op2.val[i];
            }
            if (op2.min < this.min) {
                this.min = op2.min;
            }
            if (op2.max > this.max) {
                this.max = op2.max;
            }
        }

        @Override
        public int compareTo(ByteChunk op2) {
            return this.addr.compareTo((Object)op2.addr);
        }
    }
}

