/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFuncProto;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.decompiler.DecompiledFunction;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.IdentityNameTransformer;
import ghidra.program.model.symbol.NameTransformer;
import ghidra.util.StringUtilities;
import java.util.ArrayList;
import java.util.List;

public class PrettyPrinter {
    public static final String INDENT_STRING = " ";
    private Function function;
    private ClangTokenGroup tokgroup;
    private List<ClangLine> lines = new ArrayList<ClangLine>();
    private NameTransformer transformer;

    public PrettyPrinter(Function function, ClangTokenGroup tokgroup, NameTransformer transformer) {
        this.function = function;
        this.tokgroup = tokgroup;
        this.transformer = transformer != null ? transformer : new IdentityNameTransformer();
        this.flattenLines();
        this.padEmptyLines();
    }

    private void padEmptyLines() {
        for (ClangLine line : this.lines) {
            List<ClangToken> tokenList = line.getAllTokens();
            if (tokenList.size() != 0) continue;
            ClangToken spacer = ClangToken.buildSpacer(null, line.getIndent(), INDENT_STRING);
            spacer.setLineParent(line);
            tokenList.add(0, spacer);
        }
    }

    public Function getFunction() {
        return this.function;
    }

    public List<ClangLine> getLines() {
        return this.lines;
    }

    public DecompiledFunction print() {
        StringBuilder buff = new StringBuilder();
        for (ClangLine line : this.lines) {
            buff.append(line.getIndentString());
            List<ClangToken> tokens = line.getAllTokens();
            for (ClangToken token : tokens) {
                boolean isToken2Clean;
                boolean bl = isToken2Clean = token instanceof ClangFuncNameToken || token instanceof ClangVariableToken || token instanceof ClangTypeToken || token instanceof ClangFieldToken || token instanceof ClangLabelToken;
                if (isToken2Clean && token.getSyntaxType() == 5) {
                    isToken2Clean = false;
                }
                String tokenText = token.getText();
                if (isToken2Clean) {
                    tokenText = this.transformer.simplify(tokenText);
                }
                buff.append(tokenText);
            }
            buff.append(StringUtilities.LINE_SEPARATOR);
        }
        return new DecompiledFunction(this.findSignature(), buff.toString());
    }

    private String findSignature() {
        int nChildren = this.tokgroup.numChildren();
        for (int i = 0; i < nChildren; ++i) {
            ClangNode node = this.tokgroup.Child(i);
            if (!(node instanceof ClangFuncProto)) continue;
            return node.toString() + ";";
        }
        return null;
    }

    private void flattenLines() {
        this.lines = DecompilerUtils.toLines(this.tokgroup);
    }
}

