/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.DockingWindowManager;
import docking.Tool;
import docking.widgets.FindDialog;
import docking.widgets.FindDialogSearcher;
import docking.widgets.SearchLocation;
import docking.widgets.button.GButton;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.table.AbstractDynamicTableColumnStub;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearchLocation;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearcher;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.util.query.TableService;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;

public class DecompilerFindDialog
extends FindDialog {
    private DecompilerPanel decompilerPanel;

    public DecompilerFindDialog(DecompilerPanel decompilerPanel) {
        super("Decompiler Find Text", (FindDialogSearcher)new DecompilerSearcher(decompilerPanel));
        this.decompilerPanel = decompilerPanel;
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFind"));
        GButton showAllButton = new GButton("Search All");
        showAllButton.addActionListener(e -> this.showAll());
        this.removeButton(this.dismissButton);
        this.addButton((JButton)showAllButton);
        this.addButton(this.dismissButton);
    }

    private void showAll() {
        this.close();
        DockingWindowManager dwm = DockingWindowManager.getActiveInstance();
        Tool tool = dwm.getTool();
        TableService tableService = (TableService)tool.getService(TableService.class);
        if (tableService == null) {
            Msg.error((Object)((Object)this), (Object)"Cannot use the Decompiler Search All action without having a TableService installed");
            return;
        }
        List results = this.searcher.searchAll(this.getSearchText(), this.useRegex());
        if (!results.isEmpty()) {
            this.storeSearchText(this.getSearchText());
        }
        Program program = this.decompilerPanel.getProgram();
        DecompilerFindResultsModel model = new DecompilerFindResultsModel((ServiceProvider)tool, program, results);
        String title = "Decompiler Search '%s'".formatted(this.getSearchText());
        String type = "Decompiler Search ";
        String subMenuName = "Search";
        TableComponentProvider provider = tableService.showTable(title, type, (GhidraProgramTableModel)model, subMenuName, null);
        provider.removeAllActions();
        provider.installRemoveItemsAction();
        GhidraThreadedTablePanel panel = provider.getThreadedTablePanel();
        GhidraTable table = panel.getTable();
        ListSelectionModel selectionModel = table.getSelectionModel();
        selectionModel.setSelectionMode(0);
        selectionModel.addListSelectionListener(lse -> {
            if (lse.getValueIsAdjusting()) {
                return;
            }
            int row = table.getSelectedRow();
            if (row == -1) {
                this.searcher.highlightSearchResults(null);
                return;
            }
            DecompilerSearchLocation location = (DecompilerSearchLocation)((Object)((Object)model.getRowObject(row)));
            this.notifySearchHit(location);
        });
        provider.setClosedCallback(() -> this.decompilerPanel.setSearchResults(null));
        provider.setTabText("'%s'".formatted(this.getSearchText()));
    }

    protected void dialogClosed() {
        this.decompilerPanel.setSearchResults(null);
    }

    private class DecompilerFindResultsModel
    extends GhidraProgramTableModel<DecompilerSearchLocation> {
        private List<DecompilerSearchLocation> searchLocations;

        DecompilerFindResultsModel(ServiceProvider sp, Program program, List<SearchLocation> searchLocations) {
            super("Decompiler Search All Results", sp, program, null);
            this.searchLocations = searchLocations.stream().map(l -> (DecompilerSearchLocation)((Object)l)).collect(Collectors.toList());
        }

        protected TableColumnDescriptor<DecompilerSearchLocation> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addVisibleColumn((DynamicTableColumn)new LineNumberColumn(this), 1, true);
            descriptor.addVisibleColumn((DynamicTableColumn)new ContextColumn(this));
            return descriptor;
        }

        protected void doLoad(Accumulator<DecompilerSearchLocation> accumulator, TaskMonitor monitor) throws CancelledException {
            for (DecompilerSearchLocation location : this.searchLocations) {
                accumulator.add((Object)location);
            }
        }

        public ProgramLocation getProgramLocation(int modelRow, int modelColumn) {
            return null;
        }

        public ProgramSelection getProgramSelection(int[] modelRows) {
            return new ProgramSelection();
        }

        private class LineNumberColumn
        extends AbstractDynamicTableColumnStub<DecompilerSearchLocation, Integer> {
            private LineNumberColumn(DecompilerFindResultsModel decompilerFindResultsModel) {
            }

            public Integer getValue(DecompilerSearchLocation rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                FieldLocation fieldLocation = rowObject.getFieldLocation();
                return fieldLocation.getIndex().intValue() + 1;
            }

            public String getColumnName() {
                return "Line";
            }

            public int getColumnPreferredWidth() {
                return 75;
            }
        }

        private class ContextColumn
        extends AbstractDynamicTableColumnStub<DecompilerSearchLocation, String> {
            private ContextColumn(DecompilerFindResultsModel decompilerFindResultsModel) {
            }

            public String getValue(DecompilerSearchLocation rowObject, Settings settings, ServiceProvider sp) throws IllegalArgumentException {
                return rowObject.getTextLine();
            }

            public String getColumnName() {
                return "Context";
            }
        }
    }
}

