/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.ClangHighlightController;
import ghidra.app.decompiler.component.ClangTextField;
import org.apache.commons.lang3.StringUtils;

public class LocationClangHighlightController
extends ClangHighlightController {
    @Override
    public void fieldLocationChanged(FieldLocation location, Field field, EventTrigger trigger) {
        this.clearPrimaryHighlights();
        if (!(field instanceof ClangTextField)) {
            return;
        }
        ClangToken tok = ((ClangTextField)field).getToken(location);
        if (tok == null) {
            return;
        }
        String text = tok.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return;
        }
        this.addPrimaryHighlight(tok, this.defaultHighlightColor);
        if (tok instanceof ClangSyntaxToken) {
            this.addPrimaryHighlightToTokensForParenthesis((ClangSyntaxToken)tok, this.defaultParenColor);
            this.addPrimaryHighlightToTokensForBrace((ClangSyntaxToken)tok, this.defaultParenColor);
        }
    }
}

