/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.widgets.CursorPosition;
import docking.widgets.FindDialogSearcher;
import docking.widgets.SearchLocation;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.actions.DecompilerCursorPosition;
import ghidra.app.plugin.core.decompile.actions.DecompilerSearchLocation;
import ghidra.util.Msg;
import ghidra.util.UserSearchUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DecompilerSearcher
implements FindDialogSearcher {
    private DecompilerPanel decompilerPanel;

    public DecompilerSearcher(DecompilerPanel decompilerPanel) {
        this.decompilerPanel = decompilerPanel;
    }

    public CursorPosition getCursorPosition() {
        FieldLocation fieldLocation = this.decompilerPanel.getCursorPosition();
        return new DecompilerCursorPosition(fieldLocation);
    }

    public CursorPosition getStart() {
        int lineNumber = 0;
        int fieldNumber = 0;
        int column = 0;
        FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, 0, column);
        return new DecompilerCursorPosition(fieldLocation);
    }

    public CursorPosition getEnd() {
        List<Field> lines = this.decompilerPanel.getFields();
        int lineNumber = lines.size() - 1;
        ClangTextField textLine = (ClangTextField)lines.get(lineNumber);
        int fieldNumber = 0;
        int rowCount = textLine.getNumRows();
        int row = rowCount - 1;
        int column = textLine.getNumCols(row);
        FieldLocation fieldLocation = new FieldLocation(lineNumber, fieldNumber, row, column);
        return new DecompilerCursorPosition(fieldLocation);
    }

    public void setCursorPosition(CursorPosition position) {
        this.decompilerPanel.setCursorPosition(((DecompilerCursorPosition)position).getFieldLocation());
    }

    public void highlightSearchResults(SearchLocation location) {
        this.decompilerPanel.setSearchResults(location);
    }

    public SearchLocation search(String text, CursorPosition position, boolean searchForward, boolean useRegex) {
        DecompilerCursorPosition decompilerCursorPosition = (DecompilerCursorPosition)position;
        FieldLocation startLocation = this.getNextSearchStartLocation(decompilerCursorPosition, searchForward);
        return this.doFind(text, startLocation, searchForward, useRegex);
    }

    private FieldLocation getNextSearchStartLocation(DecompilerCursorPosition decompilerCursorPosition, boolean searchForward) {
        FieldLocation startLocation = decompilerCursorPosition.getFieldLocation();
        DecompilerSearchLocation currentSearchLocation = this.decompilerPanel.getSearchResults();
        if (currentSearchLocation == null) {
            return startLocation;
        }
        if (Objects.equals(startLocation, currentSearchLocation.getFieldLocation())) {
            if (searchForward) {
                ++startLocation.col;
            } else {
                int length = currentSearchLocation.getMatchLength();
                startLocation.col += length - 1;
            }
        }
        return startLocation;
    }

    public List<SearchLocation> searchAll(String searchString, boolean isRegex) {
        Pattern pattern = this.createPattern(searchString, isRegex);
        Function<String, SearchMatch> function = this.createForwardMatchFunction(pattern);
        FieldLocation start = new FieldLocation();
        ArrayList<SearchLocation> results = new ArrayList<SearchLocation>();
        DecompilerSearchLocation searchLocation = this.findNext(function, searchString, start);
        while (searchLocation != null) {
            results.add(searchLocation);
            FieldLocation last = searchLocation.getFieldLocation();
            int line = last.getIndex().intValue();
            int field = 0;
            int row = 0;
            int col = last.getCol() + 1;
            start = new FieldLocation(line, field, row, col);
            searchLocation = this.findNext(function, searchString, start);
        }
        return results;
    }

    private DecompilerSearchLocation doFind(String searchString, FieldLocation currentLocation, boolean forwardSearch, boolean isRegex) {
        Pattern pattern = this.createPattern(searchString, isRegex);
        if (forwardSearch) {
            Function<String, SearchMatch> function = this.createForwardMatchFunction(pattern);
            return this.findNext(function, searchString, currentLocation);
        }
        Function<String, SearchMatch> reverse = this.createReverseMatchFunction(pattern);
        return this.findPrevious(reverse, searchString, currentLocation);
    }

    private Pattern createPattern(String searchString, boolean isRegex) {
        int options = 34;
        if (isRegex) {
            try {
                return Pattern.compile(searchString, options);
            }
            catch (PatternSyntaxException e) {
                Msg.showError((Object)this, (Component)this.decompilerPanel, (String)"Regular Expression Syntax Error", (Object)e.getMessage());
                return null;
            }
        }
        return UserSearchUtils.createPattern((String)searchString, (boolean)false, (int)options);
    }

    private Function<String, SearchMatch> createForwardMatchFunction(Pattern pattern) {
        return textLine -> {
            Matcher matcher = pattern.matcher((CharSequence)textLine);
            if (matcher.find()) {
                int start = matcher.start();
                int end = matcher.end();
                return new SearchMatch(start, end, (String)textLine);
            }
            return SearchMatch.NO_MATCH;
        };
    }

    private Function<String, SearchMatch> createReverseMatchFunction(Pattern pattern) {
        return textLine -> {
            Matcher matcher = pattern.matcher((CharSequence)textLine);
            if (!matcher.find()) {
                return SearchMatch.NO_MATCH;
            }
            int start = matcher.start();
            int end = matcher.end();
            matcher.region(start + 1, textLine.length());
            while (matcher.find()) {
                start = matcher.start();
                end = matcher.end();
                matcher.region(start + 1, textLine.length());
            }
            return new SearchMatch(start, end, (String)textLine);
        };
    }

    private DecompilerSearchLocation findNext(Function<String, SearchMatch> matcher, String searchString, FieldLocation currentLocation) {
        int line;
        List<Field> fields = this.decompilerPanel.getFields();
        for (int i = line = currentLocation.getIndex().intValue(); i < fields.size(); ++i) {
            ClangTextField field = (ClangTextField)fields.get(i);
            String partialLine = this.substring(field, (FieldLocation)(i == line ? currentLocation : null), true);
            SearchMatch match = matcher.apply(partialLine);
            if (match == SearchMatch.NO_MATCH) continue;
            if (i == line) {
                String fullLine = field.getText();
                int cursorOffset = fullLine.length() - partialLine.length();
                match.start += cursorOffset;
                match.end += cursorOffset;
            }
            FieldLineLocation lineInfo = this.getFieldIndexFromOffset(match.start, field);
            FieldLocation fieldLocation = new FieldLocation(i, lineInfo.fieldNumber(), 0, lineInfo.column());
            return new DecompilerSearchLocation(fieldLocation, match.start, match.end - 1, searchString, true, field.getText());
        }
        return null;
    }

    private DecompilerSearchLocation findPrevious(Function<String, SearchMatch> matcher, String searchString, FieldLocation currentLocation) {
        int line;
        List<Field> fields = this.decompilerPanel.getFields();
        for (int i = line = currentLocation.getIndex().intValue(); i >= 0; --i) {
            ClangTextField field = (ClangTextField)fields.get(i);
            String textLine = this.substring(field, (FieldLocation)(i == line ? currentLocation : null), false);
            SearchMatch match = matcher.apply(textLine);
            if (match == SearchMatch.NO_MATCH) continue;
            FieldLineLocation lineInfo = this.getFieldIndexFromOffset(match.start, field);
            FieldLocation fieldLocation = new FieldLocation(i, lineInfo.fieldNumber(), 0, lineInfo.column());
            return new DecompilerSearchLocation(fieldLocation, match.start, match.end - 1, searchString, false, field.getText());
        }
        return null;
    }

    private String substring(ClangTextField textField, FieldLocation location, boolean forwardSearch) {
        if (location == null) {
            return textField.getText();
        }
        if (textField.getText().isEmpty()) {
            return "";
        }
        String partialText = textField.getText();
        if (forwardSearch) {
            int nextCol = location.getCol();
            if (nextCol >= partialText.length()) {
                return "";
            }
            return partialText.substring(nextCol);
        }
        return partialText.substring(0, location.getCol());
    }

    private FieldLineLocation getFieldIndexFromOffset(int screenOffset, ClangTextField textField) {
        RowColLocation rowColLocation = textField.textOffsetToScreenLocation(screenOffset);
        return new FieldLineLocation(0, rowColLocation.col());
    }

    private static class SearchMatch {
        private static SearchMatch NO_MATCH = new SearchMatch(-1, -1, null);
        private int start;
        private int end;
        private String textLine;

        SearchMatch(int start, int end, String textLine) {
            this.start = start;
            this.end = end;
            this.textLine = textLine;
        }

        public String toString() {
            if (this == NO_MATCH) {
                return "NO MATCH";
            }
            return "[start=" + this.start + ",end=" + this.end + "]: " + this.textLine;
        }
    }

    private record FieldLineLocation(int fieldNumber, int column) {
    }
}

