/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.DialogComponentProvider;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.FindDialog;
import ghidra.app.decompiler.component.DecompilerFindDialog;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.util.HelpLocation;
import org.apache.commons.lang3.StringUtils;

public class FindAction
extends AbstractDecompilerAction {
    private DecompilerFindDialog findDialog;

    public FindAction() {
        super("Find");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionFind"));
        this.setPopupMenuData(new MenuData(new String[]{"Find..."}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(70, 128));
        this.setEnabled(true);
    }

    public void dispose() {
        if (this.findDialog != null) {
            this.findDialog.dispose();
        }
        super.dispose();
    }

    protected FindDialog getFindDialog(DecompilerPanel decompilerPanel) {
        if (this.findDialog == null) {
            this.findDialog = new DecompilerFindDialog(decompilerPanel);
        }
        return this.findDialog;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        return true;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DecompilerPanel decompilerPanel = context.getDecompilerPanel();
        FindDialog dialog = this.getFindDialog(decompilerPanel);
        String text = decompilerPanel.getSelectedText();
        if (text == null) {
            text = decompilerPanel.getHighlightedText();
        }
        if (!StringUtils.isBlank((CharSequence)text)) {
            dialog.setSearchText(text);
        }
        context.getTool().showDialog((DialogComponentProvider)dialog);
    }
}

