/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import ghidra.dbg.util.ShellUtils;
import ghidra.pty.PtyChild;
import ghidra.pty.ssh.SshPtyEndpoint;
import ghidra.pty.ssh.SshPtySession;
import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class SshPtyChild
extends SshPtyEndpoint
implements PtyChild {
    private String name;

    public SshPtyChild(ChannelExec channel, OutputStream outputStream, InputStream inputStream) {
        super(channel, outputStream, inputStream);
    }

    private String sttyString(Collection<PtyChild.TermMode> mode) {
        StringBuilder sb = new StringBuilder();
        if (mode.contains(PtyChild.Echo.OFF)) {
            sb.append("-echo ");
        } else if (mode.contains(PtyChild.Echo.ON)) {
            sb.append("echo ");
        }
        if (sb.isEmpty()) {
            return "";
        }
        return "stty " + String.valueOf(sb) + "&& ";
    }

    @Override
    public SshPtySession session(String[] args, Map<String, String> env, File workingDirectory, Collection<PtyChild.TermMode> mode) throws IOException {
        if (workingDirectory != null) {
            throw new UnsupportedOperationException();
        }
        String envStr = env == null ? "" : env.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(" ")) + " ";
        String cmdStr = ShellUtils.generateLine(Arrays.asList(args));
        this.channel.setCommand(this.sttyString(mode) + envStr + cmdStr);
        try {
            this.channel.connect();
        }
        catch (JSchException e2) {
            throw new IOException("SSH error", e2);
        }
        return new SshPtySession((Channel)this.channel);
    }

    private String getTtyNameAndStartNullSession(Collection<PtyChild.TermMode> mode) throws IOException {
        this.channel.setCommand(this.sttyString(mode) + "sh -c 'tty && ctrlc() { echo; } && trap ctrlc INT && while true; do sleep 2147483647; done'");
        try {
            this.channel.connect();
        }
        catch (JSchException e) {
            throw new IOException("SSH error", e);
        }
        byte[] buf = new byte[1024];
        for (int i = 0; i < 1024; ++i) {
            int chr = this.inputStream.read();
            if (chr == 10 || chr == -1) {
                return new String(buf, 0, i + 1, "UTF-8").trim();
            }
            buf[i] = (byte)chr;
        }
        throw new IOException("Expected pty name. Got " + new String(buf, 0, 1024, "UTF-8"));
    }

    @Override
    public String nullSession(Collection<PtyChild.TermMode> mode) throws IOException {
        if (this.name == null) {
            this.name = this.getTtyNameAndStartNullSession(mode);
            if ("".equals(this.name)) {
                throw new IOException("Could not determine child remote tty name");
            }
        }
        Msg.debug((Object)this, (Object)("Remote SSH pty: " + this.name));
        return this.name;
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException("The child is not local");
    }

    @Override
    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("The child is not local");
    }

    @Override
    public void setWindowSize(short cols, short rows) {
        this.channel.setPtySize(Short.toUnsignedInt(cols), Short.toUnsignedInt(rows), 0, 0);
    }
}

