/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import ghidra.pty.PtySession;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SshPtySession
implements PtySession {
    private final Channel channel;

    public SshPtySession(Channel channel) {
        this.channel = channel;
    }

    protected int doWaitExited(Long millis) throws InterruptedException, TimeoutException {
        long startMs = System.currentTimeMillis();
        while (!this.channel.isEOF()) {
            Thread.sleep(100L);
            long elapsed = System.currentTimeMillis() - startMs;
            if (millis == null || elapsed <= millis) continue;
            throw new TimeoutException();
        }
        return this.channel.getExitStatus();
    }

    @Override
    public int waitExited() throws InterruptedException {
        try {
            return this.doWaitExited(null);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int waitExited(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long millis = TimeUnit.MILLISECONDS.convert(timeout, unit);
        return this.doWaitExited(millis);
    }

    @Override
    public void destroyForcibly() {
        this.channel.disconnect();
    }

    @Override
    public String description() {
        Session session;
        try {
            session = this.channel.getSession();
        }
        catch (JSchException e) {
            return "ssh";
        }
        return "ssh " + session.getUserName() + "@" + session.getHost() + ":" + session.getPort();
    }
}

