/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DockingActionInputBindingListener;
import docking.KeyEntryTextField;
import docking.MouseEntryTextField;
import docking.widgets.checkbox.GCheckBox;
import gui.event.MouseBinding;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ActionBindingPanel
extends JPanel {
    private static final String DISABLED_HINT = "Select an action";
    private KeyEntryTextField keyEntryField;
    private JCheckBox useMouseBindingCheckBox;
    private MouseEntryTextField mouseEntryField;
    private JPanel textFieldPanel;
    private DockingActionInputBindingListener listener;

    public ActionBindingPanel(DockingActionInputBindingListener listener) {
        this.listener = Objects.requireNonNull(listener);
        this.build();
    }

    private void build() {
        this.setLayout(new BoxLayout(this, 2));
        this.textFieldPanel = new JPanel(new BorderLayout());
        this.keyEntryField = new KeyEntryTextField(20, ks -> this.listener.keyStrokeChanged(ks));
        this.keyEntryField.setDisabledHint(DISABLED_HINT);
        this.keyEntryField.setEnabled(false);
        this.mouseEntryField = new MouseEntryTextField(20, mb -> this.listener.mouseBindingChanged((MouseBinding)mb));
        this.mouseEntryField.setDisabledHint(DISABLED_HINT);
        this.mouseEntryField.setEnabled(false);
        this.textFieldPanel.add((Component)this.keyEntryField, "North");
        String checkBoxText = "Enter Mouse Binding";
        this.useMouseBindingCheckBox = new GCheckBox(checkBoxText);
        this.useMouseBindingCheckBox.setToolTipText("When checked, the text field accepts mouse buttons");
        this.useMouseBindingCheckBox.setName(checkBoxText);
        this.useMouseBindingCheckBox.addItemListener(e -> this.updateTextField());
        this.add(this.textFieldPanel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.useMouseBindingCheckBox);
    }

    private void updateTextField() {
        if (this.useMouseBindingCheckBox.isSelected()) {
            this.textFieldPanel.remove(this.keyEntryField);
            this.textFieldPanel.add((Component)this.mouseEntryField, "North");
        } else {
            this.textFieldPanel.remove(this.mouseEntryField);
            this.textFieldPanel.add((Component)this.keyEntryField, "North");
        }
        this.validate();
        this.repaint();
    }

    public void setKeyBindingData(KeyStroke ks, MouseBinding mb) {
        this.keyEntryField.setKeyStroke(ks);
        this.mouseEntryField.setMouseBinding(mb);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.keyEntryField.clearField();
        this.mouseEntryField.clearField();
        this.keyEntryField.setEnabled(enabled);
        this.mouseEntryField.setEnabled(enabled);
    }

    public void clearKeyStroke() {
        this.keyEntryField.clearField();
    }

    public KeyStroke getKeyStroke() {
        return this.keyEntryField.getKeyStroke();
    }

    public MouseBinding getMouseBinding() {
        return this.mouseEntryField.getMouseBinding();
    }

    public void clearMouseBinding() {
        this.mouseEntryField.clearField();
    }

    public boolean isMouseBinding() {
        return this.useMouseBindingCheckBox.isSelected();
    }
}

