/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ActionToGuiMapper;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.DockingWindowListener;
import docking.DockingWindowManager;
import docking.RootNode;
import docking.WindowActionManager;
import docking.WindowNode;
import docking.action.DockingActionIf;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import ghidra.util.Swing;
import ghidra.util.task.SwingUpdateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobalMenuAndToolBarManager
implements DockingWindowListener {
    private Map<WindowNode, WindowActionManager> windowToActionManagerMap;
    private final MenuHandler menuHandler;
    private final MenuGroupMap menuGroupMap;
    private final DockingWindowManager windowManager;
    private SwingUpdateManager updateManager = new SwingUpdateManager(250, 500, "Context Update Manager", () -> this.updateActions());

    public GlobalMenuAndToolBarManager(DockingWindowManager windowManager, MenuHandler menuHandler, MenuGroupMap menuGroupMap) {
        this.windowManager = windowManager;
        this.menuHandler = menuHandler;
        this.menuGroupMap = menuGroupMap;
        RootNode rootNode = windowManager.getRootNode();
        rootNode.addDockingWindowListener(this);
        WindowActionManager mainWindowActionManager = new WindowActionManager(rootNode, menuHandler, windowManager, menuGroupMap);
        this.windowToActionManagerMap = new HashMap<WindowNode, WindowActionManager>();
        this.windowToActionManagerMap.put(rootNode, mainWindowActionManager);
    }

    public void addAction(DockingActionIf action) {
        for (WindowNode node : this.windowToActionManagerMap.keySet()) {
            Set<Class<?>> contextTypes;
            if (!action.shouldAddToWindow(node instanceof RootNode, contextTypes = node.getContextTypes())) continue;
            WindowActionManager windowActionManager = this.windowToActionManagerMap.get(node);
            windowActionManager.addAction(action);
        }
    }

    public void removeAction(DockingActionIf action) {
        for (WindowActionManager actionManager : this.windowToActionManagerMap.values()) {
            actionManager.removeAction(action);
        }
    }

    public void update() {
        for (WindowActionManager actionManager : this.windowToActionManagerMap.values()) {
            actionManager.update();
        }
    }

    public DockingActionIf getToolbarAction(String actionName) {
        for (WindowActionManager actionManager : this.windowToActionManagerMap.values()) {
            DockingActionIf action = actionManager.getToolbarAction(actionName);
            if (action == null) continue;
            return action;
        }
        return null;
    }

    public void dispose() {
        Swing.runIfSwingOrRunLater(() -> {
            this.updateManager.dispose();
            for (WindowActionManager actionManager : this.windowToActionManagerMap.values()) {
                actionManager.dispose();
            }
            this.windowToActionManagerMap.clear();
        });
    }

    @Override
    public void dockingWindowAdded(WindowNode windowNode) {
    }

    @Override
    public void dockingWindowRemoved(WindowNode windowNode) {
        this.removeWindowActionManager(windowNode);
    }

    @Override
    public void dockingWindowChanged(WindowNode windowNode) {
        List<DockingActionIf> actionsForWindow = this.getActionsForWindow(windowNode);
        if (actionsForWindow.isEmpty()) {
            this.removeWindowActionManager(windowNode);
            return;
        }
        WindowActionManager actionManager = this.windowToActionManagerMap.get(windowNode);
        if (actionManager == null) {
            this.createWindowActionManager(windowNode, actionsForWindow);
        } else {
            actionManager.setActions(actionsForWindow);
        }
    }

    @Override
    public void dockingWindowFocusChanged(WindowNode windowNode) {
        this.updateManager.updateLater();
    }

    private void removeWindowActionManager(WindowNode windowNode) {
        WindowActionManager removedActionManager = this.windowToActionManagerMap.remove(windowNode);
        if (removedActionManager != null) {
            removedActionManager.dispose();
        }
    }

    private void createWindowActionManager(WindowNode windowNode, List<DockingActionIf> actionsForWindow) {
        WindowActionManager newActionManager = new WindowActionManager(windowNode, this.menuHandler, this.windowManager, this.menuGroupMap);
        this.windowToActionManagerMap.put(windowNode, newActionManager);
        newActionManager.setActions(actionsForWindow);
        this.updateManager.updateLater();
    }

    private List<DockingActionIf> getActionsForWindow(WindowNode windowNode) {
        ActionToGuiMapper actionManager = this.windowManager.getActionToGuiMapper();
        Set<DockingActionIf> globalActions = actionManager.getGlobalActions();
        ArrayList<DockingActionIf> actionsForWindow = new ArrayList<DockingActionIf>(globalActions.size());
        Set<Class<?>> contextTypes = windowNode.getContextTypes();
        for (DockingActionIf action : globalActions) {
            if (!action.shouldAddToWindow(windowNode instanceof RootNode, contextTypes)) continue;
            actionsForWindow.add(action);
        }
        return actionsForWindow;
    }

    public void contextChanged() {
        this.updateManager.updateLater();
    }

    private void updateActions() {
        WindowNode focusedWindowNode = this.getFocusedWindowNode();
        Set<DockingActionIf> focusedWindowActions = this.getWindowActions(focusedWindowNode);
        Map<Class<? extends ActionContext>, ActionContext> defaultContextMap = this.windowManager.getDefaultActionContextMap();
        for (WindowNode windowNode : this.windowToActionManagerMap.keySet()) {
            if (windowNode == focusedWindowNode) continue;
            WindowActionManager actionManager = this.windowToActionManagerMap.get(windowNode);
            ActionContext localContext = this.getContext(windowNode);
            actionManager.contextChanged(defaultContextMap, localContext, focusedWindowActions);
        }
        WindowActionManager actionManager = this.windowToActionManagerMap.get(focusedWindowNode);
        ActionContext focusedContext = this.getContext(focusedWindowNode);
        if (actionManager != null) {
            actionManager.contextChanged(defaultContextMap, focusedContext, Collections.emptySet());
        }
        if (focusedContext != null) {
            this.windowManager.doContextChanged(focusedContext);
        }
    }

    private ActionContext getContext(WindowNode windowNode) {
        ComponentProvider provider;
        if (windowNode == null) {
            return null;
        }
        ActionContext context = null;
        ComponentPlaceholder placeholder = windowNode.getLastFocusedProviderInWindow();
        if (placeholder != null && (provider = placeholder.getProvider()) != null) {
            context = provider.getActionContext(null);
        }
        if (context == null) {
            context = new DefaultActionContext();
        }
        return context;
    }

    private Set<DockingActionIf> getWindowActions(WindowNode windowNode) {
        WindowActionManager windowActionManager;
        if (windowNode != null && (windowActionManager = this.windowToActionManagerMap.get(windowNode)) != null) {
            return windowActionManager.getOriginalActions();
        }
        return Collections.emptySet();
    }

    private WindowNode getFocusedWindowNode() {
        ComponentPlaceholder focusedComponent = this.windowManager.getFocusedComponent();
        if (focusedComponent == null) {
            return null;
        }
        return focusedComponent.getWindowNode();
    }
}

