/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.DialogComponentProvider;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;

public class TaskScheduler
implements Runnable {
    private DialogComponentProvider comp;
    private Task scheduledTask;
    private int scheduledDelay;
    private Task currentTask;
    private int currentDelay;
    private Thread taskThread;

    TaskScheduler(DialogComponentProvider comp) {
        this.comp = comp;
    }

    synchronized void set(Task task, int delay) {
        this.scheduledTask = task;
        this.scheduledDelay = delay;
        if (this.taskThread == null) {
            this.taskThread = new Thread((Runnable)this, "Dialog Task Thread: " + this.comp.getTitle());
            this.taskThread.setPriority(1);
            this.taskThread.start();
        }
    }

    @Override
    public void run() {
        while (this.hasTask()) {
            TaskMonitor tm = this.comp.showProgress(this.currentTask, this.currentDelay);
            this.currentTask.monitoredRun(tm);
        }
    }

    public synchronized Thread getCurrentThread() {
        return this.taskThread;
    }

    public void waitForCurrentTask() {
        Thread t = this.getCurrentThread();
        if (t != null) {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    synchronized void clearScheduledTask() {
        this.scheduledTask = null;
    }

    public synchronized boolean isBusy() {
        return this.taskThread != null || this.scheduledTask != null;
    }

    private synchronized boolean hasTask() {
        if (this.scheduledTask == null) {
            this.taskThread = null;
            this.currentTask = null;
            return false;
        }
        this.currentTask = this.scheduledTask;
        this.currentDelay = this.scheduledDelay;
        this.scheduledTask = null;
        return true;
    }
}

