/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingDialog;
import docking.DockingFrame;
import docking.DockingWindowManager;
import docking.Tool;
import docking.action.DockingAction;
import docking.actions.dialog.ActionChooserDialog;
import docking.actions.dialog.ActionDisplayLevel;
import generic.util.action.SystemKeyBindings;
import ghidra.util.HelpLocation;
import java.awt.KeyboardFocusManager;
import java.awt.Window;

public class ShowActionChooserDialogAction
extends DockingAction {
    public ShowActionChooserDialogAction() {
        super("Show Action Chooser Dialog", "Tool");
        this.createSystemKeyBinding(SystemKeyBindings.ACTION_CHOOSER_KEY);
        this.setHelpLocation(new HelpLocation("KeyboardNavigation", "ActionChooserDialog"));
    }

    @Override
    public void actionPerformed(ActionContext context) {
        KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window focusedWindow = kfm.getFocusedWindow();
        Tool tool = DockingWindowManager.getActiveInstance().getTool();
        if (focusedWindow instanceof DockingDialog) {
            DockingDialog dialog = (DockingDialog)focusedWindow;
            context = dialog.getDialogComponent().getActionContext(null);
            this.showActionsDialog(tool, dialog, context);
        } else if (focusedWindow instanceof DockingFrame) {
            DockingFrame dockingFrame = (DockingFrame)focusedWindow;
            this.showActionsDialog(tool, dockingFrame, context);
        }
    }

    private void showActionsDialog(Tool tool, DockingFrame frame, ActionContext context) {
        ComponentProvider provider = tool.getWindowManager().getActiveComponentProvider();
        ActionChooserDialog actionsDialog = new ActionChooserDialog(tool, provider, context);
        tool.showDialog(actionsDialog);
    }

    private void showActionsDialog(Tool tool, DockingDialog dialog, ActionContext context) {
        DialogComponentProvider dialogProvider = dialog.getDialogComponent();
        if (dialogProvider instanceof ActionChooserDialog) {
            ActionChooserDialog actionsDialog = (ActionChooserDialog)dialogProvider;
            ActionDisplayLevel level = actionsDialog.getActionDisplayLevel();
            actionsDialog.setActionDisplayLevel(level.getNextLevel());
            return;
        }
        ActionChooserDialog actionsDialog = new ActionChooserDialog(tool, dialogProvider, context);
        tool.showDialog(actionsDialog);
    }

    @Override
    public boolean isEnabledForContext(ActionContext context) {
        return true;
    }
}

