/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import docking.DialogComponentProvider;
import docking.KeyEntryTextField;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.actions.KeyBindingUtils;
import docking.actions.KeyBindings;
import docking.actions.ToolActions;
import docking.widgets.label.GIconLabel;
import generic.theme.GAttributes;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import resources.Icons;

public class KeyEntryDialog
extends DialogComponentProvider {
    private KeyBindings keyBindings;
    private ToolActions toolActions;
    private DockingActionIf action;
    private JPanel defaultPanel;
    private KeyEntryTextField keyEntryField;
    private JTextPane collisionPane;
    private StyledDocument doc;
    private SimpleAttributeSet textAttrs;
    private Color bgColor;

    public KeyEntryDialog(Tool tool, DockingActionIf action) {
        super("Set Key Binding for " + action.getName(), true);
        this.action = action;
        this.toolActions = (ToolActions)tool.getToolActions();
        this.keyBindings = new KeyBindings(tool);
        this.setUpAttributes();
        this.createPanel();
        KeyStroke keyBinding = action.getKeyBinding();
        this.updateCollisionPane(keyBinding);
        this.setHelpLocation(new HelpLocation("Tool", "KeyBindingPopup"));
    }

    private void createPanel() {
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    private JPanel buildMainPanel() {
        this.defaultPanel = new JPanel(new BorderLayout());
        this.defaultPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        GIconLabel imageLabel = new GIconLabel(Icons.INFO_ICON);
        this.bgColor = imageLabel.getBackground();
        JTextPane pane = new JTextPane();
        pane.setBorder(BorderFactory.createEmptyBorder(0, 5, 2, 5));
        pane.setBackground(this.bgColor);
        pane.setEditable(false);
        StyledDocument document = pane.getStyledDocument();
        try {
            document.insertString(0, "To add or change a key binding, type any key combination.\nTo remove a key binding, press <Enter> or <Backspace>.", null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        BoxLayout bl = new BoxLayout(labelPanel, 0);
        labelPanel.setLayout(bl);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(imageLabel);
        labelPanel.add(Box.createHorizontalStrut(10));
        labelPanel.add(pane);
        labelPanel.add(Box.createHorizontalStrut(5));
        this.keyEntryField = new KeyEntryTextField(20, keyStroke -> {
            this.okButton.setEnabled(true);
            this.updateCollisionPane(keyStroke);
        });
        this.defaultPanel.add((Component)labelPanel, "North");
        this.defaultPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        JPanel p = new JPanel(new FlowLayout(1));
        p.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        p.add(this.keyEntryField);
        KeyStroke keyBinding = this.action.getKeyBinding();
        if (keyBinding != null) {
            this.keyEntryField.setText(KeyBindingUtils.parseKeyStroke(keyBinding));
        }
        this.setFocusComponent(this.keyEntryField);
        this.defaultPanel.add((Component)p, "Center");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.defaultPanel, "North");
        mainPanel.add((Component)this.createCollisionPanel(), "Center");
        return mainPanel;
    }

    private JPanel createCollisionPanel() {
        JPanel parent = new JPanel(new BorderLayout());
        JPanel noWrapPanel = new JPanel(new BorderLayout());
        this.collisionPane = new JTextPane();
        this.collisionPane.setEditable(false);
        this.collisionPane.setBackground(this.bgColor);
        this.doc = this.collisionPane.getStyledDocument();
        noWrapPanel.add((Component)this.collisionPane, "Center");
        JScrollPane sp = new JScrollPane(noWrapPanel);
        Dimension d = this.defaultPanel.getPreferredSize();
        sp.setPreferredSize(new Dimension(sp.getPreferredSize().width, d.height));
        parent.add((Component)sp, "Center");
        return parent;
    }

    public void setKeyStroke(KeyStroke ks) {
        this.keyEntryField.setKeyStroke(ks);
        this.updateCollisionPane(ks);
    }

    @Override
    protected void cancelCallback() {
        this.close();
    }

    @Override
    protected void okCallback() {
        KeyStroke newKs = this.keyEntryField.getKeyStroke();
        String errorMessage = this.toolActions.validateActionKeyBinding(this.action, newKs);
        if (errorMessage != null) {
            this.setStatusText(errorMessage);
            return;
        }
        this.clearStatusText();
        KeyStroke existingKeyStroke = this.action.getKeyBinding();
        if (Objects.equals(existingKeyStroke, newKs)) {
            this.setStatusText("Key binding unchanged");
            return;
        }
        this.action.setUnvalidatedKeyBindingData(newKs == null ? null : new KeyBindingData(newKs));
        this.close();
    }

    private void setUpAttributes() {
        Font font = Gui.getFont((String)"font.standard");
        this.textAttrs = new GAttributes(font, GThemeDefaults.Colors.Messages.NORMAL);
    }

    private void updateCollisionPane(KeyStroke ks) {
        this.clearStatusText();
        this.collisionPane.setText("");
        if (ks == null) {
            return;
        }
        KeyStroke existingKeyStroke = this.action.getKeyBinding();
        if (Objects.equals(existingKeyStroke, ks)) {
            this.setStatusText("Key binding unchanged");
            return;
        }
        String text = this.keyBindings.getActionsForKeyStrokeText(ks);
        try {
            this.doc.insertString(0, text, this.textAttrs);
            this.collisionPane.setCaretPosition(0);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

