/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDLabel;
import generic.theme.Gui;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class FontPropertyEditor
extends PropertyEditorSupport {
    public static final String SAMPLE_STRING = "ABCabc \u00a9\u00ab\u00a7\u0429\u05d1\u062c\u4eb9";
    private FontChooserPanel fontChooserPanel;

    @Override
    public Component getCustomEditor() {
        this.fontChooserPanel = new FontChooserPanel();
        this.fontChooserPanel.updateControls((Font)this.getValue());
        return this.fontChooserPanel;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public void setValue(Object value) {
        if (this.fontChooserPanel != null) {
            this.fontChooserPanel.updateControls((Font)value);
        }
        if (!Objects.equals(value, this.getValue())) {
            super.setValue(value);
        }
    }

    class FontChooserPanel
    extends JPanel {
        private GDLabel previewLabel;
        private GComboBox<FontWrapper> fontCombo;
        private GComboBox<Integer> sizeCombo;
        private GComboBox<String> styleCombo;
        private ActionListener actionListener = e -> this.fontChanged();
        private List<FontWrapper> systemFontNames;

        public FontChooserPanel() {
            this.build();
        }

        public void updateControls(Font font) {
            if (font == null) {
                return;
            }
            this.updatePreviewLabel(font);
            this.fontCombo.removeActionListener(this.actionListener);
            this.sizeCombo.removeActionListener(this.actionListener);
            this.styleCombo.removeActionListener(this.actionListener);
            FontWrapper fontWrapper = new FontWrapper(this, font.getName());
            this.updateComboBoxModeIfNeeded(fontWrapper);
            int styleChoice = font.getStyle();
            int size = font.getSize();
            this.fontCombo.setSelectedItem(fontWrapper);
            this.sizeCombo.setSelectedItem(size);
            this.styleCombo.setSelectedIndex(styleChoice);
            this.fontCombo.addActionListener(this.actionListener);
            this.sizeCombo.addActionListener(this.actionListener);
            this.styleCombo.addActionListener(this.actionListener);
        }

        private void updateComboBoxModeIfNeeded(FontWrapper fontWrapper) {
            if (this.systemFontNames.contains(fontWrapper)) {
                return;
            }
            this.systemFontNames.add(fontWrapper);
            DefaultComboBoxModel<FontWrapper> model = new DefaultComboBoxModel<FontWrapper>(this.systemFontNames.toArray(new FontWrapper[0]));
            this.fontCombo.setModel(model);
        }

        private void build() {
            this.setLayout(new BorderLayout());
            this.add(this.buildTopPanel(), "North");
            this.add(this.buildPreviewLabel(), "Center");
        }

        private Component buildTopPanel() {
            JPanel panel = new JPanel(new FlowLayout(0, 10, 0));
            panel.add(this.buildFontNamePanel());
            panel.add(this.buildSizePanel());
            panel.add(this.buildStylePanel());
            return panel;
        }

        private Component buildPreviewLabel() {
            this.previewLabel = new GDLabel(FontPropertyEditor.SAMPLE_STRING);
            this.previewLabel.setPreferredSize(new Dimension(350, 50));
            this.previewLabel.setHorizontalAlignment(0);
            this.previewLabel.setVerticalAlignment(0);
            this.previewLabel.setMinimumSize(new Dimension(300, 50));
            return this.previewLabel;
        }

        private Component buildStylePanel() {
            JPanel panel = new JPanel(new GridLayout(2, 1));
            GDLabel styleLabel = new GDLabel("Styles");
            Gui.registerFont((JComponent)styleLabel, (int)1);
            styleLabel.setHorizontalAlignment(0);
            panel.add(styleLabel);
            this.styleCombo = new GComboBox<String>(new String[]{"PLAIN", "BOLD", "ITALIC", "BOLD & ITALIC"});
            this.styleCombo.setMaximumRowCount(9);
            this.styleCombo.addActionListener(this.actionListener);
            panel.add(this.styleCombo);
            return panel;
        }

        private Component buildSizePanel() {
            JPanel panel = new JPanel(new GridLayout(2, 1));
            GDLabel sizeLabel = new GDLabel("Sizes");
            Gui.registerFont((JComponent)sizeLabel, (int)1);
            sizeLabel.setHorizontalAlignment(0);
            panel.add(sizeLabel);
            this.sizeCombo = new GComboBox<Integer>((Integer[])IntStream.rangeClosed(1, 72).boxed().toArray(Integer[]::new));
            this.sizeCombo.setMaximumRowCount(9);
            this.sizeCombo.setMaximumRowCount(9);
            this.sizeCombo.addActionListener(this.actionListener);
            panel.add(this.sizeCombo);
            return panel;
        }

        private Component buildFontNamePanel() {
            JPanel panel = new JPanel(new GridLayout(2, 1));
            GDLabel fontLabel = new GDLabel("Fonts");
            Gui.registerFont((JComponent)fontLabel, (int)1);
            fontLabel.setHorizontalAlignment(0);
            panel.add(fontLabel);
            this.systemFontNames = this.getSystemFontNames();
            this.fontCombo = new GComboBox<FontWrapper>(this.systemFontNames.toArray(new FontWrapper[0]));
            this.fontCombo.setMaximumRowCount(9);
            this.fontCombo.addActionListener(this.actionListener);
            panel.add(this.fontCombo);
            return panel;
        }

        private List<FontWrapper> getSystemFontNames() {
            GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Stream<String> stream = Arrays.stream(gEnv.getAvailableFontFamilyNames());
            List collect = stream.map(s -> new FontWrapper(this, (String)s)).collect(Collectors.toList());
            Collections.sort(collect);
            return new ArrayList<FontWrapper>(collect);
        }

        private void fontChanged() {
            FontWrapper fontWrapper = (FontWrapper)this.fontCombo.getSelectedItem();
            String fontNameChoice = fontWrapper.getFontName();
            int styleChoice = this.styleCombo.getSelectedIndex();
            int sizeChoice = (Integer)this.sizeCombo.getSelectedItem();
            Font font = new Font(fontNameChoice, styleChoice, sizeChoice);
            this.updatePreviewLabel(font);
            Swing.runLater(() -> FontPropertyEditor.this.setValue(font));
        }

        private void updatePreviewLabel(Font font) {
            this.previewLabel.setFont(font);
            FontMetrics fm = this.previewLabel.getFontMetrics(font);
            int height = fm.getHeight();
            Dimension d = this.previewLabel.getSize();
            if (d.height < height) {
                d = new Dimension(d.width, height);
                this.previewLabel.setPreferredSize(d);
            }
            this.previewLabel.invalidate();
        }

        private class FontWrapper
        implements Comparable<FontWrapper> {
            private final String fontName;

            private FontWrapper(FontChooserPanel fontChooserPanel, String fontName) {
                this.fontName = fontName;
            }

            private String getFontName() {
                return this.fontName;
            }

            public String toString() {
                return this.fontName;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (!this.getClass().equals(obj.getClass())) {
                    return false;
                }
                FontWrapper otherWrapper = (FontWrapper)obj;
                return this.fontName.toLowerCase().equals(otherWrapper.fontName.toLowerCase());
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.fontName == null ? 0 : this.fontName.toLowerCase().hashCode());
                return result;
            }

            @Override
            public int compareTo(FontWrapper otherWrapper) {
                return this.fontName.compareToIgnoreCase(otherWrapper.fontName);
            }
        }
    }
}

