/*
 * Decompiled with CFR 0.152.
 */
package docking.test;

import docking.AbstractErrDialog;
import docking.ActionContext;
import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.DialogComponentProvider;
import docking.DockableComponent;
import docking.DockingDialog;
import docking.DockingErrorDisplay;
import docking.DockingWindowManager;
import docking.EmptyBorderToggleButton;
import docking.Tool;
import docking.action.ActionContextProvider;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingActionIf;
import docking.actions.DockingToolActions;
import docking.dnd.GClipboard;
import docking.framework.DockingApplicationConfiguration;
import docking.menu.DialogToolbarButton;
import docking.test.TestFailingErrorDisplayWrapper;
import docking.test.TestKeyEventDispatcher;
import docking.widgets.MultiLineLabel;
import docking.widgets.OkDialog;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import generic.test.AbstractGuiTest;
import generic.test.ConcurrentTestExceptionHandler;
import generic.theme.GIcon;
import generic.util.image.ImageUtils;
import ghidra.GhidraTestApplicationLayout;
import ghidra.framework.ApplicationConfiguration;
import ghidra.util.ConsoleErrorDisplay;
import ghidra.util.ErrorDisplay;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.worker.Worker;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import junit.framework.AssertionFailedError;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import resources.icons.UrlImageIcon;
import sun.awt.AppContext;
import util.CollectionUtils;
import utility.application.ApplicationLayout;

public abstract class AbstractDockingTest
extends AbstractGuiTest {
    private static boolean useErrorGUI;
    private static final TestFailingErrorDisplayWrapper ERROR_DISPLAY_WRAPPER;

    public AbstractDockingTest() {
        this.installNonNativeSystemClipboard();
    }

    private void installNonNativeSystemClipboard() {
        AbstractDockingTest.setInstanceField((String)"systemClipboard", GClipboard.class, (Object)new Clipboard("Test Clipboard"));
    }

    @Before
    public void dockingSetUp() {
        ConcurrentTestExceptionHandler.enable();
        AbstractDockingTest.setErrorGUIEnabled(true);
    }

    @After
    public void dockingTearDown() {
        ConcurrentTestExceptionHandler.disable();
    }

    protected ApplicationLayout createApplicationLayout() throws IOException {
        return new GhidraTestApplicationLayout(new File(AbstractDockingTest.getTestDirectoryPath()));
    }

    protected ApplicationConfiguration createApplicationConfiguration() {
        DockingApplicationConfiguration config = new DockingApplicationConfiguration();
        config.setShowSplashScreen(false);
        return config;
    }

    public static void waitForUpdateOnChooser(GhidraFileChooser chooser) throws Exception {
        int totalTime;
        AbstractDockingTest.waitForSwing();
        int timeoutMillis = PRIVATE_LONG_WAIT_TIMEOUT;
        for (totalTime = 0; AbstractDockingTest.pendingUpdate(chooser) && totalTime < timeoutMillis; totalTime += DEFAULT_WAIT_DELAY) {
            Thread.sleep(DEFAULT_WAIT_DELAY);
        }
        if (totalTime >= timeoutMillis) {
            Assert.fail((String)"Timed-out waiting for directory to load");
        }
        AbstractDockingTest.waitForSwing();
    }

    private static boolean pendingUpdate(GhidraFileChooser chooser) {
        return (Boolean)AbstractDockingTest.invokeInstanceMethod((String)"pendingUpdate", (Object)chooser);
    }

    public static Window getWindowByTitleContaining(Window parentWindow, String text) {
        Set<Window> winList = AbstractDockingTest.getWindows(parentWindow);
        for (Window w : winList) {
            String titleForWindow;
            if (!w.isShowing() || !(titleForWindow = AbstractDockingTest.getTitleForWindow(w)).toLowerCase().contains(text.toLowerCase())) continue;
            return w;
        }
        return null;
    }

    protected static Window getWindow(String title) {
        return AbstractDockingTest.getWindowByTitle(null, title);
    }

    protected static Window getWindowByTitle(Window parentWindow, String title) {
        Set<Window> winList = AbstractDockingTest.getWindows(parentWindow);
        for (Window w : winList) {
            String titleForWindow;
            if (!w.isShowing() || !title.equals(titleForWindow = AbstractDockingTest.getTitleForWindow(w))) continue;
            return w;
        }
        return null;
    }

    public static AbstractErrDialog waitForErrorDialog() {
        return AbstractDockingTest.waitForDialogComponent(AbstractErrDialog.class);
    }

    public static OkDialog waitForInfoDialog() {
        return AbstractDockingTest.waitForDialogComponent(OkDialog.class);
    }

    public static Window waitForWindow(Class<?> windowClass) {
        if (!Dialog.class.isAssignableFrom(windowClass) && !Frame.class.isAssignableFrom(windowClass)) {
            throw new IllegalArgumentException(windowClass.getName() + " does not extend Dialog or Frame.");
        }
        int timeout = DEFAULT_WAIT_TIMEOUT;
        int totalTime = 0;
        while (totalTime <= timeout) {
            Set winList = AbstractDockingTest.getAllWindows();
            for (Window w : winList) {
                if (!windowClass.isAssignableFrom(w.getClass()) || !w.isShowing()) continue;
                return w;
            }
            totalTime = (int)((long)totalTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY));
        }
        throw new AssertionFailedError("Timed-out waiting for window of class: " + String.valueOf(windowClass));
    }

    public static Window waitForWindowByTitleContaining(String text) {
        Window window = AbstractDockingTest.getWindowByTitleContaining(null, text);
        if (window != null) {
            return window;
        }
        int totalTime = 0;
        int timeout = DEFAULT_WAIT_TIMEOUT;
        while (totalTime <= timeout) {
            window = AbstractDockingTest.getWindowByTitleContaining(null, text);
            if (window != null) {
                return window;
            }
            totalTime = (int)((long)totalTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY));
        }
        throw new AssertionFailedError("Timed-out waiting for window containg title '" + text + "'");
    }

    @Deprecated
    public static Window waitForWindow(String title, int timeoutMS) {
        return AbstractDockingTest.waitForWindow(title);
    }

    public static Window waitForWindow(String title) {
        Window window = AbstractDockingTest.getWindow(title);
        if (window != null) {
            return window;
        }
        int totalTime = 0;
        int timeout = DEFAULT_WAIT_TIMEOUT;
        while (totalTime <= timeout) {
            window = AbstractDockingTest.getWindow(title);
            if (window != null) {
                return window;
            }
            totalTime = (int)((long)totalTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY));
        }
        throw new AssertionFailedError("Timed-out waiting for window with title '" + title + "'");
    }

    public static Window waitForWindowByName(String name) {
        int time = 0;
        int timeout = DEFAULT_WAIT_TIMEOUT;
        while (time <= timeout) {
            Set allWindows = AbstractDockingTest.getAllWindows();
            for (Window window : allWindows) {
                String windowName = window.getName();
                if (name.equals(windowName) && window.isShowing()) {
                    return window;
                }
                time = (int)((long)time + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY));
            }
        }
        throw new AssertionFailedError("Timed-out waiting for window with name '" + name + "'");
    }

    public static String getMessageText(Window w) {
        Component c = AbstractDockingTest.findComponentByName((Container)w, (String)"MESSAGE-COMPONENT");
        if (c instanceof JLabel) {
            return ((JLabel)c).getText();
        }
        if (c instanceof MultiLineLabel) {
            return ((MultiLineLabel)c).getLabel();
        }
        return null;
    }

    public static String getStatusText(DialogComponentProvider provider) {
        AtomicReference ref = new AtomicReference();
        AbstractDockingTest.runSwing(() -> ref.set(provider.getStatusText()));
        return (String)ref.get();
    }

    public static void closeSaveChangesDialog() {
        AbstractDockingTest.waitForSwing();
        OptionDialog dialog = AbstractDockingTest.getDialogComponent(OptionDialog.class);
        if (dialog == null) {
            return;
        }
        String title = dialog.getTitle();
        boolean isSavePrompt = StringUtils.containsAny((CharSequence)title, (CharSequence[])new CharSequence[]{"Changed", "Saved"});
        if (!isSavePrompt) {
            throw new AssertionError((Object)("Unexpected dialog with title '" + title + "'; Expected a dialog alerting to program changes"));
        }
        if (StringUtils.contains((CharSequence)title, (CharSequence)"Program Changed")) {
            AbstractDockingTest.pressButtonByText(dialog, "Continue");
            return;
        }
        if (StringUtils.contains((CharSequence)title, (CharSequence)"Save Program?")) {
            AbstractDockingTest.pressButtonByText(dialog, "Cancel");
            return;
        }
        throw new AssertionError((Object)("Unexpected dialog with title '" + title + "'; Expected a dialog alerting to program changes"));
    }

    public void close(DialogComponentProvider dialog) {
        if (dialog == null) {
            return;
        }
        AbstractDockingTest.runSwing(() -> dialog.close());
    }

    public void close(Window w) {
        if (w == null) {
            return;
        }
        boolean wait = !this.isOnlyFrame(w);
        AbstractDockingTest.runSwing(() -> w.setVisible(false), (boolean)wait);
    }

    private boolean isOnlyFrame(Window window) {
        if (!(window instanceof Frame)) {
            return false;
        }
        long n = AbstractDockingTest.getAllWindows().stream().filter(w -> w instanceof Frame && w != window).count();
        return n > 0L;
    }

    public static void closeAllWindows(boolean showError) {
        boolean firstClose = true;
        for (Window window : AbstractDockingTest.getAllWindows()) {
            if (!window.isShowing()) continue;
            if (showError) {
                if (firstClose) {
                    firstClose = false;
                    AbstractDockingTest.printOpenWindows();
                }
                String title = AbstractDockingTest.getDebugTitleForWindow(window);
                System.err.println("DockingTestCase - Forced window closure: " + title);
                String errorMessage = AbstractDockingTest.getMessageText(window);
                if (errorMessage != null) {
                    System.err.println("\tWindow error message: " + errorMessage);
                }
            }
            Window w = window;
            AbstractDockingTest.runSwing(() -> w.dispose());
        }
    }

    @Deprecated
    public static void closeAllWindowsAndFrames() {
        AbstractDockingTest.closeAllWindows(false);
    }

    public static void closeAllWindows() {
        AbstractDockingTest.closeAllWindows(false);
    }

    public static String getTitleForWindow(Window window) {
        if (window instanceof Frame) {
            return ((Frame)window).getTitle();
        }
        if (window instanceof Dialog) {
            return ((Dialog)window).getTitle();
        }
        return null;
    }

    private static String getDebugTitleForWindow(Window window) {
        String defaultTitle = "<no title> - id = " + System.identityHashCode(window) + "; class = " + window.getClass().getSimpleName();
        String title = AbstractDockingTest.getDebugTitleForWindow(window, defaultTitle);
        return title;
    }

    private static String getDebugTitleForWindow(Window window, String defaultTitle) {
        if (window instanceof Frame) {
            return "Frame: '" + ((Frame)window).getTitle() + "'";
        }
        if (window instanceof Dialog) {
            return "Dialog: '" + ((Dialog)window).getTitle() + "'";
        }
        return "Non-Frame/Dialog window: " + defaultTitle;
    }

    public static JDialog waitForJDialog(String title) {
        int totalTime = 0;
        while (totalTime <= DEFAULT_WINDOW_TIMEOUT) {
            Set winList = AbstractDockingTest.getAllWindows();
            for (Window w : winList) {
                String windowTitle;
                if (!(w instanceof JDialog) || !w.isShowing() || !title.equals(windowTitle = AbstractDockingTest.getTitleForWindow(w))) continue;
                return (JDialog)w;
            }
            totalTime = (int)((long)totalTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY));
        }
        throw new AssertionFailedError("Timed-out waiting for window with title '" + title + "'");
    }

    @Deprecated
    public static JDialog waitForJDialog(Window window, String title, int timeoutMS) {
        int totalTime = 0;
        while (totalTime <= DEFAULT_WAIT_TIMEOUT) {
            Set<Window> winList = AbstractDockingTest.getWindows(window);
            for (Window w : winList) {
                String windowTitle;
                if (!(w instanceof JDialog) || !w.isShowing() || !title.equals(windowTitle = AbstractDockingTest.getTitleForWindow(w))) continue;
                return (JDialog)w;
            }
            totalTime = (int)((long)totalTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY));
        }
        throw new AssertionFailedError("Timed-out waiting for window with title '" + title + "'");
    }

    public static <T extends Component> T findComponent(DialogComponentProvider provider, Class<T> desiredClass) {
        return (T)AbstractDockingTest.findComponent((Container)provider.getComponent(), desiredClass);
    }

    public static DialogComponentProvider waitForDialogComponent(String title) {
        Window window = AbstractDockingTest.waitForWindow(title);
        Assert.assertNotNull((String)("No window found with title '" + title + "'"), (Object)window);
        if (!(window instanceof DockingDialog)) {
            Assert.fail((String)("Window is not a DockingDialog - '" + title + "'"));
        }
        DockingDialog dd = (DockingDialog)window;
        return dd.getDialogComponent();
    }

    public static <T extends DialogComponentProvider> T waitForDialogComponent(Class<T> ghidraClass) {
        return AbstractDockingTest.waitForDialogComponent(null, ghidraClass, DEFAULT_WINDOW_TIMEOUT);
    }

    @Deprecated
    public static <T extends DialogComponentProvider> T waitForDialogComponent(Window parentWindow, Class<T> clazz, int timeoutMS) {
        if (!DialogComponentProvider.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + " does not extend " + DialogComponentProvider.class.getSimpleName());
        }
        int totalTime = 0;
        while (totalTime <= DEFAULT_WAIT_TIMEOUT) {
            T provider = AbstractDockingTest.getDialogComponent(parentWindow, clazz);
            if (provider != null) {
                return provider;
            }
            totalTime = (int)((long)totalTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY));
        }
        throw new AssertionFailedError("Timed-out waiting for window of class: " + String.valueOf(clazz));
    }

    private static <T extends DialogComponentProvider> T getDialogComponent(Window parentWindow, Class<T> ghidraClass) {
        Set<Window> winList = AbstractDockingTest.getWindows(parentWindow);
        for (Window w : winList) {
            T dialogComponentProvider = AbstractDockingTest.getDialogComponentProvider(w, ghidraClass);
            if (dialogComponentProvider != null) {
                return (T)((DialogComponentProvider)ghidraClass.cast(dialogComponentProvider));
            }
            Set<Window> windows = AbstractDockingTest.getWindows(w);
            for (Window window : windows) {
                dialogComponentProvider = AbstractDockingTest.getDialogComponentProvider(window, ghidraClass);
                if (dialogComponentProvider == null) continue;
                return (T)((DialogComponentProvider)ghidraClass.cast(dialogComponentProvider));
            }
        }
        return null;
    }

    public static <T extends DialogComponentProvider> T getDialogComponent(Class<T> ghidraClass) {
        return AbstractDockingTest.getDialogComponent(null, ghidraClass);
    }

    protected static <T extends DialogComponentProvider> T getDialogComponentProvider(Window window, Class<T> ghidraClass) {
        if (!(window instanceof DockingDialog)) {
            return null;
        }
        if (!window.isShowing()) {
            return null;
        }
        DialogComponentProvider provider = ((DockingDialog)window).getDialogComponent();
        if (provider == null || !provider.isVisible()) {
            return null;
        }
        if (!ghidraClass.isAssignableFrom(provider.getClass())) {
            return null;
        }
        return (T)((DialogComponentProvider)ghidraClass.cast(provider));
    }

    public static <T extends ComponentProvider> T getComponentProvider(Class<T> clazz) {
        DockingWindowManager dwm = AbstractDockingTest.findActiveDockingWindowManager();
        Assert.assertNotNull((String)"Unable to find a DockingWindowManager - is there a tool showing?", (Object)dwm);
        return AbstractDockingTest.getComponentProvider(dwm, clazz);
    }

    private static <T extends ComponentProvider> T getComponentProvider(DockingWindowManager windowManager, Class<T> clazz) {
        T detached = AbstractDockingTest.getDetachedWindowProvider(clazz, windowManager);
        if (detached != null) {
            return detached;
        }
        T t = windowManager.getComponentProvider(clazz);
        return t;
    }

    public static <T extends ComponentProvider> T waitForComponentProvider(Class<T> clazz) {
        DockingWindowManager dwm = AbstractDockingTest.findActiveDockingWindowManager();
        Assert.assertNotNull((String)"Unable to find a DockingWindowManager - is there a tool showing?", (Object)dwm);
        T provider = AbstractDockingTest.doWaitForComponentProvider(dwm, clazz);
        return provider;
    }

    public static <T extends ComponentProvider> T waitForComponentProvider(Class<T> clazz, String title) {
        DockingWindowManager dwm = AbstractDockingTest.findActiveDockingWindowManager();
        Assert.assertNotNull((String)"Unable to find a DockingWindowManager - is there a tool showing?", (Object)dwm);
        T provider = AbstractDockingTest.doWaitForComponentProvider(dwm, clazz, title);
        return provider;
    }

    private static DockingWindowManager findActiveDockingWindowManager() {
        DockingWindowManager activeInstance = DockingWindowManager.getActiveInstance();
        if (activeInstance != null) {
            return activeInstance;
        }
        List managers = (List)AbstractDockingTest.getInstanceField((String)"instances", DockingWindowManager.class);
        for (int i = managers.size() - 1; i >= 0; --i) {
            DockingWindowManager m = (DockingWindowManager)managers.get(i);
            String title = m.getRootFrame().getTitle();
            if (!title.contains("Tool")) continue;
            return m;
        }
        return null;
    }

    private static <T extends ComponentProvider> T doWaitForComponentProvider(DockingWindowManager windowManager, Class<T> clazz) {
        Objects.requireNonNull(windowManager, "DockingWindowManager cannot be null");
        int totalTime = 0;
        while (totalTime <= DEFAULT_WAIT_TIMEOUT) {
            T t = AbstractDockingTest.getComponentProvider(windowManager, clazz);
            if (t != null) {
                return t;
            }
            totalTime = (int)((long)totalTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY));
        }
        throw new AssertionFailedError("Timed-out waiting for ComponentProvider of class: " + String.valueOf(clazz));
    }

    private static <T extends ComponentProvider> T doWaitForComponentProvider(DockingWindowManager windowManager, Class<T> clazz, String title) {
        Objects.requireNonNull(windowManager, "DockingWindowManager cannot be null");
        int totalTime = 0;
        while (totalTime <= DEFAULT_WAIT_TIMEOUT) {
            T t = AbstractDockingTest.getComponentProvider(windowManager, clazz);
            if (Objects.deepEquals(title, ((ComponentProvider)t).getTitle())) {
                return t;
            }
            totalTime = (int)((long)totalTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY));
        }
        throw new AssertionFailedError("Timed-out waiting for ComponentProvider of class: " + String.valueOf(clazz));
    }

    private static <T extends ComponentProvider> T getDetachedWindowProvider(Class<T> providerClass, DockingWindowManager windowManager) {
        Objects.requireNonNull(windowManager, "DockingWindowManager cannot be null");
        AtomicReference ref = new AtomicReference();
        AbstractDockingTest.runSwing(() -> {
            Object rootNode = AbstractDockingTest.getInstanceField((String)"root", (Object)windowManager);
            List windowNodeList = (List)AbstractDockingTest.invokeInstanceMethod((String)"getDetachedWindows", (Object)rootNode);
            for (Object windowNode : windowNodeList) {
                Object childNode = AbstractDockingTest.getInstanceField((String)"child", windowNode);
                ComponentProvider provider = AbstractDockingTest.getComponentProviderFromNode(childNode, providerClass);
                if (provider == null) continue;
                ref.set((ComponentProvider)providerClass.cast(provider));
            }
        });
        return (T)((ComponentProvider)ref.get());
    }

    private static ComponentProvider getComponentProviderFromNode(Object node, Class<? extends ComponentProvider> providerClass) {
        Class<?> nodeClass = node.getClass();
        String className = nodeClass.getName();
        if (className.indexOf("ComponentNode") != -1) {
            List infoList = CollectionUtils.asList((List)((List)AbstractDockingTest.getInstanceField((String)"windowPlaceholders", (Object)node)), ComponentPlaceholder.class);
            for (ComponentPlaceholder info : infoList) {
                ComponentProvider provider = info.getProvider();
                if (provider == null || !providerClass.isAssignableFrom(provider.getClass())) continue;
                return provider;
            }
        } else {
            if (className.indexOf("WindowNode") != -1) {
                Object childNode = AbstractDockingTest.getInstanceField((String)"child", (Object)node);
                return AbstractDockingTest.getComponentProviderFromNode(childNode, providerClass);
            }
            if (className.indexOf("SplitNode") != -1) {
                Object leftNode = AbstractDockingTest.getInstanceField((String)"child1", (Object)node);
                ComponentProvider leftProvider = AbstractDockingTest.getComponentProviderFromNode(leftNode, providerClass);
                if (leftProvider != null) {
                    return leftProvider;
                }
                Object rightNode = AbstractDockingTest.getInstanceField((String)"child2", (Object)node);
                return AbstractDockingTest.getComponentProviderFromNode(rightNode, providerClass);
            }
        }
        return null;
    }

    @Deprecated
    public static <T extends ComponentProvider> T waitForComponentProvider(Window parentWindow, Class<T> providerClass, int maxTimeMS) {
        if (parentWindow == null) {
            throw new NullPointerException("parentWindow cannot be null--if you don't have a parent window, then call waitForComponentProvider(Class<? extends ComponentProvider> providerClass");
        }
        DockingWindowManager dockingWindowManager = DockingWindowManager.getInstance(parentWindow);
        if (dockingWindowManager == null) {
            throw new NullPointerException("Could not find DockingWindowManager instance for window: '" + AbstractDockingTest.getTitleForWindow(parentWindow) + "' - " + String.valueOf(parentWindow));
        }
        return AbstractDockingTest.doWaitForComponentProvider(dockingWindowManager, providerClass);
    }

    protected static Set<Window> getWindows(Window parentWindow) {
        if (parentWindow != null) {
            HashSet<Window> winList = new HashSet<Window>();
            AbstractDockingTest.findWindows(parentWindow, winList);
            return winList;
        }
        return AbstractDockingTest.getAllWindows();
    }

    private static void findWindows(Window win, Set<Window> windowSet) {
        DockingWindowManager winMgr = DockingWindowManager.getInstance(win);
        if (winMgr != null) {
            List<Object> dockableWinList = Collections.emptyList();
            try {
                dockableWinList = winMgr.getWindows(true);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            for (Window w : dockableWinList) {
                windowSet.add(w);
                AbstractDockingTest.findOwnedWindows((Window)w, windowSet);
            }
        } else {
            AbstractDockingTest.findOwnedWindows((Window)win, windowSet);
        }
    }

    public static void pressButtonByText(DialogComponentProvider provider, String buttonText) {
        AbstractDockingTest.pressButtonByText((Container)provider.getComponent(), (String)buttonText, (boolean)true);
    }

    public static void pressButtonByText(DialogComponentProvider provider, String buttonText, boolean waitForCompletion) {
        AbstractDockingTest.pressButtonByText((Container)provider.getComponent(), (String)buttonText, (boolean)waitForCompletion);
    }

    public static void setToggleButtonSelected(Container container, String buttonName, boolean selected) {
        boolean isToggle;
        AbstractButton button = AbstractDockingTest.findAbstractButtonByName((Container)container, (String)buttonName);
        if (button == null) {
            button = AbstractDockingTest.findAbstractButtonByText((Container)container, (String)buttonName);
        }
        if (button == null) {
            throw new AssertionError((Object)("Could not find button by name or text '" + buttonName + "'"));
        }
        boolean bl = isToggle = button instanceof JToggleButton || button instanceof EmptyBorderToggleButton;
        if (!isToggle) {
            throw new AssertionError((Object)("Found a button, but it is not a toggle button.  Text: '" + buttonName + "'"));
        }
        AbstractDockingTest.setToggleButtonSelected(button, selected);
    }

    public static void setToggleButtonSelected(AbstractButton button, boolean selected) {
        boolean isSelected = button.isSelected();
        if (isSelected != selected) {
            AbstractDockingTest.pressButton((AbstractButton)button);
        }
    }

    public static void assertToggleButtonSelected(JToggleButton button, boolean selected) {
        AtomicBoolean ref = new AtomicBoolean();
        AbstractDockingTest.runSwing(() -> ref.set(button.isSelected()));
        Assert.assertEquals((String)"Button not in expected selected state", (Object)selected, (Object)ref.get());
    }

    public static void assertEnabled(JComponent component, boolean enabled) {
        AtomicBoolean ref = new AtomicBoolean();
        AbstractDockingTest.runSwing(() -> ref.set(component.isEnabled()));
        Assert.assertEquals((String)"Component not in expected enablement state", (Object)enabled, (Object)ref.get());
    }

    public static Set<DockingActionIf> getActionsByName(Tool tool, String name) {
        HashSet<DockingActionIf> result = new HashSet<DockingActionIf>();
        Set<DockingActionIf> toolActions = tool.getAllActions();
        for (DockingActionIf action : toolActions) {
            if (!action.getName().equals(name)) continue;
            result.add(action);
        }
        return result;
    }

    public static Set<DockingActionIf> getActionsByOwner(Tool tool, String name) {
        return tool.getDockingActionsByOwnerName(name);
    }

    public static Set<DockingActionIf> getActionsByOwnerAndName(Tool tool, String owner, String name) {
        Set<DockingActionIf> ownerActions = tool.getDockingActionsByOwnerName(owner);
        return ownerActions.stream().filter(action -> action.getName().equals(name)).collect(Collectors.toSet());
    }

    public static DockingActionIf getAction(Tool tool, String name) {
        Set<DockingActionIf> actions = AbstractDockingTest.getActionsByName(tool, name);
        if (actions.isEmpty()) {
            return null;
        }
        if (actions.size() > 1) {
            throw new AssertionFailedError("Found more than one action for name '" + name + "'");
        }
        return (DockingActionIf)CollectionUtils.any(actions);
    }

    public static DockingActionIf getAction(Tool tool, String owner, String name) {
        Set<DockingActionIf> actions = AbstractDockingTest.getActionsByOwnerAndName(tool, owner, name);
        if (actions.isEmpty()) {
            return null;
        }
        if (actions.size() > 1) {
            throw new AssertionFailedError("Found more than one action for name '" + name + " (" + owner + ")'\n\t" + String.valueOf(actions));
        }
        return (DockingActionIf)CollectionUtils.any(actions);
    }

    public static DockingActionIf getLocalAction(ComponentProvider provider, String actionName) {
        Tool tool = provider.getTool();
        DockingToolActions toolActions = tool.getToolActions();
        DockingActionIf action = toolActions.getLocalAction(provider, actionName);
        return action;
    }

    public static DockingActionIf getAction(DialogComponentProvider provider, String actionName) {
        Set<DockingActionIf> actions = provider.getActions();
        for (DockingActionIf action : actions) {
            if (!action.getName().equals(actionName)) continue;
            return action;
        }
        return null;
    }

    public static void performAction(DockingActionIf action) {
        AbstractDockingTest.performAction(action, true);
    }

    public static void performAction(DockingActionIf action, boolean waitForCompletion) {
        ActionContext context = (ActionContext)AbstractDockingTest.runSwing(() -> {
            DefaultActionContext actionContext = new DefaultActionContext();
            DockingWindowManager activeInstance = DockingWindowManager.getActiveInstance();
            if (activeInstance == null) {
                return actionContext;
            }
            ComponentProvider provider = activeInstance.getActiveComponentProvider();
            if (provider == null) {
                return actionContext;
            }
            ActionContext providerContext = provider.getActionContext(null);
            if (providerContext != null) {
                return providerContext;
            }
            return actionContext;
        });
        AbstractDockingTest.doPerformAction(action, context, waitForCompletion);
    }

    private static void doPerformAction(DockingActionIf action, ActionContext context, boolean waitForCompletion) {
        Assert.assertNotNull((String)"Action cannot be null", (Object)action);
        Assert.assertNotNull((String)"Action context cannot be null", (Object)context);
        AbstractDockingTest.runSwing(() -> {
            action.isAddToPopup(context);
            action.isEnabledForContext(context);
            if (action instanceof ToggleDockingActionIf) {
                ToggleDockingActionIf toggleAction;
                toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)action).isSelected());
            }
            action.actionPerformed(context);
        }, (boolean)waitForCompletion);
        if (!Swing.isSwingThread()) {
            AbstractDockingTest.waitForSwing();
        }
    }

    public static void performAction(DockingActionIf action, ComponentProvider provider, boolean wait) {
        ActionContext context = (ActionContext)AbstractDockingTest.runSwing(() -> {
            ActionContext actionContext = new DefaultActionContext();
            if (provider == null) {
                return actionContext;
            }
            ActionContext newContext = provider.getActionContext(null);
            if (newContext == null) {
                return actionContext;
            }
            actionContext = newContext;
            actionContext.setSourceObject(provider.getComponent());
            return actionContext;
        });
        AbstractDockingTest.doPerformAction(action, context, wait);
    }

    public static void performDialogAction(DockingActionIf action, DialogComponentProvider provider, boolean wait) {
        ActionContext context = (ActionContext)AbstractDockingTest.runSwing(() -> {
            ActionContext actionContext = provider.getActionContext(null);
            if (actionContext != null) {
                actionContext.setSourceObject(provider.getComponent());
            }
            return actionContext;
        });
        AbstractDockingTest.doPerformAction(action, context, wait);
    }

    public static void performAction(DockingActionIf action, ActionContext context, boolean wait) {
        AbstractDockingTest.doPerformAction(action, context, wait);
    }

    public static void setToggleActionSelected(ToggleDockingActionIf toggleAction, ActionContext context, boolean selected) {
        AbstractDockingTest.setToggleActionSelected(toggleAction, context, selected, true);
    }

    public static void setToggleActionSelected(ToggleDockingActionIf toggleAction, ActionContext context, boolean selected, boolean wait) {
        boolean shouldPerformAction = (Boolean)AbstractDockingTest.runSwing(() -> toggleAction.isSelected() != selected);
        if (shouldPerformAction) {
            AbstractDockingTest.performAction((DockingActionIf)toggleAction, context, wait);
        }
    }

    public static Component findComponentByName(DialogComponentProvider provider, String name) {
        return AbstractDockingTest.findComponentByName((Container)provider.getComponent(), (String)name, (boolean)false);
    }

    public static JButton findButtonByText(DialogComponentProvider provider, String text) {
        return AbstractDockingTest.findButtonByText((Container)provider.getComponent(), (String)text);
    }

    public static AbstractButton findButtonByName(DialogComponentProvider provider, String name) {
        Component c = AbstractDockingTest.findComponentByName(provider, name);
        if (!(c instanceof AbstractButton)) {
            return null;
        }
        AbstractButton button = (AbstractButton)c;
        return button;
    }

    public static JButton findButtonByIcon(DialogComponentProvider provider, Icon icon) {
        return AbstractDockingTest.findButtonByIcon((Container)provider.getComponent(), (Icon)icon);
    }

    public static JButton findButtonByActionName(Container container, String name) {
        Component[] comps;
        for (Component element : comps = container.getComponents()) {
            JButton button;
            if (element instanceof JButton) {
                Object nameObject;
                DockingActionIf dockingAction;
                button = (JButton)element;
                if (button instanceof DialogToolbarButton && (dockingAction = ((DialogToolbarButton)button).getDockingAction()).getName().equals(name)) {
                    return button;
                }
                Action action = button.getAction();
                if (action == null || (nameObject = action.getValue("name")) == null || !nameObject.toString().equals(name)) continue;
                return button;
            }
            if (!(element instanceof Container) || (button = AbstractDockingTest.findButtonByActionName((Container)element, name)) == null) continue;
            return button;
        }
        return null;
    }

    public static void triggerActionKey(Component c, int modifiers, int keyCode) {
        AbstractDockingTest.triggerKey(c, modifiers, keyCode, '\uffff');
    }

    private static void forceTextComponentFocus(JTextComponent tc) {
        Object contextKey = AbstractDockingTest.getInstanceField((String)"FOCUSED_COMPONENT", (Object)tc);
        AppContext context = AppContext.getAppContext();
        context.put(contextKey, tc);
    }

    public static void triggerActionKey(Component destination, DockingActionIf action) {
        Objects.requireNonNull(destination);
        KeyStroke keyStroke = action.getKeyBinding();
        if (keyStroke == null) {
            throw new IllegalArgumentException("No KeyStroke assigned for the given action");
        }
        int modifiers = keyStroke.getModifiers();
        int keyCode = keyStroke.getKeyCode();
        char keyChar = keyStroke.getKeyChar();
        boolean isDefined = Character.isDefined(keyChar);
        if (!isDefined) {
            keyChar = '\u0000';
        }
        AbstractDockingTest.triggerKey(destination, modifiers, keyCode, keyChar);
    }

    public static void triggerEscapeKey(Component c) {
        if (c instanceof JTextComponent) {
            AbstractDockingTest.triggerFocusGained(c);
        }
        AbstractDockingTest.triggerText(c, "\u001b");
    }

    public static void triggerBackspaceKey(Component c) {
        AbstractDockingTest.triggerText(c, "\b");
    }

    public static void triggerEnter(Component c) {
        AbstractDockingTest.triggerFocusGained(c);
        AbstractDockingTest.triggerActionKey(c, 0, 10);
        AbstractDockingTest.waitForSwing();
    }

    private static void triggerFocusGained(Component component) {
        FocusListener[] listeners = component.getFocusListeners();
        FocusEvent e = new FocusEvent(component, (int)System.currentTimeMillis());
        AbstractDockingTest.runSwing(() -> {
            for (FocusListener l : listeners) {
                l.focusGained(e);
            }
        });
    }

    public static void triggerText(Component destination, String string) {
        AbstractDockingTest.triggerText(destination, string, AbstractDockingTest::processEvent);
    }

    public static void triggerText(Component destination, String string, BiConsumer<Component, KeyEvent> consumer) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int mods = 0;
            int keyCode = 0;
            if (Character.isLetter(c)) {
                if (Character.isUpperCase(c)) {
                    mods = 64;
                    keyCode = 65 + (c - 65);
                } else {
                    keyCode = 65 + (c - 97);
                }
            } else if (Character.isDigit(c)) {
                keyCode = 48 + (c - 48);
            } else {
                switch (c) {
                    case '~': {
                        mods = 64;
                        keyCode = c;
                        break;
                    }
                    case '!': {
                        mods = 64;
                        keyCode = 517;
                        break;
                    }
                    case '@': {
                        mods = 64;
                        keyCode = 512;
                        break;
                    }
                    case '#': {
                        mods = 64;
                        keyCode = 520;
                        break;
                    }
                    case '$': {
                        mods = 64;
                        keyCode = 515;
                        break;
                    }
                    case '%': {
                        mods = 64;
                        keyCode = 53;
                        break;
                    }
                    case '^': {
                        mods = 64;
                        keyCode = 514;
                        break;
                    }
                    case '&': {
                        mods = 64;
                        keyCode = 150;
                        break;
                    }
                    case '*': {
                        mods = 64;
                        keyCode = 151;
                        break;
                    }
                    case '(': {
                        mods = 64;
                        keyCode = 519;
                        break;
                    }
                    case ')': {
                        mods = 64;
                        keyCode = 522;
                        break;
                    }
                    case '_': {
                        mods = 64;
                        keyCode = 523;
                        break;
                    }
                    case '+': {
                        mods = 64;
                        keyCode = 521;
                        break;
                    }
                    case '{': {
                        mods = 64;
                        keyCode = 161;
                        break;
                    }
                    case '}': {
                        mods = 64;
                        keyCode = 162;
                        break;
                    }
                    case '|': {
                        mods = 64;
                        keyCode = 92;
                        break;
                    }
                    case ':': {
                        mods = 64;
                        keyCode = 59;
                        break;
                    }
                    case '\"': {
                        mods = 64;
                        keyCode = 152;
                        break;
                    }
                    case '<': {
                        mods = 64;
                        keyCode = 44;
                        break;
                    }
                    case '>': {
                        mods = 64;
                        keyCode = 46;
                        break;
                    }
                    case '?': {
                        mods = 64;
                        keyCode = 47;
                        break;
                    }
                    case '\'': {
                        mods = 64;
                        keyCode = 222;
                        break;
                    }
                    default: {
                        mods = 0;
                        keyCode = c;
                    }
                }
            }
            AbstractDockingTest.triggerKey(destination, mods, keyCode, c, consumer);
        }
    }

    public static void triggerKey(Component c, KeyStroke ks) {
        int modifiers = ks.getModifiers();
        char keyChar = ks.getKeyChar();
        int keyCode = ks.getKeyCode();
        AbstractDockingTest.triggerKey(c, modifiers, keyCode, keyChar);
    }

    public static void triggerKey(Component c, int modifiers, int keyCode, char keyChar) {
        AbstractDockingTest.triggerKey(c, modifiers, keyCode, keyChar, AbstractDockingTest::processEvent);
    }

    public static void triggerKey(Component c, int modifiers, int keyCode, char keyChar, BiConsumer<Component, KeyEvent> consumer) {
        Objects.requireNonNull(c);
        Objects.requireNonNull(consumer);
        if (c instanceof JTextComponent) {
            JTextComponent tf = (JTextComponent)c;
            AbstractDockingTest.forceTextComponentFocus(tf);
        }
        KeyEvent pressedKE = new KeyEvent(c, 401, System.currentTimeMillis(), modifiers, keyCode, keyChar);
        consumer.accept(c, pressedKE);
        if (!pressedKE.isActionKey()) {
            char updatedKeyChar = keyChar == '\uffff' ? (char)keyCode : keyChar;
            KeyEvent typedKE = new KeyEvent(c, 400, System.currentTimeMillis(), modifiers, 0, updatedKeyChar);
            consumer.accept(c, typedKE);
        }
        KeyEvent releasedKE = new KeyEvent(c, 402, System.currentTimeMillis(), modifiers, keyCode, keyChar);
        consumer.accept(c, releasedKE);
    }

    private static void processEvent(Component c, KeyEvent e) {
        AbstractDockingTest.runSwing(() -> {
            if (TestKeyEventDispatcher.dispatchKeyEvent(e)) {
                return;
            }
            AbstractDockingTest.dispatchKeyEventDirectlyToComponent(c, e);
        }, (boolean)false);
        AbstractDockingTest.waitForSwing();
    }

    private static void dispatchKeyEventDirectlyToComponent(Component c, KeyEvent e) {
        AbstractDockingTest.invokeInstanceMethod((String)"processEvent", (Object)c, (Class[])new Class[]{AWTEvent.class}, (Object[])new Object[]{e});
    }

    public String getClipboardText() throws Exception {
        Clipboard c = GClipboard.getSystemClipboard();
        Transferable t = c.getContents(null);
        try {
            String text = (String)t.getTransferData(DataFlavor.stringFlavor);
            return text;
        }
        catch (UnsupportedFlavorException e) {
            DataFlavor[] flavors;
            Msg.error((Object)((Object)this), (Object)"Unsupported data flavor - 'string'.  Supported flavors: ");
            for (DataFlavor dataFlavor : flavors = t.getTransferDataFlavors()) {
                Msg.error((Object)((Object)this), (Object)("\t" + dataFlavor.getHumanPresentableName()));
            }
            throw e;
        }
    }

    public static boolean isUseErrorGUI() {
        return useErrorGUI;
    }

    public static void setErrorGUIEnabled(boolean enable) {
        DockingErrorDisplay display = enable ? new DockingErrorDisplay() : new ConsoleErrorDisplay();
        ERROR_DISPLAY_WRAPPER.setErrorDisplayDelegate(display);
        Msg.setErrorDisplay((ErrorDisplay)ERROR_DISPLAY_WRAPPER);
        useErrorGUI = enable;
    }

    public static void disposeErrorGUI() {
        Msg.setErrorDisplay((ErrorDisplay)new ConsoleErrorDisplay());
    }

    public ComponentProvider showProvider(Tool tool, String name) {
        ComponentProvider provider = tool.getComponentProvider(name);
        tool.showComponentProvider(provider, true);
        return provider;
    }

    public void closeProvider(ComponentProvider p) {
        AbstractDockingTest.runSwing(() -> p.closeComponent());
    }

    public static Component clickComponentProvider(ComponentProvider provider) {
        JComponent component = provider.getComponent();
        DockableComponent dockableComponent = AbstractDockingTest.getDockableComponent(component);
        AbstractDockingTest.selectTabIfAvailable(dockableComponent);
        Rectangle bounds = component.getBounds();
        int centerX = bounds.x + bounds.width >> 1;
        int centerY = bounds.y + bounds.height >> 1;
        return AbstractDockingTest.clickComponentProvider(provider, 1, centerX, centerY, 1, 0, false);
    }

    protected static void selectTabIfAvailable(DockableComponent dockableComponent) {
        Container parent;
        Container container = parent = dockableComponent != null ? dockableComponent.getParent() : null;
        if (parent instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)parent;
            AbstractDockingTest.runSwing(() -> tabbedPane.setSelectedComponent(dockableComponent), (boolean)true);
        }
    }

    protected static DockableComponent getDockableComponent(JComponent component) {
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof DockableComponent)) continue;
            return (DockableComponent)parent;
        }
        return null;
    }

    public static Component clickComponentProvider(ComponentProvider provider, int button, int x, int y, int clickCount, int modifiers, boolean popupTrigger) {
        JComponent component = provider.getComponent();
        Component clickComponent = SwingUtilities.getDeepestComponentAt(component, x, y);
        AbstractDockingTest.clickMouse((Component)clickComponent, (int)1, (int)x, (int)y, (int)clickCount, (int)modifiers, (boolean)popupTrigger);
        return clickComponent;
    }

    public static void printOpenWindows() {
        Msg.debug(AbstractDockingTest.class, (Object)("Open windows: " + AbstractDockingTest.getOpenWindowsAsString()));
    }

    public static String getOpenWindowsAsString() {
        Set allFoundWindows = AbstractDockingTest.getAllWindows();
        List roots = allFoundWindows.stream().filter(w -> w.getParent() == null).collect(Collectors.toList());
        StringBuilder buffy = new StringBuilder("\n");
        for (Window w2 : roots) {
            if (!AbstractDockingTest.isHierarchyShowing(w2)) continue;
            AbstractDockingTest.windowToString(w2, 0, buffy);
        }
        return buffy.toString();
    }

    private static boolean isHierarchyShowing(Window w) {
        Window[] children;
        if (w.isShowing()) {
            return true;
        }
        for (Window child : children = w.getOwnedWindows()) {
            if (!child.isShowing()) continue;
            return true;
        }
        return false;
    }

    private static void windowToString(Window w, int depth, StringBuilder buffy) {
        Window[] children;
        String title = AbstractDockingTest.getDebugTitleForWindow(w);
        String prefix = StringUtils.repeat((char)'\t', (int)depth);
        String visibility = w.isShowing() ? "" : " (not showing)";
        String padded = prefix + title + visibility;
        buffy.append(padded).append('\n');
        for (Window child : children = w.getOwnedWindows()) {
            AbstractDockingTest.windowToString(child, depth + 1, buffy);
        }
    }

    public static <T> void waitForTableModel(ThreadedTableModel<T, ?> model) {
        AbstractDockingTest.doWaitForTableModel(model);
    }

    private static <T> void doWaitForTableModel(ThreadedTableModel<T, ?> model) {
        AbstractDockingTest.waitForSwing();
        boolean didWait = false;
        int waitTime = 0;
        while (model.isBusy()) {
            didWait = true;
            if ((waitTime = (int)((long)waitTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY))) < PRIVATE_LONG_WAIT_TIMEOUT) continue;
            Msg.error(AbstractDockingTest.class, (Object)AbstractDockingTest.createStackTraceForAllThreads());
            String busyState = AbstractDockingTest.getBusyState(model);
            Msg.error(AbstractDockingTest.class, (Object)busyState);
            throw new AssertException("Timed-out waiting for table model to load in " + waitTime + "ms");
        }
        AbstractDockingTest.waitForSwing();
        if (didWait) {
            AbstractDockingTest.waitForTableModel(model);
        }
    }

    private static String getBusyState(ThreadedTableModel<?, ?> model) {
        Object updateManager = AbstractDockingTest.getInstanceField((String)"updateManager", model);
        SwingUpdateManager sum = (SwingUpdateManager)AbstractDockingTest.getInstanceField((String)"addRemoveUpdater", (Object)updateManager);
        Worker worker = (Worker)AbstractDockingTest.getInstanceField((String)"worker", model);
        String workerState = worker == null ? "<no worker>" : Boolean.toString(worker.isBusy());
        return "Table model busy state - Swing Update Manager? " + sum.isBusy() + "; worker?" + workerState;
    }

    public static GTreeNode getNode(GTree tree, String ... path) {
        GTreeNode rootNode = tree.getModelRoot();
        String rootName = path[0];
        if (!rootNode.getName().equals(rootName)) {
            throw new RuntimeException("When selecting paths by name the first path element must be the name of the root node - path: " + StringUtils.join((Object[])path, (char)'.'));
        }
        GTreeNode node = rootNode;
        for (int i = 1; i < path.length; ++i) {
            GTreeNode child = node.getChild(path[i]);
            if (child == null) {
                throw new RuntimeException("Can't find path " + StringUtils.join((Object[])path, (char)'.') + "   failed at " + path[i]);
            }
            node = child;
        }
        return node;
    }

    public static void expandPath(GTree tree, String ... path) {
        GTreeNode node = AbstractDockingTest.getNode(tree, path);
        tree.expandPath(node);
        AbstractDockingTest.waitForTree(tree);
    }

    public static void expandTree(GTree tree, String ... path) {
        GTreeNode node = AbstractDockingTest.getNode(tree, path);
        tree.expandTree(node);
        AbstractDockingTest.waitForTree(tree);
    }

    public static void selectPath(GTree tree, String ... path) {
        tree.setSelectedNodeByNamePath(path);
        AbstractDockingTest.waitForTree(tree);
    }

    public static void waitForTree(GTree gTree) {
        AbstractDockingTest.doWaitForTree(gTree);
    }

    private static void doWaitForTree(GTree gTree) {
        AbstractDockingTest.waitForSwing();
        boolean didWait = false;
        int waitTime = 0;
        while (gTree.isBusy()) {
            didWait = true;
            if ((waitTime = (int)((long)waitTime + AbstractDockingTest.sleep((long)DEFAULT_WAIT_DELAY))) < DEFAULT_WAIT_TIMEOUT) continue;
            AbstractDockingTest.createStackTraceForAllThreads();
            throw new AssertException("Timed out waiting for tree to load");
        }
        AbstractDockingTest.waitForSwing();
        if (didWait) {
            AbstractDockingTest.waitForTree(gTree);
        }
    }

    public static boolean isEnabled(DockingActionIf action) {
        return (Boolean)AbstractDockingTest.runSwing(() -> action.isEnabledForContext(new DefaultActionContext()));
    }

    public static boolean isEnabled(DockingActionIf action, ActionContextProvider contextProvider) {
        return (Boolean)AbstractDockingTest.runSwing(() -> action.isEnabledForContext(contextProvider.getActionContext(null)));
    }

    public static boolean isEnabled(AbstractButton button) {
        return (Boolean)AbstractDockingTest.runSwing(() -> button.isEnabled());
    }

    public static boolean isSelected(AbstractButton button) {
        return (Boolean)AbstractDockingTest.runSwing(() -> button.isSelected());
    }

    public ActionContext createContext(Object contextObject) {
        return new DefaultActionContext().setContextObject(contextObject);
    }

    public ActionContext createContext(ComponentProvider provider, Object contextObject) {
        return new DefaultActionContext(provider).setContextObject(contextObject);
    }

    public void capture(Component c, String name) throws Exception {
        Image image = AbstractDockingTest.createRenderedImage(c);
        this.writeImage(image, name);
    }

    protected void writeImage(Image image, String name) throws IOException {
        File debugDir = AbstractDockingTest.getDebugFileDirectory();
        File testDir = new File(debugDir, ((Object)((Object)this)).getClass().getSimpleName());
        File dir = new File(testDir, this.testName.getMethodName());
        dir.mkdirs();
        this.writeImage(image, dir, name);
    }

    private void writeImage(Image image, File dir, String name) throws IOException {
        if (!FilenameUtils.isExtension((String)name, (String)"png")) {
            name = (String)name + ".png";
        }
        File imageFile = new File(dir, (String)name);
        AbstractDockingTest.writeImage(image, imageFile);
    }

    public static Image createScreenImage(Component c) throws AWTException {
        if (!Swing.isSwingThread()) {
            AbstractDockingTest.yieldToSwing();
        }
        Rectangle r = c.getBounds();
        Point p = r.getLocation();
        if (!(c instanceof Window)) {
            SwingUtilities.convertPointToScreen(p, c.getParent());
        }
        r.setLocation(p);
        Robot robot = new Robot();
        AbstractDockingTest.sleep((long)100L);
        BufferedImage image = robot.createScreenCapture(r);
        AbstractDockingTest.sleep((long)100L);
        return image;
    }

    public static Image createRenderedImage(Component c) {
        if (!Swing.isSwingThread()) {
            AbstractDockingTest.yieldToSwing();
        }
        Image i = (Image)AbstractDockingTest.runSwing(() -> {
            try {
                return AbstractDockingTest.doCreateRenderedImage(c);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return i;
    }

    private static Image doCreateRenderedImage(Component c) {
        Rectangle r = c.getBounds();
        BufferedImage bufferedImage = new BufferedImage(r.width, r.height, 2);
        Graphics graphics = bufferedImage.getGraphics();
        c.paint(graphics);
        graphics.dispose();
        return bufferedImage;
    }

    public static void writeImage(Image image, File imageFile) throws IOException {
        ImageUtils.writeFile((Image)image, (File)imageFile);
        Msg.info(AbstractDockingTest.class, (Object)("Wrote image to " + imageFile.getCanonicalPath()));
    }

    public void assertIconsEqual(Icon expected, Icon actual) {
        if (expected.equals(actual)) {
            return;
        }
        URL url1 = this.getURL(expected);
        URL url2 = this.getURL(actual);
        if (url1 != null && url1.equals(url2)) {
            return;
        }
        Assert.fail((String)("Expected icon [" + expected.getClass().getSimpleName() + "]" + expected.toString() + ", but got: [" + actual.getClass().getSimpleName() + "]" + actual.toString()));
    }

    public URL getURL(Icon icon) {
        if (icon instanceof UrlImageIcon) {
            UrlImageIcon urlIcon = (UrlImageIcon)icon;
            return urlIcon.getUrl();
        }
        if (icon instanceof GIcon) {
            GIcon gIcon = (GIcon)icon;
            return gIcon.getUrl();
        }
        return null;
    }

    static {
        ConcurrentTestExceptionHandler.registerHandler();
        useErrorGUI = true;
        ERROR_DISPLAY_WRAPPER = new TestFailingErrorDisplayWrapper();
    }
}

