/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.ReusableDialogComponentProvider;
import docking.widgets.CursorPosition;
import docking.widgets.FindDialogSearcher;
import docking.widgets.SearchLocation;
import docking.widgets.button.GRadioButton;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FindDialog
extends ReusableDialogComponentProvider {
    private GhidraComboBox<String> comboBox;
    protected FindDialogSearcher searcher;
    private JButton nextButton;
    private JButton previousButton;
    private JRadioButton stringRadioButton;
    private JRadioButton regexRadioButton;

    public FindDialog(String title, FindDialogSearcher searcher) {
        super(title, false, true, true, true);
        this.searcher = searcher;
        this.addWorkPanel(this.buildMainPanel());
        this.buildButtons();
    }

    private void buildButtons() {
        this.nextButton = new JButton("Next");
        this.nextButton.setMnemonic('N');
        this.nextButton.addActionListener(ev -> this.doSearch(true));
        this.addButton(this.nextButton);
        this.setDefaultButton(this.nextButton);
        this.previousButton = new JButton("Previous");
        this.previousButton.setMnemonic('P');
        this.previousButton.addActionListener(ev -> this.doSearch(false));
        this.addButton(this.previousButton);
        this.addDismissButton();
    }

    private JPanel buildMainPanel() {
        ButtonGroup formatGroup = new ButtonGroup();
        this.stringRadioButton = new GRadioButton("String", true);
        this.regexRadioButton = new GRadioButton("Regular Expression", false);
        formatGroup.add(this.stringRadioButton);
        formatGroup.add(this.regexRadioButton);
        this.comboBox = new GhidraComboBox();
        this.comboBox.setEditable(true);
        this.comboBox.addActionListener(e -> this.doSearch(true));
        this.comboBox.setColumns(20);
        this.comboBox.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.handleDocumentUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.handleDocumentUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.handleDocumentUpdate();
            }

            private void handleDocumentUpdate() {
                String text = FindDialog.this.comboBox.getText();
                FindDialog.this.enableButtons(text.length() != 0);
            }
        });
        GLabel findLabel = new GLabel("Find: ");
        findLabel.setDisplayedMnemonic(78);
        this.comboBox.associateLabel(findLabel);
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel textPanel = new JPanel();
        textPanel.add(findLabel);
        textPanel.add(this.comboBox);
        mainPanel.add((Component)textPanel, "North");
        mainPanel.add((Component)this.buildFormatPanel(), "South");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return mainPanel;
    }

    private void enableButtons(boolean b) {
        this.nextButton.setEnabled(b);
        this.previousButton.setEnabled(b);
    }

    private JPanel buildFormatPanel() {
        JPanel formatPanel = new JPanel();
        formatPanel.setBorder(BorderFactory.createTitledBorder("Format"));
        formatPanel.setLayout(new BoxLayout(formatPanel, 1));
        formatPanel.add(this.stringRadioButton);
        formatPanel.add(this.regexRadioButton);
        return formatPanel;
    }

    @Override
    protected void dialogClosed() {
        this.comboBox.setText("");
    }

    public void next() {
        this.doSearch(true);
    }

    public void previous() {
        this.doSearch(false);
    }

    protected boolean useRegex() {
        return this.regexRadioButton.isSelected();
    }

    private void doSearch(boolean forward) {
        String wrapMessage;
        if (!this.nextButton.isEnabled()) {
            return;
        }
        this.clearStatusText();
        boolean useRegex = this.regexRadioButton.isSelected();
        String searchText = this.comboBox.getText();
        CursorPosition cursorPosition = this.searcher.getCursorPosition();
        SearchLocation searchLocation = this.searcher.search(searchText, cursorPosition, forward, useRegex);
        if (searchLocation != null) {
            this.notifySearchHit(searchLocation);
            return;
        }
        if (forward) {
            wrapMessage = "Reached the bottom, continued from top";
            cursorPosition = this.searcher.getStart();
        } else {
            wrapMessage = "Reached the top, continued from the bottom";
            cursorPosition = this.searcher.getEnd();
        }
        searchLocation = this.searcher.search(searchText, cursorPosition, forward, useRegex);
        if (searchLocation != null) {
            this.notifySearchHit(searchLocation);
            this.notifyUser(wrapMessage);
            return;
        }
        this.notifyUser("Not found");
    }

    protected void notifySearchHit(SearchLocation location) {
        this.searcher.setCursorPosition(location.getCursorPosition());
        this.storeSearchText(location.getSearchText());
        this.searcher.highlightSearchResults(location);
    }

    private void notifyUser(String message) {
        this.setStatus(message);
        this.enableButtons(false);
        this.alertMessage(() -> this.enableButtons(true));
    }

    @Override
    protected void dialogShown() {
        this.clearStatusText();
    }

    String getText() {
        if (this.isVisible()) {
            return this.comboBox.getText();
        }
        return null;
    }

    void setStatus(String statusText) {
        this.setStatusText(statusText);
    }

    public void setSearchText(String text) {
        String searchText = text == null ? this.comboBox.getText() : text;
        this.comboBox.setSelectedItem(searchText);
    }

    public String getSearchText() {
        return this.comboBox.getText();
    }

    public void setHistory(List<String> history) {
        history.forEach(this.comboBox::addToModel);
    }

    protected void storeSearchText(String text) {
        MutableComboBoxModel model = (MutableComboBoxModel)this.comboBox.getModel();
        model.insertElementAt(text, 0);
        int size = model.getSize();
        for (int i = 1; i < size; ++i) {
            String element = (String)model.getElementAt(i);
            if (!element.equals(text)) continue;
            model.removeElementAt(i);
            break;
        }
        model.setSelectedItem(text);
    }
}

