/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.DataToStringConverter;
import docking.widgets.DefaultDropDownSelectionDataModel;
import docking.widgets.DropDownSelectionChoiceListener;
import docking.widgets.DropDownSelectionTextField;
import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.ListSelectionTableDialog;
import docking.widgets.button.BrowseButton;
import docking.widgets.label.GLabel;
import docking.widgets.table.AbstractGTableModel;
import docking.widgets.table.RowObjectTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ListSelectionDialog<T>
extends DialogComponentProvider {
    private DropDownSelectionTextField<T> field;
    protected boolean cancelled;
    private DataToStringConverter<T> searchConverter;
    private DataToStringConverter<T> descriptionConverter;
    private List<T> data;
    private SelectionListener<T> selectionListener;

    public static ListSelectionDialog<String> getStringListSelectionDialog(String title, String label, List<String> data) {
        return new ListSelectionDialog<String>(title, label, new ArrayList<String>(data), DataToStringConverter.stringDataToStringConverter);
    }

    public ListSelectionDialog(String title, String label, List<T> data, DataToStringConverter<T> searchConverter) {
        this(title, label, data, searchConverter, null);
    }

    public ListSelectionDialog(String title, String label, List<T> data, DataToStringConverter<T> searchConverter, DataToStringConverter<T> descriptionConverter) {
        super(title, true, false, true, false);
        this.data = data;
        this.searchConverter = searchConverter;
        this.descriptionConverter = descriptionConverter;
        ArrayList<T> dropDownData = new ArrayList<T>(data);
        DefaultDropDownSelectionDataModel model = new DefaultDropDownSelectionDataModel<T>(this, dropDownData, searchConverter, descriptionConverter){

            @Override
            public List<T> getMatchingData(String searchText) {
                if (searchText.trim().isEmpty()) {
                    return this.data;
                }
                return super.getMatchingData(searchText);
            }
        };
        this.addWorkPanel(this.buildWorkPanel(label, model));
        this.addOKButton();
        this.setOkEnabled(false);
        this.addCancelButton();
    }

    @Override
    protected void cancelCallback() {
        this.cancelled = true;
        super.cancelCallback();
    }

    @Override
    protected void okCallback() {
        this.close();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public T show(Component parent) {
        DockingWindowManager.showDialog(parent, this);
        return this.getSelectedItem();
    }

    public T getSelectedItem() {
        if (!this.cancelled) {
            return this.field.getSelectedValue();
        }
        return null;
    }

    protected JComponent buildWorkPanel(String label, DropDownTextFieldDataModel<T> model) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(40, 40, 30, 40));
        this.field = new DropDownSelectionTextField<T>(model){

            @Override
            protected List<T> getMatchingData(String searchText) {
                if (searchText.trim().isEmpty()) {
                    return this.dataModel.getMatchingData(searchText);
                }
                return super.getMatchingData(searchText);
            }
        };
        this.selectionListener = new SelectionListener();
        this.field.addDropDownSelectionChoiceListener(this.selectionListener);
        GLabel jLabel = new GLabel(label);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
        panel.add((Component)jLabel, "West");
        panel.add(this.field, "Center");
        BrowseButton browseButton = new BrowseButton();
        browseButton.addActionListener(e -> this.browse());
        panel.add((Component)browseButton, "East");
        return panel;
    }

    protected void browse() {
        RowObjectTableModel<T> model = this.getTableModel();
        ListSelectionTableDialog<T> dialog = new ListSelectionTableDialog<T>(this.getTitle(), model);
        T selectedItem = dialog.show(this.getComponent());
        if (selectedItem != null) {
            this.field.setSelectedValue(selectedItem);
            this.setOkEnabled(true);
        }
    }

    private RowObjectTableModel<T> getTableModel() {
        return new DefaultTableModel(this.data);
    }

    public static void main(String[] args) {
        JFrame jFrame = new JFrame();
        jFrame.setVisible(true);
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("Bob");
        list.add("BOb");
        list.add("BoB");
        list.add("bob");
        list.add("bOb");
        list.add("bobby");
        list.add("zzz");
        ListSelectionDialog<String> dialog = ListSelectionDialog.getStringListSelectionDialog("String Picker", "Choose String:", list);
        String selectedValue = dialog.show(jFrame);
        System.out.println("Selected: " + selectedValue);
        System.exit(0);
    }

    private class SelectionListener<T1>
    implements DropDownSelectionChoiceListener<T1> {
        private SelectionListener() {
        }

        @Override
        public void selectionChanged(T1 t) {
            ListSelectionDialog.this.setOkEnabled(t != null);
        }
    }

    private class DefaultTableModel
    extends AbstractGTableModel<T> {
        private List<T> modelData;

        DefaultTableModel(List<T> modelData) {
            this.modelData = new ArrayList(modelData);
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Name";
            }
            return "Description";
        }

        @Override
        public String getName() {
            return ListSelectionDialog.this.getTitle();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public List<T> getModelData() {
            return this.modelData;
        }

        @Override
        public Object getColumnValueForRow(T t, int columnIndex) {
            if (columnIndex == 0) {
                return ListSelectionDialog.this.searchConverter.getString(t);
            }
            return ListSelectionDialog.this.descriptionConverter.getString(t);
        }

        @Override
        public int getColumnCount() {
            return ListSelectionDialog.this.descriptionConverter == null ? 1 : 2;
        }
    }
}

