/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.combobox;

import docking.widgets.GComponent;
import ghidra.util.Swing;
import ghidra.util.exception.AssertException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.text.Document;

public class GhidraComboBox<E>
extends JComboBox<E>
implements GComponent {
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private List<DocumentListener> docListeners = new ArrayList<DocumentListener>();
    private List<KeyListener> keyListeners = new ArrayList<KeyListener>();
    private boolean setSelectedFlag = false;
    private boolean forwardEnter;
    private Action defaultSystemEnterForwardingAction;
    private Document document;
    private PassThroughActionListener passThroughActionListener;
    private PassThroughKeyListener passThroughKeyListener;
    private PassThroughDocumentListener passThroughDocumentListener;
    private DocumentListener documentListener;

    public GhidraComboBox() {
        this.init();
    }

    public GhidraComboBox(ComboBoxModel<E> model) {
        super(model);
        this.init();
    }

    public GhidraComboBox(E[] items) {
        super(items);
        this.init();
    }

    public GhidraComboBox(Collection<E> items) {
        super(new Vector<E>(items));
        this.init();
    }

    @Override
    public void setUI(ComboBoxUI ui) {
        ActionMap am;
        super.setUI(ui);
        this.installPassThroughListeners();
        if (this.document != null) {
            this.setDocument(this.document);
        }
        if ((am = this.getActionMap()) != null) {
            this.defaultSystemEnterForwardingAction = am.get("enterPressed");
            am.put("enterPressed", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (GhidraComboBox.this.forwardEnter) {
                        GhidraComboBox.this.defaultSystemEnterForwardingAction.actionPerformed(e);
                    }
                }
            });
        }
    }

    public void setEnterKeyForwarding(boolean forwardEnter) {
        this.forwardEnter = forwardEnter;
    }

    public String getText() {
        JTextField textField = this.getTextField();
        return textField.getText();
    }

    public void setText(String text) {
        if (!this.isEditable) {
            return;
        }
        JTextField textField = this.getTextField();
        textField.setText(text);
    }

    @Override
    public void setSelectedItem(Object obj) {
        this.setSelectedFlag = true;
        super.setSelectedItem(obj);
        JTextField textField = this.getTextField();
        this.updateTextFieldTextForClearedSelection(textField, obj);
        textField.selectAll();
        this.setSelectedFlag = false;
    }

    public void setColumnCount(int columnCount) {
        JTextField textField = this.getTextField();
        textField.setColumns(columnCount);
    }

    public void selectAll() {
        JTextField textField = this.getTextField();
        textField.selectAll();
    }

    public void clearModel() {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        model.removeAllElements();
    }

    public void addToModel(E item) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        model.addElement(item);
    }

    public void addToModel(Collection<E> items) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (E e : items) {
            model.addElement(e);
        }
    }

    public boolean containsItem(E item) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        return model.getIndexOf(item) != -1;
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.actionListeners.add(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.actionListeners.remove(l);
    }

    public void addEditorKeyListener(KeyListener l) {
        this.keyListeners.add(l);
    }

    public void removeEditorKeyListener(KeyListener l) {
        this.keyListeners.remove(l);
    }

    public void setDocument(Document document) {
        this.document = document;
        JTextField textField = this.getTextField();
        textField.setDocument(document);
        document.removeDocumentListener(this.passThroughDocumentListener);
        document.addDocumentListener(this.passThroughDocumentListener);
    }

    public void addDocumentListener(DocumentListener l) {
        this.docListeners.add(l);
    }

    public void removeDocumentListener(DocumentListener l) {
        this.docListeners.remove(l);
    }

    public void setColumns(int columns) {
        JTextField textField = this.getTextField();
        textField.setColumns(columns);
    }

    public void associateLabel(JLabel label) {
        JTextField textField = this.getTextField();
        label.setLabelFor(textField);
    }

    public void setSelectionStart(int selectionStart) {
        JTextField textField = this.getTextField();
        textField.setSelectionStart(selectionStart);
    }

    public void setSelectionEnd(int selectionEnd) {
        JTextField textField = this.getTextField();
        textField.setSelectionEnd(selectionEnd);
    }

    @Override
    public void requestFocus() {
        if (this.isEditable) {
            JTextField textField = this.getTextField();
            textField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setAutoCompleteEnabled(boolean enable) {
        this.removeDocumentListener(this.documentListener);
        if (enable) {
            this.addDocumentListener(this.documentListener);
        }
    }

    private String matchHistory(String input) {
        if (this.setSelectedFlag) {
            return null;
        }
        if (input == null) {
            return null;
        }
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            String cur = this.getItemAt(i).toString();
            if (!cur.startsWith(input)) continue;
            return cur;
        }
        return null;
    }

    private void updateTextFieldTextForClearedSelection(JTextField comboBoxTextField, Object selectedItem) {
        String newText;
        if (selectedItem == null) {
            return;
        }
        String text = comboBoxTextField.getText();
        if (!text.equals(newText = selectedItem.toString())) {
            comboBoxTextField.setText(newText);
        }
    }

    private void init() {
        this.setHTMLRenderingEnabled(false);
        if (this.getRenderer() instanceof JComponent) {
            GComponent.setHTMLRenderingFlag((JComponent)((Object)this.getRenderer()), false);
        }
        this.documentListener = new MatchingItemsDocumentListener();
        this.addDocumentListener(this.documentListener);
    }

    private void installPassThroughListeners() {
        JTextField textField = this.getTextField();
        if (this.passThroughActionListener == null) {
            this.passThroughActionListener = new PassThroughActionListener();
            this.passThroughKeyListener = new PassThroughKeyListener();
            this.passThroughDocumentListener = new PassThroughDocumentListener();
        }
        textField.removeActionListener(this.passThroughActionListener);
        textField.removeKeyListener(this.passThroughKeyListener);
        textField.getDocument().removeDocumentListener(this.passThroughDocumentListener);
        textField.addActionListener(this.passThroughActionListener);
        textField.addKeyListener(this.passThroughKeyListener);
        textField.getDocument().addDocumentListener(this.passThroughDocumentListener);
    }

    public JTextField getTextField() {
        Component object = this.getEditor().getEditorComponent();
        if (object instanceof JTextField) {
            JTextField textField = (JTextField)object;
            return textField;
        }
        throw new AssertException("Expected GhidraComboBox editor component to be a JTextField!");
    }

    private class PassThroughDocumentListener
    implements DocumentListener {
        private PassThroughDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            for (DocumentListener listener : GhidraComboBox.this.docListeners) {
                listener.insertUpdate(e);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            for (DocumentListener listener : GhidraComboBox.this.docListeners) {
                listener.removeUpdate(e);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            for (DocumentListener listener : GhidraComboBox.this.docListeners) {
                listener.changedUpdate(e);
            }
        }
    }

    private class MatchingItemsDocumentListener
    implements DocumentListener {
        private MatchingItemsDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JTextField textField = GhidraComboBox.this.getTextField();
            String input = textField.getText();
            String match = GhidraComboBox.this.matchHistory(input);
            if (match != null && match.length() > input.length()) {
                Swing.runLater(() -> {
                    textField.setText(match);
                    textField.setSelectionStart(input.length());
                    textField.setSelectionEnd(match.length());
                });
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class PassThroughActionListener
    implements ActionListener {
        private PassThroughActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (ActionListener listener : GhidraComboBox.this.actionListeners) {
                listener.actionPerformed(e);
            }
        }
    }

    private class PassThroughKeyListener
    implements KeyListener {
        private PassThroughKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            for (KeyListener listener : GhidraComboBox.this.keyListeners) {
                listener.keyTyped(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            for (KeyListener listener : GhidraComboBox.this.keyListeners) {
                listener.keyPressed(e);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            for (KeyListener listener : GhidraComboBox.this.keyListeners) {
                listener.keyReleased(e);
            }
        }
    }
}

