/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.widgets.filechooser.DirectoryTable;
import docking.widgets.filechooser.DirectoryTableModel;
import docking.widgets.filechooser.GhidraFile;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.label.GDLabel;
import generic.theme.GThemeDefaults;
import ghidra.util.Msg;
import ghidra.util.filechooser.GhidraFileChooserModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

class FileEditor
extends AbstractCellEditor
implements TableCellEditor {
    private GhidraFileChooser chooser;
    private DirectoryTable directoryTable;
    private DirectoryTableModel model;
    private JPanel editor;
    private JLabel iconLabel;
    private JTextField nameField;
    private File originalFile;
    private File editedFile;

    FileEditor(final GhidraFileChooser chooser, DirectoryTable table, DirectoryTableModel model) {
        this.chooser = chooser;
        this.directoryTable = table;
        this.model = model;
        this.iconLabel = new GDLabel();
        this.iconLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FileEditor.this.handleDoubleClick(e.getPoint());
                }
            }
        });
        this.nameField = new JTextField();
        this.nameField.setName("TABLE_EDITOR_FIELD");
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                String invalidFilenameMessage;
                if (e.getKeyCode() == 27) {
                    FileEditor.this.directoryTable.editingCanceled(new ChangeEvent(FileEditor.this));
                    e.consume();
                } else if (e.getKeyCode() == 10 && (invalidFilenameMessage = chooser.getInvalidFilenameMessage(FileEditor.this.nameField.getText())) != null) {
                    chooser.setStatusText(invalidFilenameMessage);
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    FileEditor.this.directoryTable.editingCanceled(new ChangeEvent(FileEditor.this));
                    e.consume();
                } else if (e.getKeyCode() == 10) {
                    String invalidFilenameMessage = chooser.getInvalidFilenameMessage(FileEditor.this.nameField.getText());
                    if (invalidFilenameMessage != null) {
                        chooser.setStatusText(invalidFilenameMessage);
                    } else {
                        FileEditor.this.directoryTable.editingStopped(new ChangeEvent(FileEditor.this));
                    }
                    e.consume();
                }
            }
        });
        this.nameField.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.editor = new JPanel(new BorderLayout()){

            @Override
            public void requestFocus() {
                SwingUtilities.invokeLater(() -> FileEditor.this.nameField.requestFocus());
            }
        };
        this.editor.add((Component)this.iconLabel, "West");
        this.editor.add((Component)this.nameField, "Center");
        this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0), BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.BORDER)));
    }

    private void handleDoubleClick(Point p) {
        this.directoryTable.editingCanceled(null);
        int row = this.directoryTable.rowAtPoint(p);
        File file = this.model.getFile(row);
        this.chooser.setCurrentDirectory(file);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editedFile = null;
        this.originalFile = this.model.getFile(row);
        String name = this.originalFile.getName();
        Icon icon = this.chooser.getModel().getIcon(this.originalFile);
        this.iconLabel.setIcon(icon);
        this.nameField.setText(name);
        this.nameField.requestFocus();
        if (name.length() > 0) {
            this.nameField.setCaretPosition(name.length());
            this.nameField.selectAll();
        }
        this.nameField.repaint();
        this.editor.setVisible(true);
        return this.editor;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.originalFile == null) {
            return null;
        }
        if (this.editedFile != null) {
            return this.editedFile;
        }
        this.editedFile = this.getNewFile();
        return this.editedFile;
    }

    private File getNewFile() {
        GhidraFile newFile;
        String invalidFilenameMessage = this.chooser.getInvalidFilenameMessage(this.nameField.getText());
        if (invalidFilenameMessage != null) {
            this.chooser.setStatusText("Rename aborted - " + invalidFilenameMessage);
            return this.originalFile;
        }
        GhidraFileChooserModel fileChooserModel = this.chooser.getModel();
        if (fileChooserModel.renameFile(this.originalFile, (File)(newFile = new GhidraFile(this.originalFile.getParentFile(), this.nameField.getText(), fileChooserModel.getSeparator())))) {
            return newFile;
        }
        Msg.showError((Object)this, (Component)this.chooser.getComponent(), (String)"Rename Failed", (Object)("Unable to rename file: " + String.valueOf(this.originalFile)));
        return null;
    }
}

