/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tab;

import docking.widgets.tab.GTab;
import docking.widgets.tab.GTabPanelBorder;
import docking.widgets.tab.HiddenValuesButton;
import docking.widgets.tab.TabListPopup;
import ghidra.util.layout.HorizontalLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utility.function.Dummy;

public class GTabPanel<T>
extends JPanel {
    private T selectedValue;
    private T highlightedValue;
    private boolean ignoreFocusLost;
    private TabListPopup<T> tabList;
    private String tabTypeName;
    private Set<T> allValues = new LinkedHashSet<T>();
    private List<GTab<T>> allTabs = new ArrayList<GTab<T>>();
    private HiddenValuesButton hiddenValuesControl = new HiddenValuesButton(this);
    private Function<T, String> nameFunction = v -> v.toString();
    private Function<T, Icon> iconFunction = Dummy.function();
    private Function<T, String> toolTipFunction = Dummy.function();
    private Consumer<T> selectedTabConsumer = Dummy.consumer();
    private Consumer<T> closeTabConsumer = t -> this.removeTab(t);
    private boolean showTabsAlways = true;

    public GTabPanel(String tabTypeName) {
        this.tabTypeName = tabTypeName;
        this.setLayout((LayoutManager)new HorizontalLayout(0));
        this.setFocusable(true);
        this.getAccessibleContext().setAccessibleDescription("Use left and right arrows to highlight other tabs and press enter to select the highlighted tab");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                GTabPanel.this.closeTabList();
                GTabPanel.this.rebuildTabs();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 10: 
                    case 32: {
                        GTabPanel.this.selectHighlightedValue();
                        e.consume();
                        break;
                    }
                    case 37: {
                        GTabPanel.this.highlightNextPreviousTab(false);
                        e.consume();
                        break;
                    }
                    case 39: {
                        GTabPanel.this.highlightNextPreviousTab(true);
                        e.consume();
                    }
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                GTabPanel.this.updateTabColors();
            }

            @Override
            public void focusLost(FocusEvent e) {
                GTabPanel.this.highlightedValue = null;
                GTabPanel.this.updateAccessibleName();
                GTabPanel.this.updateTabColors();
            }
        });
    }

    public void addTab(T value) {
        this.doAddValue(value);
        this.rebuildTabs();
    }

    public void addTabs(List<T> values) {
        for (T t : values) {
            this.doAddValue(t);
        }
        this.rebuildTabs();
    }

    public void removeTab(T value) {
        this.allValues.remove(value);
        this.highlightedValue = null;
        if (value == this.selectedValue) {
            this.selectTab(null);
        } else {
            this.rebuildTabs();
        }
    }

    public void removeTabs(Collection<T> values) {
        this.allValues.removeAll(values);
        if (!this.allValues.contains(this.selectedValue)) {
            this.selectTab(null);
        } else {
            this.rebuildTabs();
        }
    }

    public T getSelectedTabValue() {
        return this.selectedValue;
    }

    public T getHighlightedTabValue() {
        return this.highlightedValue;
    }

    public void selectTab(T value) {
        if (value != null && !this.allValues.contains(value)) {
            throw new IllegalArgumentException("Attempted to set selected value to non added value");
        }
        this.closeTabList();
        this.highlightedValue = null;
        this.selectedValue = value;
        this.rebuildTabs();
        this.selectedTabConsumer.accept(value);
    }

    public List<T> getTabValues() {
        return new ArrayList<T>(this.allValues);
    }

    public boolean isVisibleTab(T value) {
        for (GTab<T> gTab : this.allTabs) {
            if (!gTab.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    public int getTabCount() {
        return this.allValues.size();
    }

    public void highlightTab(T value) {
        this.highlightedValue = value == this.selectedValue ? null : value;
        this.updateTabColors();
        this.updateAccessibleName();
    }

    public boolean hasHiddenTabs() {
        return this.allTabs.size() < this.allValues.size();
    }

    public List<T> getHiddenTabs() {
        LinkedHashSet<T> hiddenValues = new LinkedHashSet<T>(this.allValues);
        hiddenValues.removeAll(this.getVisibleTabs());
        return new ArrayList<T>(hiddenValues);
    }

    public List<T> getVisibleTabs() {
        return this.allTabs.stream().map(t -> t.getValue()).collect(Collectors.toList());
    }

    public void showTabList(boolean show) {
        if (show) {
            this.showTabList();
        } else {
            this.closeTabList();
        }
    }

    public void highlightNextPreviousTab(boolean forward) {
        T current;
        if (this.allValues.size() < 2) {
            return;
        }
        T t = current = this.highlightedValue == null ? this.selectedValue : this.highlightedValue;
        if (this.isShowingTabList()) {
            current = null;
            this.closeTabList();
        }
        T next = forward ? this.getTabbedValueAfter(current) : this.getTabbedValueBefore(current);
        this.highlightTab(next);
        if (next == null) {
            this.showTabList(true);
        }
    }

    public void refreshTab(T value) {
        int tabIndex = this.getTabIndex(value);
        if (tabIndex >= 0) {
            this.allTabs.get(tabIndex).refresh();
        }
    }

    public void setNameFunction(Function<T, String> nameFunction) {
        this.nameFunction = nameFunction;
    }

    public void setIconFunction(Function<T, Icon> iconFunction) {
        this.iconFunction = iconFunction;
    }

    public void setToolTipFunction(Function<T, String> toolTipFunction) {
        this.toolTipFunction = toolTipFunction;
    }

    public void setCloseTabConsumer(Consumer<T> closeTabConsumer) {
        this.closeTabConsumer = closeTabConsumer;
    }

    public void setSelectedTabConsumer(Consumer<T> selectedTabConsumer) {
        this.selectedTabConsumer = selectedTabConsumer;
    }

    public boolean isShowingTabList() {
        return this.tabList != null;
    }

    public void setShowTabsAlways(boolean b) {
        this.showTabsAlways = b;
        this.rebuildTabs();
    }

    public T getValueFor(MouseEvent event) {
        JLabel label;
        Container parent;
        Object source = event.getSource();
        if (source instanceof JLabel && (parent = (label = (JLabel)source).getParent()) instanceof GTab) {
            GTab gTab = (GTab)parent;
            return gTab.getValue();
        }
        return null;
    }

    void showTabList() {
        if (this.tabList != null) {
            return;
        }
        HiddenValuesButton c = this.hasHiddenTabs() ? this.hiddenValuesControl : (JComponent)this.allTabs.get(this.allTabs.size() - 1);
        this.tabList = new TabListPopup(this, c, this.tabTypeName);
        this.tabList.setVisible(true);
    }

    void closeTab(T value) {
        this.closeTabConsumer.accept(value);
    }

    private void selectHighlightedValue() {
        if (this.highlightedValue != null) {
            this.selectTab(this.highlightedValue);
        }
    }

    void highlightFromTabList(boolean forward) {
        this.closeTabList();
        int highlightIndex = forward ? 0 : this.allTabs.size() - 1;
        this.highlightTab(this.allTabs.get(highlightIndex).getValue());
        this.requestFocus();
    }

    private T getTabbedValueAfter(T current) {
        if (current == null) {
            return this.allTabs.get(0).getValue();
        }
        int tabIndex = this.getTabIndex(current);
        if (tabIndex >= 0 && tabIndex < this.allTabs.size() - 1) {
            return this.allTabs.get(tabIndex + 1).getValue();
        }
        if (this.hasHiddenTabs()) {
            return null;
        }
        return this.allTabs.get(0).getValue();
    }

    private T getTabbedValueBefore(T current) {
        if (current == null) {
            return this.allTabs.get(this.allTabs.size() - 1).getValue();
        }
        int tabIndex = this.getTabIndex(current);
        if (tabIndex >= 1) {
            return this.allTabs.get(tabIndex - 1).getValue();
        }
        if (this.hasHiddenTabs()) {
            return null;
        }
        return this.allTabs.get(this.allTabs.size() - 1).getValue();
    }

    private int getTabIndex(T value) {
        for (int i = 0; i < this.allTabs.size(); ++i) {
            if (!this.allTabs.get(i).getValue().equals(value)) continue;
            return i;
        }
        return -1;
    }

    private void updateTabColors() {
        boolean tabPanelHasFocus = this.hasFocus();
        for (GTab<T> tab : this.allTabs) {
            T value = tab.getValue();
            tab.setHighlight(this.shouldHighlight(value, tabPanelHasFocus));
        }
    }

    private boolean shouldHighlight(T value, boolean tabPanelHasFocus) {
        if (value.equals(this.highlightedValue)) {
            return true;
        }
        if (tabPanelHasFocus && this.highlightedValue == null) {
            return value.equals(this.selectedValue);
        }
        return false;
    }

    private void doAddValue(T value) {
        Objects.requireNonNull(value);
        this.allValues.add(value);
    }

    private void rebuildTabs() {
        this.allTabs.clear();
        this.removeAll();
        this.closeTabList();
        this.setBorder(null);
        if (!this.shouldShowTabs()) {
            this.setFocusable(false);
            this.revalidate();
            this.repaint();
            return;
        }
        this.setFocusable(true);
        this.setBorder(new GTabPanelBorder());
        GTab<T> selectedTab = null;
        int availableWidth = this.getPanelWidth();
        if (this.selectedValue != null) {
            selectedTab = new GTab<T>(this, this.selectedValue, true);
            availableWidth -= this.getTabWidth(selectedTab);
        }
        this.createNonSelectedTabsForWidth(availableWidth);
        if (this.selectedValue != null && availableWidth >= 0) {
            this.allTabs.add(this.getIndexToInsertSelectedValue(this.allTabs.size()), selectedTab);
        }
        for (GTab<T> gTab : this.allTabs) {
            this.add(gTab);
        }
        if (this.hasHiddenTabs()) {
            this.hiddenValuesControl.setHiddenCount(this.allValues.size() - this.allTabs.size());
            this.add(this.hiddenValuesControl);
        }
        this.updateTabColors();
        this.updateAccessibleName();
        this.revalidate();
        this.repaint();
    }

    private boolean shouldShowTabs() {
        if (this.allValues.isEmpty()) {
            return false;
        }
        return this.allValues.size() != 1 || this.showTabsAlways;
    }

    private void updateAccessibleName() {
        this.getAccessibleContext().setAccessibleName(this.getAccessibleName());
    }

    String getAccessibleName() {
        StringBuilder builder = new StringBuilder(this.tabTypeName);
        builder.append(" Tab Panel: ");
        if (this.allValues.isEmpty()) {
            builder.append("No Tabs");
            return builder.toString();
        }
        if (this.selectedValue != null) {
            builder.append(this.getDisplayName(this.selectedValue));
            builder.append(" selected");
        } else {
            builder.append("No Selected Tab");
        }
        if (this.highlightedValue != null) {
            builder.append(": ");
            builder.append(this.getDisplayName(this.highlightedValue));
            builder.append(" highlighted");
        }
        return builder.toString();
    }

    private int getIndexToInsertSelectedValue(int maxIndex) {
        Iterator<T> it = this.allValues.iterator();
        for (int i = 0; i < maxIndex; ++i) {
            T t = it.next();
            if (t != this.selectedValue) continue;
            return i;
        }
        return maxIndex;
    }

    private void createNonSelectedTabsForWidth(int availableWidth) {
        for (T value : this.allValues) {
            if (value == this.selectedValue) continue;
            GTab<T> tab = new GTab<T>(this, value, false);
            int tabWidth = this.getTabWidth(tab);
            if (tabWidth > availableWidth) break;
            this.allTabs.add(tab);
            availableWidth -= tabWidth;
        }
        if (this.hasHiddenTabs() && availableWidth < this.hiddenValuesControl.getPreferredWidth() && !this.allTabs.isEmpty()) {
            this.allTabs.remove(this.allTabs.size() - 1);
        }
    }

    private int getTabWidth(GTab<T> tab) {
        return tab.getPreferredSize().width;
    }

    private int getPanelWidth() {
        return this.getSize().width;
    }

    boolean isListWindowShowing() {
        return this.tabList != null;
    }

    String getDisplayName(T t) {
        return this.nameFunction.apply(t);
    }

    Icon getValueIcon(T value) {
        return this.iconFunction.apply(value);
    }

    String getValueToolTip(T value) {
        return this.toolTipFunction.apply(value);
    }

    void tabListFocusLost() {
        if (!this.ignoreFocusLost) {
            this.closeTabList();
        }
    }

    void closeTabList() {
        if (this.tabList != null) {
            this.tabList.close();
            this.tabList = null;
        }
    }

    public void setIgnoreFocus(boolean ignoreFocusLost) {
        this.ignoreFocusLost = ignoreFocusLost;
    }

    public JPanel getTab(T value) {
        for (GTab<T> tab : this.allTabs) {
            if (!tab.getValue().equals(value)) continue;
            return tab;
        }
        return null;
    }
}

