/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tab;

import docking.widgets.label.GDLabel;
import docking.widgets.tab.GTabPanel;
import generic.theme.GColor;
import generic.theme.GIcon;
import generic.theme.Gui;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.border.Border;

public class HiddenValuesButton
extends GDLabel {
    private static final String FONT_TABS_LIST_ID = "font.widget.tabs.list";
    private static final Icon LIST_ICON = new GIcon("icon.widget.tabs.list");
    private static final Color BG_COLOR_MORE_TABS_HOVER = new GColor("color.bg.widget.tabs.more.tabs.hover");
    private static final String DEFAULT_HIDDEN_COUNT_STR = "99";
    private Border defaultListLabelBorder;

    HiddenValuesButton(final GTabPanel<?> tabPanel) {
        super(DEFAULT_HIDDEN_COUNT_STR, LIST_ICON, 2);
        this.setName("Hidden Values Control");
        this.setIconTextGap(2);
        Gui.registerFont((Component)this, (String)FONT_TABS_LIST_ID);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 4));
        this.setToolTipText("Show Tab List");
        this.getAccessibleContext().setAccessibleName("Show Hidden Values List");
        this.setBackground(BG_COLOR_MORE_TABS_HOVER);
        this.defaultListLabelBorder = this.getBorder();
        final Border hoverBorder = BorderFactory.createBevelBorder(0);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (tabPanel.isListWindowShowing()) {
                    tabPanel.closeTabList();
                    return;
                }
                tabPanel.showTabList(true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (tabPanel.isListWindowShowing()) {
                    return;
                }
                HiddenValuesButton.this.setBorder(hoverBorder);
                HiddenValuesButton.this.setOpaque(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                HiddenValuesButton.this.setBorder(HiddenValuesButton.this.defaultListLabelBorder);
                HiddenValuesButton.this.setOpaque(false);
            }
        });
        this.setPreferredSize(this.getPreferredSize());
    }

    void setHiddenCount(int count) {
        this.setText(Integer.toString(count));
    }

    int getPreferredWidth() {
        return this.getPreferredSize().width;
    }
}

