/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.constraint.dialog;

import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnData;
import docking.widgets.table.constraint.dialog.ColumnFilterData;
import docking.widgets.table.constraint.dialog.DialogFilterConditionSet;
import docking.widgets.table.constrainteditor.ColumnConstraintEditor;
import docking.widgets.table.constrainteditor.DummyConstraintEditor;
import ghidra.util.Msg;
import java.awt.Component;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;

public class DialogFilterCondition<T> {
    private String constraintName;
    private ColumnConstraintEditor<T> editor;
    private DialogFilterConditionSet<T> parent;
    private ChangeListener changeListener = e -> this.editorChanged();

    public DialogFilterCondition(DialogFilterConditionSet<T> parentCondition) {
        this(parentCondition, null);
    }

    public DialogFilterCondition(DialogFilterConditionSet<T> parent, ColumnConstraint<T> constraint) {
        this.parent = parent;
        if (constraint == null) {
            constraint = parent.getColumnFilterData().getFirstConstraint();
        }
        this.constraintName = constraint.getName();
        this.editor = this.createEditor(constraint);
    }

    public ColumnConstraint<?>[] getColumnConstraints() {
        return this.parent.getColumnFilterData().getConstraints();
    }

    public String getSelectedConstraintName() {
        return this.constraintName;
    }

    public ColumnConstraint<T> getSelectedConstraint() {
        return this.parent.getColumnFilterData().getConstraint(this.constraintName);
    }

    public void setSelectedConstraint(String constraintName) {
        ColumnFilterData<T> columnData = this.parent.getColumnFilterData();
        this.setConstraint(columnData.getConstraint(constraintName));
    }

    public ColumnConstraint<T> getConstraint() {
        return this.editor.getValue();
    }

    public boolean hasValidFilterValue() {
        return this.editor.hasValidValue();
    }

    public Component getInlineEditorComponent() {
        return this.editor.getInlineComponent();
    }

    public Component getDetailEditorComponent() {
        return this.editor.getDetailComponent();
    }

    public void delete() {
        this.parent.delete(this);
    }

    public void setValue(String valueString, Object dataSource) {
        ColumnConstraint<T> constraint = this.editor.getValue();
        ColumnConstraint<T> value = constraint.parseConstraintValue(valueString, dataSource);
        this.setConstraint(value);
    }

    public String toString() {
        return "{\n\tname: " + this.constraintName + ",\n\tparent: " + String.valueOf(this.parent) + "\n}";
    }

    private ColumnConstraintEditor<T> buildDummyEditor() {
        Msg.error((Object)this, (Object)("No editor for constraint '" + this.constraintName + "' -- building dummy"));
        Object message = StringUtils.isBlank((CharSequence)this.constraintName) ? "Constraint provides no editor" : "Constraint '" + this.constraintName + "' provides no editor";
        return new DummyConstraintEditor((String)message);
    }

    private void setConstraint(ColumnConstraint<T> constraint) {
        String currentConstraintName = this.constraintName;
        this.constraintName = constraint.getName();
        if (this.editor != null) {
            this.updateColumnData(currentConstraintName, this.editor.getValue());
        }
        this.editor = this.createEditor(constraint);
        this.parent.conditionChanged(this);
    }

    private void updateColumnData(String currentConstraintName, ColumnConstraint<T> value) {
        ColumnFilterData<T> columnFilterData = this.parent.getColumnFilterData();
        columnFilterData.replace(value);
    }

    private ColumnConstraintEditor<T> createEditor(ColumnConstraint<T> constraint) {
        ColumnData<T> columnDataSource = this.parent.getColumnData();
        ColumnConstraintEditor<T> constraintEditor = constraint.getEditor(columnDataSource);
        if (constraintEditor == null) {
            constraintEditor = this.buildDummyEditor();
        }
        constraintEditor.addChangeListener(this.changeListener);
        return constraintEditor;
    }

    private void editorChanged() {
        this.parent.editorValueChanged(this.editor);
    }
}

