/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.table.AddRemoveListItem;
import docking.widgets.table.CoalescingAddRemoveStrategy;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.RowObjectFilterModel;
import docking.widgets.table.TableFilter;
import docking.widgets.table.TableSortingContext;
import docking.widgets.table.sort.DefaultColumnComparator;
import docking.widgets.table.threaded.IncrementalJobListener;
import docking.widgets.table.threaded.IncrementalLoadJob;
import docking.widgets.table.threaded.NullTableFilter;
import docking.widgets.table.threaded.TableAddRemoveStrategy;
import docking.widgets.table.threaded.TableData;
import docking.widgets.table.threaded.ThreadedBackupRowComparator;
import docking.widgets.table.threaded.ThreadedTableColumnComparator;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import docking.widgets.table.threaded.ThreadedTableModelUpdateMgr;
import generic.concurrent.ConcurrentListenerSet;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.LRUMap;
import ghidra.util.datastruct.ListAccumulator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.ClosedException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Worker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.event.TableModelEvent;

public abstract class ThreadedTableModel<ROW_OBJECT, DATA_SOURCE>
extends GDynamicColumnTableModel<ROW_OBJECT, DATA_SOURCE>
implements RowObjectFilterModel<ROW_OBJECT> {
    private ThreadedTableModelUpdateMgr<ROW_OBJECT> updateManager;
    private boolean loadIncrementally;
    private TaskMonitor incrementalMonitor = TaskMonitor.DUMMY;
    private ConcurrentListenerSet<ThreadedTableModelListener> listeners = new ConcurrentListenerSet();
    private String modelName;
    protected TableData<ROW_OBJECT> allData = TableData.createEmptyDataset();
    protected TableData<ROW_OBJECT> filteredData = TableData.createSubDataset(this.allData, new ArrayList(), null);
    private volatile TableSortingContext<ROW_OBJECT> pendingSortContext;
    private volatile TableFilter<ROW_OBJECT> pendingTableFilter;
    private TableFilter<ROW_OBJECT> tableFilter = new NullTableFilter();
    private ThreadLocal<Map<ROW_OBJECT, Map<Integer, Object>>> threadLocalColumnCache = new ThreadLocal();
    private volatile Worker worker;
    private int minUpdateDelayMillis;
    private int maxUpdateDelayMillis;
    private TableAddRemoveStrategy<ROW_OBJECT> binarySearchAddRemoveStrategy = new CoalescingAddRemoveStrategy<ROW_OBJECT>();

    protected ThreadedTableModel(String modelName, ServiceProvider serviceProvider) {
        this(modelName, serviceProvider, null);
    }

    protected ThreadedTableModel(String modelName, ServiceProvider serviceProvider, TaskMonitor monitor) {
        this(modelName, serviceProvider, monitor, false);
    }

    protected ThreadedTableModel(String modelName, ServiceProvider serviceProvider, TaskMonitor monitor, boolean loadIncrementally) {
        super(serviceProvider);
        if (!Swing.isSwingThread()) {
            throw new AssertException("You must create the ThreadedTableModel in the AWT Event Dispatch Thread");
        }
        this.modelName = modelName;
        this.loadIncrementally = loadIncrementally;
        this.updateManager = new ThreadedTableModelUpdateMgr(this, monitor);
        if (loadIncrementally) {
            this.updateManager.addThreadedTableListener(new IncrementalUpdateManagerListener());
        } else {
            this.updateManager.addThreadedTableListener(new NonIncrementalUpdateManagerListener());
        }
        this.startInitialLoad();
    }

    protected void startInitialLoad() {
        Swing.runLater(() -> this.updateManager.reload());
    }

    public boolean isLoadIncrementally() {
        return this.loadIncrementally;
    }

    @Override
    protected void initializeSorting() {
    }

    final List<ROW_OBJECT> load(TaskMonitor monitor) throws CancelledException {
        if (this.loadIncrementally) {
            this.initializeWorker();
            this.scheduleIncrementalLoad();
            return Collections.emptyList();
        }
        ListAccumulator<ROW_OBJECT> accumulator = this.createAccumulator();
        this.doLoad((Accumulator<ROW_OBJECT>)accumulator, monitor);
        return accumulator.asList();
    }

    protected ListAccumulator<ROW_OBJECT> createAccumulator() {
        return new ListAccumulator();
    }

    private void initializeWorker() {
        if (this.worker == null) {
            this.worker = new Worker("GTable Worker: " + this.getName(), this.incrementalMonitor);
        }
        this.cancelCurrentWorkerJob();
        this.worker.waitUntilNoJobsScheduled(Integer.MAX_VALUE);
    }

    private void cancelCurrentWorkerJob() {
        if (this.worker != null && this.worker.isBusy()) {
            this.worker.clearAllJobsWithInterrupt_IKnowTheRisks();
        }
    }

    private void scheduleIncrementalLoad() {
        this.worker.schedule(this.createIncrementalLoadJob());
    }

    protected IncrementalLoadJob<ROW_OBJECT> createIncrementalLoadJob() {
        return new IncrementalLoadJob(this, new IncrementalLoadJobListener());
    }

    protected abstract void doLoad(Accumulator<ROW_OBJECT> var1, TaskMonitor var2) throws CancelledException;

    Object getCachedColumnValueForRow(ROW_OBJECT rowObject, int columnIndex) {
        Object columnValueForRow;
        Map<ROW_OBJECT, Map<Integer, Object>> cachedColumnValues = this.threadLocalColumnCache.get();
        if (cachedColumnValues == null) {
            return this.getColumnValueForRow(rowObject, columnIndex);
        }
        Map<Integer, Object> columnMap = cachedColumnValues.get(rowObject);
        if (columnMap == null) {
            columnMap = new HashMap<Integer, Object>();
            cachedColumnValues.put(rowObject, columnMap);
        }
        if ((columnValueForRow = columnMap.get(columnIndex)) == null) {
            columnValueForRow = this.getColumnValueForRow(rowObject, columnIndex);
            columnMap.put(columnIndex, columnValueForRow);
        }
        return columnValueForRow;
    }

    void initializeCache() {
        this.threadLocalColumnCache.set((Map<ROW_OBJECT, Map<Integer, Object>>)new LRUMap(1000000));
    }

    void clearCache() {
        Map<ROW_OBJECT, Map<Integer, Object>> cachedColumnValues = this.threadLocalColumnCache.get();
        if (cachedColumnValues != null) {
            cachedColumnValues.clear();
            this.threadLocalColumnCache.set(null);
        }
    }

    @Override
    public List<ROW_OBJECT> getModelData() {
        return Collections.unmodifiableList(this.filteredData.getData());
    }

    @Override
    public List<ROW_OBJECT> getUnfilteredData() {
        return Collections.unmodifiableList(this.allData.getData());
    }

    protected int getUnfilteredIndexForRowObject(ROW_OBJECT rowObject) {
        return this.getIndexForRowObject(rowObject, this.getUnfilteredData());
    }

    protected ROW_OBJECT getUnfilteredRowObjectForIndex(int row) {
        List<ROW_OBJECT> unfilteredData = this.getUnfilteredData();
        if (row < 0 || row >= unfilteredData.size()) {
            return null;
        }
        return unfilteredData.get(row);
    }

    @Override
    protected Comparator<ROW_OBJECT> createSortComparator(int columnIndex) {
        Comparator<Object> columnComparator = this.createSortComparatorForColumn(columnIndex);
        if (columnComparator != null) {
            return new ThreadedTableColumnComparator(this, columnIndex, columnComparator);
        }
        return new ThreadedTableColumnComparator(this, columnIndex, (Comparator<Object>)new DefaultColumnComparator(), (Comparator<Object>)new ThreadedBackupRowComparator(this, columnIndex));
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return super.getValueAt(rowIndex, columnIndex);
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof ClosedException)) {
                throw e;
            }
            return null;
        }
    }

    @Override
    protected void sort(List<ROW_OBJECT> data, TableSortingContext<ROW_OBJECT> tableSortingContext) {
        if (data.isEmpty() && !this.updateManager.isBusy()) {
            this.sortCompleted(tableSortingContext);
            this.updateManager.reload();
            return;
        }
        this.pendingSortContext = tableSortingContext;
        this.updateManager.sort(tableSortingContext, false);
    }

    TableSortingContext<ROW_OBJECT> getSortingContext() {
        if (this.pendingSortContext != null) {
            return this.pendingSortContext;
        }
        return this.createSortingContext(this.getTableSortState());
    }

    @Override
    public TableFilter<ROW_OBJECT> getTableFilter() {
        if (this.pendingTableFilter != null) {
            return this.pendingTableFilter;
        }
        return this.tableFilter;
    }

    public boolean hasFilter() {
        TableFilter<ROW_OBJECT> currentFilter = this.getTableFilter();
        return !currentFilter.isEmpty();
    }

    protected List<ROW_OBJECT> doFilter(List<ROW_OBJECT> data, TableSortingContext<ROW_OBJECT> lastSortingContext, TaskMonitor monitor) throws CancelledException {
        if (data.size() == 0) {
            return data;
        }
        if (!this.hasFilter()) {
            return data;
        }
        monitor.initialize((long)data.size());
        TableFilter<ROW_OBJECT> filterCopy = this.getTableFilter();
        ArrayList<ROW_OBJECT> filteredList = new ArrayList<ROW_OBJECT>();
        for (int row = 0; row < data.size(); ++row) {
            if (monitor.isCancelled()) {
                return filteredList;
            }
            ROW_OBJECT rowObject = data.get(row);
            if (filterCopy.acceptsRow(rowObject)) {
                filteredList.add(rowObject);
            }
            monitor.incrementProgress(1L);
        }
        return filteredList;
    }

    @Override
    public int getUnfilteredRowCount() {
        return this.allData.size();
    }

    @Override
    public boolean isFiltered() {
        return this.filteredData.size() != this.allData.size();
    }

    @Override
    public void setTableFilter(TableFilter<ROW_OBJECT> tableFilter) {
        this.pendingTableFilter = tableFilter;
        if (this.pendingTableFilter == null) {
            this.pendingTableFilter = new NullTableFilter();
        }
        this.reFilter();
    }

    private void setAppliedTableFilter(TableFilter<ROW_OBJECT> tableFilter) {
        if (tableFilter == null) {
            return;
        }
        this.tableFilter = this.pendingTableFilter;
        this.pendingTableFilter = null;
    }

    public void updateObject(ROW_OBJECT obj) {
        this.updateManager.addRemove(new AddRemoveListItem<ROW_OBJECT>(AddRemoveListItem.Type.CHANGE, obj));
    }

    public void addObject(ROW_OBJECT obj) {
        this.updateManager.addRemove(new AddRemoveListItem<ROW_OBJECT>(AddRemoveListItem.Type.ADD, obj));
    }

    public void removeObject(ROW_OBJECT obj) {
        this.updateManager.addRemove(new AddRemoveListItem<ROW_OBJECT>(AddRemoveListItem.Type.REMOVE, obj));
    }

    protected void updateNow() {
        this.updateManager.updateNow();
    }

    protected void backgroundWorkCancelled() {
        this.pendingSortContext = null;
        this.sortCompleted(null);
        this.notifyModelSorted(false);
    }

    protected void setModelState(TableData<ROW_OBJECT> allData, TableData<ROW_OBJECT> filteredData) {
        SystemUtilities.assertThisIsTheSwingThread((String)"Must be called on the Swing thread");
        boolean dataChanged = this.filteredData.getId() != filteredData.getId() || this.filteredData.size() != filteredData.size();
        this.allData = allData;
        this.filteredData = filteredData;
        this.setAppliedTableFilter(this.pendingTableFilter);
        this.pendingSortContext = null;
        TableSortingContext<ROW_OBJECT> newSortingContext = filteredData.getSortContext();
        if (newSortingContext != null) {
            this.sortCompleted(newSortingContext);
        }
        this.notifyModelSorted(dataChanged);
    }

    TableData<ROW_OBJECT> getAllTableData() {
        return this.allData;
    }

    TableData<ROW_OBJECT> getCurrentTableData() {
        return this.filteredData;
    }

    protected List<ROW_OBJECT> getAllData() {
        return new ArrayList<ROW_OBJECT>(this.allData.getData());
    }

    public boolean isBusy() {
        return this.updateManager.isBusy() || this.isWorkerBusy();
    }

    boolean isLoading() {
        if (this.loadIncrementally) {
            return this.isWorkerBusy();
        }
        return this.updateManager.isBusy();
    }

    private boolean isWorkerBusy() {
        return this.worker != null && this.worker.isBusy();
    }

    @Override
    public void reSort() {
        this.updateManager.sort(this.getSortingContext(), true);
    }

    public void reFilter() {
        this.updateManager.filter();
    }

    public void reload() {
        this.cancelCurrentWorkerJob();
        this.updateManager.reload();
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        if (Swing.isSwingThread()) {
            super.fireTableChanged(e);
            return;
        }
        Swing.runLater(() -> ThreadedTableModel.super.fireTableChanged(e));
    }

    @Override
    public void dispose() {
        Swing.runNow(() -> {
            this.notifyFinished(true);
            this.listeners.clear();
        });
        this.updateManager.dispose();
        if (this.worker != null) {
            this.worker.dispose();
        }
        this.doClearData();
        this.disposeDynamicColumnData();
        this.clearCache();
        this.isDisposed = true;
    }

    protected void clearData() {
        this.doClearData();
        this.fireTableDataChanged();
    }

    private void doClearData() {
        this.cancelAllUpdates();
        this.getLastSelectedObjects().clear();
        this.allData.clear();
        this.filteredData.clear();
        this.filteredData = this.allData;
    }

    public void cancelAllUpdates() {
        if (this.worker != null) {
            this.worker.clearAllJobsWithInterrupt_IKnowTheRisks();
        }
        this.updateManager.cancelAllJobs();
    }

    @Override
    public int getRowCount() {
        return this.filteredData.size();
    }

    @Override
    public int getViewRow(int modelRow) {
        int unfilteredCount = this.getUnfilteredRowCount();
        if (this.getRowCount() == unfilteredCount) {
            return modelRow;
        }
        if (modelRow >= unfilteredCount) {
            return -1;
        }
        ROW_OBJECT modelValue = this.allData.get(modelRow);
        return this.filteredData.indexOf(modelValue);
    }

    @Override
    public int getModelRow(int viewRow) {
        if (this.getRowCount() == this.getUnfilteredRowCount()) {
            return viewRow;
        }
        if (viewRow >= this.filteredData.size()) {
            return -1;
        }
        ROW_OBJECT viewValue = this.filteredData.get(viewRow);
        return this.allData.indexOf(viewValue);
    }

    @Override
    public int getViewIndex(ROW_OBJECT t) {
        int index = this.filteredData.indexOf(t);
        return index;
    }

    @Override
    public int getModelIndex(ROW_OBJECT t) {
        int index = this.allData.indexOf(t);
        return index;
    }

    @Override
    public String getName() {
        return this.modelName;
    }

    public List<ROW_OBJECT> getRowObjects(int[] rows) {
        ArrayList<ROW_OBJECT> list = new ArrayList<ROW_OBJECT>(rows.length);
        for (int row : rows) {
            list.add(this.filteredData.get(row));
        }
        return list;
    }

    void setUpdateDelay(int updateDelayMillis, int maxUpdateDelayMillis) {
        this.minUpdateDelayMillis = updateDelayMillis;
        this.maxUpdateDelayMillis = maxUpdateDelayMillis;
        this.updateManager.setUpdateDelay(updateDelayMillis, maxUpdateDelayMillis);
    }

    long getMinDelay() {
        return this.minUpdateDelayMillis;
    }

    long getMaxDelay() {
        return this.maxUpdateDelayMillis;
    }

    ThreadedTableModelUpdateMgr<ROW_OBJECT> getUpdateManager() {
        return this.updateManager;
    }

    void setDefaultTaskMonitor(TaskMonitor monitor) {
        this.updateManager.setTaskMonitor(monitor);
    }

    protected TableAddRemoveStrategy<ROW_OBJECT> getAddRemoveStrategy() {
        return this.binarySearchAddRemoveStrategy;
    }

    public void setIncrementalTaskMonitor(TaskMonitor monitor) {
        SystemUtilities.assertTrue((boolean)this.loadIncrementally, (String)"Cannot set an incremental task monitor on a table that was not constructed to load incrementally");
        this.incrementalMonitor = monitor;
        if (this.worker != null) {
            this.worker.setTaskMonitor(monitor);
        }
    }

    public void addInitialLoadListener(ThreadedTableModelListener listener) {
        this.listeners.add((Object)new OneTimeListenerWrapper(listener));
    }

    public void addInitialLoadListener(Consumer<Boolean> completedLoadingConsumer) {
        this.listeners.add((Object)new OneTimeCompletedLoadingAdapter(completedLoadingConsumer));
    }

    public void addThreadedTableModelListener(ThreadedTableModelListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeThreadedTableModelListener(ThreadedTableModelListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyFinished(boolean wasCancelled) {
        this.pendingSortContext = null;
        for (ThreadedTableModelListener listener : this.listeners) {
            listener.loadingFinished(wasCancelled);
        }
    }

    private void notifyStarted() {
        for (ThreadedTableModelListener listener : this.listeners) {
            listener.loadingStarted();
        }
    }

    private void notifyPending() {
        for (ThreadedTableModelListener listener : this.listeners) {
            listener.loadPending();
        }
    }

    private class IncrementalUpdateManagerListener
    implements ThreadedTableModelListener {
        private IncrementalUpdateManagerListener() {
        }

        @Override
        public void loadPending() {
        }

        @Override
        public void loadingStarted() {
            if (ThreadedTableModel.this.isWorkerBusy()) {
                return;
            }
            ThreadedTableModel.this.notifyStarted();
        }

        @Override
        public void loadingFinished(boolean wasCancelled) {
            if (ThreadedTableModel.this.isWorkerBusy()) {
                return;
            }
            ThreadedTableModel.this.notifyFinished(wasCancelled);
        }
    }

    private class NonIncrementalUpdateManagerListener
    implements ThreadedTableModelListener {
        private NonIncrementalUpdateManagerListener() {
        }

        @Override
        public void loadPending() {
            ThreadedTableModel.this.notifyPending();
        }

        @Override
        public void loadingStarted() {
            ThreadedTableModel.this.notifyStarted();
        }

        @Override
        public void loadingFinished(boolean wasCancelled) {
            ThreadedTableModel.this.notifyFinished(wasCancelled);
        }
    }

    protected class IncrementalLoadJobListener
    extends IncrementalJobListener {
        protected IncrementalLoadJobListener() {
        }

        @Override
        void loadingStarted() {
            ThreadedTableModel.this.notifyStarted();
        }

        @Override
        void loadingFinished(boolean wasCancelled) {
            ThreadedTableModel.this.notifyFinished(wasCancelled);
        }
    }

    private class OneTimeListenerWrapper
    implements ThreadedTableModelListener {
        private final ThreadedTableModelListener delegate;

        OneTimeListenerWrapper(ThreadedTableModelListener wrapper) {
            this.delegate = wrapper;
        }

        @Override
        public void loadPending() {
            this.delegate.loadPending();
        }

        @Override
        public void loadingStarted() {
            this.delegate.loadingStarted();
        }

        @Override
        public void loadingFinished(boolean wasCancelled) {
            ThreadedTableModel.this.removeThreadedTableModelListener(this);
            this.delegate.loadingFinished(wasCancelled);
        }
    }

    private class OneTimeCompletedLoadingAdapter
    implements ThreadedTableModelListener {
        private Consumer<Boolean> completedLoadingConsumer;

        OneTimeCompletedLoadingAdapter(Consumer<Boolean> completedLoadingConsumer) {
            this.completedLoadingConsumer = completedLoadingConsumer;
        }

        @Override
        public void loadPending() {
        }

        @Override
        public void loadingStarted() {
        }

        @Override
        public void loadingFinished(boolean wasCancelled) {
            ThreadedTableModel.this.removeThreadedTableModelListener(this);
            this.completedLoadingConsumer.accept(wasCancelled);
        }
    }
}

