/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.DockingWindowManager;
import docking.widgets.EmptyBorderButton;
import docking.widgets.filter.FilterListener;
import docking.widgets.filter.FilterOptions;
import docking.widgets.filter.FilterOptionsEditorDialog;
import docking.widgets.filter.FilterTextField;
import docking.widgets.label.GLabel;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeFilterFactory;
import docking.widgets.tree.GTreeFilterProvider;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.internal.DefaultGTreeDataTransformer;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.framework.options.PreferenceState;
import ghidra.util.FilterTransformer;
import ghidra.util.HelpLocation;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;

public class DefaultGTreeFilterProvider
implements GTreeFilterProvider {
    private static final String FILTER_STATE = "FILTER_STATE";
    private FilterTextField filterField;
    private EmptyBorderButton filterStateButton;
    private GTreeFilterFactory filterFactory;
    private FilterDocumentListener filterListener = new FilterDocumentListener();
    private GTree gTree;
    private JPanel filterPanel;
    private FilterTransformer<GTreeNode> dataTransformer = new DefaultGTreeDataTransformer();
    private boolean optionsSet;

    public DefaultGTreeFilterProvider(GTree gTree) {
        this.gTree = gTree;
        this.filterFactory = new GTreeFilterFactory(new FilterOptions());
        this.filterPanel = this.createFilterPanel();
    }

    @Override
    public GTreeFilterProvider copy(GTree newTree) {
        String accessibleNamePrefix;
        DefaultGTreeFilterProvider newProvider = new DefaultGTreeFilterProvider(newTree);
        FilterOptions existingOptions = this.filterFactory.getFilterOptions();
        newProvider.setFilterOptions(existingOptions);
        String existingText = this.filterField.getText();
        newProvider.setFilterText(existingText);
        if (!this.filterField.isEnabled()) {
            newProvider.setEnabled(false);
        }
        if ((accessibleNamePrefix = this.filterField.getAccessibleNamePrefix()) != null) {
            newProvider.setAccessibleNamePrefix(accessibleNamePrefix);
        }
        return newProvider;
    }

    @Override
    public JComponent getFilterComponent() {
        return this.filterPanel;
    }

    @Override
    public void setFilterText(String text) {
        this.filterListener.enableEvents(false);
        this.filterField.setText(text);
        this.updateModelFilter();
        this.filterListener.enableEvents(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.filterField.setEnabled(enabled);
    }

    @Override
    public void setAccessibleNamePrefix(String namePrefix) {
        this.filterField.setAccessibleNamePrefix(namePrefix);
        String buttonNamePrefix = namePrefix + " Filter Options";
        this.filterStateButton.setName(buttonNamePrefix + " Button");
        AccessibleContext context = this.filterStateButton.getAccessibleContext();
        context.setAccessibleName(buttonNamePrefix);
        context.setAccessibleDescription("");
    }

    private void updateModelFilter() {
        FilterOptions filterOptions = this.filterFactory.getFilterOptions();
        this.filterStateButton.setIcon(filterOptions.getFilterStateIcon());
        this.filterStateButton.setToolTipText(filterOptions.getFilterDescription());
        this.gTree.filterChanged();
    }

    private void saveFilterState() {
        PreferenceState preferenceState = new PreferenceState();
        preferenceState.putXmlElement(FILTER_STATE, this.filterFactory.getFilterOptions().toXML());
        DockingWindowManager dwm = DockingWindowManager.getInstance(this.gTree.getJTree());
        if (dwm != null) {
            dwm.putPreferenceState(this.gTree.getPreferenceKey(), preferenceState);
        }
    }

    public void setFilterOptions(FilterOptions filterOptions) {
        this.optionsSet = true;
        this.filterFactory = new GTreeFilterFactory(filterOptions);
        this.saveFilterState();
        this.updateModelFilter();
    }

    public FilterOptions getFilterOptions() {
        return this.filterFactory.getFilterOptions();
    }

    @Override
    public void loadFilterPreference(DockingWindowManager windowManager) {
        if (this.optionsSet) {
            return;
        }
        if (windowManager == null) {
            return;
        }
        PreferenceState state = windowManager.getPreferenceState(this.gTree.getPreferenceKey());
        if (state == null) {
            return;
        }
        Element xmlElement = state.getXmlElement(FILTER_STATE);
        if (xmlElement != null) {
            FilterOptions filterOptions = FilterOptions.restoreFromXML(xmlElement);
            this.filterFactory = new GTreeFilterFactory(filterOptions);
        }
        this.updateModelFilter();
    }

    private JPanel createFilterPanel() {
        JPanel newFilterPanel = new JPanel(new BorderLayout());
        newFilterPanel.setBorder(BorderFactory.createBevelBorder(1));
        GLabel filterLabel = new GLabel(" Filter: ");
        newFilterPanel.add((Component)filterLabel, "West");
        this.filterField = new FilterTextField(this.gTree.getJTree());
        newFilterPanel.add((Component)this.filterField, "Center");
        this.filterField.addFilterListener(this.filterListener);
        this.filterStateButton = new EmptyBorderButton(this.filterFactory.getFilterStateIcon());
        this.filterStateButton.addActionListener(e -> {
            FilterOptionsEditorDialog dialog = new FilterOptionsEditorDialog(this.filterFactory.getFilterOptions());
            DockingWindowManager.showDialog(this.filterPanel, dialog);
            FilterOptions newFilterOptions = dialog.getResultFilterOptions();
            if (newFilterOptions != null) {
                this.filterFactory = new GTreeFilterFactory(newFilterOptions);
                this.saveFilterState();
                this.updateModelFilter();
            }
        });
        HelpService helpService = DockingWindowManager.getHelpService();
        HelpLocation helpLocation = new HelpLocation("Trees", "Filters");
        helpService.registerHelp((Object)this.filterStateButton, helpLocation);
        helpService.registerHelp((Object)filterLabel, helpLocation);
        helpService.registerHelp((Object)this.filterField, helpLocation);
        this.filterStateButton.setToolTipText("Filter Options");
        newFilterPanel.add((Component)this.filterStateButton, "East");
        return newFilterPanel;
    }

    @Override
    public GTreeFilter getFilter() {
        return this.filterFactory.getTreeFilter(this.filterField.getText(), this.dataTransformer);
    }

    @Override
    public String getFilterText() {
        return this.filterField.getText();
    }

    @Override
    public void setDataTransformer(FilterTransformer<GTreeNode> transformer) {
        this.dataTransformer = transformer;
    }

    private class FilterDocumentListener
    implements FilterListener {
        private boolean processEvents = true;

        private FilterDocumentListener() {
        }

        @Override
        public void filterChanged(String text) {
            if (this.processEvents) {
                DefaultGTreeFilterProvider.this.updateModelFilter();
            }
        }

        void enableEvents(boolean enable) {
            this.processEvents = enable;
        }
    }
}

