/*
 * Decompiled with CFR 0.152.
 */
package ghidra.docking.util;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.ToggleDockingAction;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.Gui;
import generic.util.WindowUtilities;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.bean.GGlassPane;
import ghidra.util.layout.PairLayout;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import resources.Icons;

public class ComponentInfoDialog
extends DialogComponentProvider
implements PropertyChangeListener {
    private static final String ACTION_OWNER = "Component Info";
    private Container rootComponentForTable;
    private List<ComponentInfo> infos = new ArrayList<ComponentInfo>();
    private Map<Component, ComponentInfo> infoMap = new HashMap<Component, ComponentInfo>();
    private GFilterTable<ComponentInfo> filterTable;
    private ComponentTableModel model;
    private ToggleDockingAction filterAction;
    private JTextField oldWindowTextField;
    private JTextField newWindowTextField;
    private JTextField oldProviderTextField;
    private JTextField newProviderTextField;
    private JTextField oldComponentTextField;
    private JTextField newComponentTextField;
    private Window currentWindow;
    private ComponentProvider currentProvider;
    private Component currentComponent;
    private EventDisplayPanel eventDisplay;
    private JSplitPane splitPane;
    private ToggleDockingAction eventAction;
    private ToggleDockingAction toggleFollowFocusAction;
    private boolean updateOnFocusChange = true;

    public ComponentInfoDialog() {
        super("Component Inspector", false);
        this.addWorkPanel(this.buildMainPanel());
        this.addDismissButton();
        this.addOKButton();
        this.setOkButtonText("Reset");
        this.setOkToolTip("Clears component table and will re-populate on next focussed component");
        this.setPreferredSize(1200, 600);
        this.eventDisplay = new EventDisplayPanel();
        this.createActions();
        KeyboardFocusManager km = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        km.addPropertyChangeListener("permanentFocusOwner", this);
        this.reset();
    }

    private void createActions() {
        DockingAction refreshAction = ((ActionBuilder)((ActionBuilder)new ActionBuilder("Refresh", ACTION_OWNER).toolBarIcon(Icons.REFRESH_ICON)).onAction(c -> this.refreshModelData())).build();
        this.addAction(refreshAction);
        this.filterAction = ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Filter", ACTION_OWNER).toolBarIcon(Icons.CONFIGURE_FILTER_ICON)).description("Filters out most non-focusable components")).onAction(c -> this.refreshModelData())).selected(true).build();
        this.addAction(this.filterAction);
        this.eventAction = ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Show Events", ACTION_OWNER).toolBarIcon(Icons.INFO_ICON)).description("Shows focus events")).onAction(c -> this.toggleShowEvents())).build();
        this.addAction(this.eventAction);
        this.toggleFollowFocusAction = ((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Follow Focus", ACTION_OWNER).toolBarIcon(Icons.NAVIGATE_ON_INCOMING_EVENT_ICON)).description("On causes component table to constant repopulate as focus changes")).onAction(c -> this.toggleFollowFocus())).selected(true).build();
        this.addAction(this.toggleFollowFocusAction);
    }

    private void toggleFollowFocus() {
        this.updateOnFocusChange = this.toggleFollowFocusAction.isSelected();
        this.setOkEnabled(!this.updateOnFocusChange);
    }

    private void toggleShowEvents() {
        if (this.eventAction.isSelected()) {
            this.splitPane.setBottomComponent(this.eventDisplay);
            this.splitPane.setDividerLocation(0.7);
            this.splitPane.setResizeWeight(0.7);
        } else {
            this.splitPane.setBottomComponent(null);
        }
    }

    private void refreshModelData() {
        this.buildComponentModel();
    }

    @Override
    protected void okCallback() {
        this.reset();
    }

    private void reset() {
        this.setRootContainer(null);
    }

    private ComponentInfo getComponentInfo(Component comp) {
        return this.infoMap.get(comp);
    }

    private JComponent buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildCenterPanel(), "Center");
        panel.add((Component)this.buildInfoPanel(), "South");
        return panel;
    }

    private JComponent buildCenterPanel() {
        this.splitPane = new JSplitPane(0);
        this.splitPane.setTopComponent(this.buildTablePanel());
        return this.splitPane;
    }

    private JComponent buildTablePanel() {
        this.model = new ComponentTableModel();
        this.filterTable = new GFilterTable<ComponentInfo>(this.model);
        this.filterTable.setAccessibleNamePrefix(ACTION_OWNER);
        return this.filterTable;
    }

    private JComponent buildInfoPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(4, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(4, 10, 20, 10));
        this.oldWindowTextField = new JTextField(50);
        this.newWindowTextField = new JTextField(50);
        this.oldProviderTextField = new JTextField(50);
        this.newProviderTextField = new JTextField(50);
        this.oldComponentTextField = new JTextField(50);
        this.newComponentTextField = new JTextField(50);
        this.oldWindowTextField.setFocusable(false);
        this.newWindowTextField.setFocusable(false);
        this.oldProviderTextField.setFocusable(false);
        this.newProviderTextField.setFocusable(false);
        this.oldComponentTextField.setFocusable(false);
        this.newComponentTextField.setFocusable(false);
        panel.add(new JLabel("Focused Window (new/old): ", 4));
        panel.add(this.buildTextPair(this.newWindowTextField, this.oldWindowTextField));
        panel.add(new JLabel("Focused Provider (new/old): ", 4));
        panel.add(this.buildTextPair(this.newProviderTextField, this.oldProviderTextField));
        panel.add(new JLabel("Focused Component (new/old): ", 4));
        panel.add(this.buildTextPair(this.newComponentTextField, this.oldComponentTextField));
        return panel;
    }

    private Component buildTextPair(JComponent comp1, JComponent comp2) {
        JPanel panel = new JPanel(new GridLayout(1, 2, 10, 10));
        panel.add(comp1);
        panel.add(comp2);
        return panel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.eventDisplay.report(this.getDisplayString(evt));
        this.filterTable.setSelectedRowObject(null);
        Component newFocusComponent = (Component)evt.getNewValue();
        this.selectFocusedComponentInTable(newFocusComponent);
        this.updateFocusInfo(newFocusComponent);
    }

    private String getDisplayString(PropertyChangeEvent evt) {
        StringBuilder builder = new StringBuilder();
        builder.append(evt.getPropertyName());
        builder.append(": OLD = ");
        builder.append(this.getName((Component)evt.getOldValue()));
        builder.append(", NEW = ");
        builder.append(this.getName((Component)evt.getNewValue()));
        return builder.toString();
    }

    private void updateFocusInfo(Component newFocusComponent) {
        if (newFocusComponent == null) {
            return;
        }
        if (newFocusComponent == this.currentComponent) {
            return;
        }
        this.oldComponentTextField.setText(this.newComponentTextField.getText());
        this.currentComponent = newFocusComponent;
        this.newComponentTextField.setText(this.getName(this.currentComponent));
        this.oldProviderTextField.setText(this.newProviderTextField.getText());
        this.currentProvider = DockingWindowManager.getActiveInstance().getProvider(newFocusComponent);
        this.newProviderTextField.setText(this.currentProvider == null ? "" : this.currentProvider.getName());
        this.oldWindowTextField.setText(this.newWindowTextField.getText());
        this.currentWindow = SwingUtilities.windowForComponent(newFocusComponent);
        this.newWindowTextField.setText(WindowUtilities.getTitle((Window)this.currentWindow));
    }

    private String getName(Component comp) {
        if (comp == null) {
            return null;
        }
        String name = comp.getName();
        StringBuilder buf = new StringBuilder(name == null ? "" : name);
        buf.append(" (");
        buf.append(comp.getClass().getSimpleName());
        buf.append(")");
        return buf.toString();
    }

    private void selectFocusedComponentInTable(Component newFocusComponent) {
        if (this.infos.isEmpty() || this.updateOnFocusChange) {
            if (newFocusComponent == null) {
                return;
            }
            this.setRootContainer(this.findRoot(newFocusComponent));
        }
        ComponentInfo focusedInfo = this.getComponentInfo(newFocusComponent);
        this.filterTable.setSelectedRowObject(focusedInfo);
    }

    void setRootContainer(Container container) {
        if (this.rootComponentForTable == container) {
            return;
        }
        this.rootComponentForTable = container;
        this.buildComponentModel();
    }

    void buildComponentModel() {
        ComponentInfo.resetIds();
        this.infos = this.findComponents(this.rootComponentForTable);
        this.buildInfoMap();
        this.model.setModelData(this.filterAction.isSelected() ? this.filterInfos() : this.infos);
    }

    private List<ComponentInfo> filterInfos() {
        ArrayList<ComponentInfo> result = new ArrayList<ComponentInfo>();
        for (ComponentInfo info : this.infos) {
            if (!this.shouldInclude(info)) continue;
            result.add(info);
        }
        return result;
    }

    private void buildInfoMap() {
        for (ComponentInfo info : this.infos) {
            this.infoMap.put(info.getComponent(), info);
        }
    }

    private List<ComponentInfo> findComponents(Container root) {
        ArrayList<ComponentInfo> infoList = new ArrayList<ComponentInfo>();
        if (root == null) {
            return infoList;
        }
        ComponentInfo rootInfo = new ComponentInfo(null, root, 0);
        infoList.add(rootInfo);
        for (int i = 0; i < root.getComponentCount(); ++i) {
            Component comp = root.getComponent(i);
            ComponentInfo info = new ComponentInfo(rootInfo, comp, i);
            infoList.add(info);
            this.addChildInfos(infoList, info);
        }
        return infoList;
    }

    private void addChildInfos(List<ComponentInfo> infoList, ComponentInfo parentInfo) {
        Component component = parentInfo.getComponent();
        if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component comp = container.getComponent(i);
                ComponentInfo info = new ComponentInfo(parentInfo, comp, i);
                infoList.add(info);
                this.addChildInfos(infoList, info);
            }
        }
    }

    private boolean shouldInclude(ComponentInfo info) {
        Component component = info.getComponent();
        if (!component.isFocusable()) {
            return false;
        }
        if (component instanceof JPanel) {
            JPanel jPanel = (JPanel)component;
            if (info.getCycleRootIndex() == null) {
                return false;
            }
        }
        if (component instanceof GGlassPane) {
            return false;
        }
        if (component instanceof JRootPane) {
            return false;
        }
        if (component instanceof JViewport) {
            return false;
        }
        if (component instanceof JLayeredPane) {
            return false;
        }
        if (component instanceof JLabel) {
            return false;
        }
        return !(component instanceof JMenu);
    }

    private Container findRoot(Component component) {
        if (component.getParent() == null) {
            return component instanceof Container ? (Container)component : null;
        }
        if (component instanceof Window) {
            Window window = (Window)component;
            return window;
        }
        return this.findRoot(component.getParent());
    }

    class EventDisplayPanel
    extends JPanel {
        private static int NUM_MESSAGES = 20;
        private JTextArea text;
        private List<String> messages;

        EventDisplayPanel() {
            super(new BorderLayout());
            this.messages = new LinkedList<String>();
            this.setBorder(BorderFactory.createEmptyBorder(0, 10, 2, 10));
            this.text = new JTextArea(5, 100);
            this.text.setFont(Gui.getFont((String)"font.monospaced"));
            this.text.setEditable(false);
            JScrollPane scroll = new JScrollPane(this.text);
            scroll.setVerticalScrollBarPolicy(22);
            this.add((Component)scroll, "Center");
        }

        void report(String message) {
            this.messages.add(message);
            if (this.messages.size() > NUM_MESSAGES) {
                this.messages.remove(0);
            }
            this.text.setText(this.buildText());
        }

        private String buildText() {
            StringBuilder builder = new StringBuilder();
            for (String message : this.messages) {
                builder.append(message);
                builder.append("\n");
            }
            return builder.toString();
        }
    }

    class ComponentInfo {
        private static int nextId = 0;
        private ComponentInfo parent;
        private Component component;
        private int id = ++nextId;
        private int depth;
        private String nameAndId;
        private boolean isCycleRoot;
        private List<Component> traversalComps;
        private Integer cycleRootIndex;

        ComponentInfo(ComponentInfo parent, Component component, int indexInParent) {
            this.parent = parent;
            this.component = component;
            this.depth = parent == null ? 0 : parent.depth + 1;
            this.nameAndId = component.getName() + " (" + this.id + ")";
            this.isCycleRoot = this.checkIsCycleRoot();
            if (this.isCycleRoot) {
                this.traversalComps = this.computeTraversalComps();
            }
        }

        public String getToolTip() {
            Component component = this.component;
            if (component instanceof JComponent) {
                JComponent jComp = (JComponent)component;
                return jComp.getToolTipText();
            }
            return null;
        }

        private Integer computeCycleRootIndex() {
            Container cycleRoot = this.component.getFocusCycleRootAncestor();
            if (cycleRoot == null) {
                return -1;
            }
            ComponentInfo cycleRootInfo = ComponentInfoDialog.this.getComponentInfo(cycleRoot);
            List<Component> rootTraversalComps = cycleRootInfo.getTraversalComps();
            return rootTraversalComps.indexOf(this.component);
        }

        private List<Component> computeTraversalComps() {
            ArrayList<Component> traversals = new ArrayList<Component>();
            Container container = (Container)this.component;
            FocusTraversalPolicy policy = container.getFocusTraversalPolicy();
            Component comp = policy.getFirstComponent(container);
            while (comp != null && !traversals.contains(comp)) {
                traversals.add(comp);
                comp = policy.getComponentAfter(container, comp);
            }
            return traversals;
        }

        public Integer getCycleRootIndex() {
            if (this.cycleRootIndex == null) {
                this.cycleRootIndex = this.computeCycleRootIndex();
            }
            return this.cycleRootIndex < 0 ? null : this.cycleRootIndex;
        }

        public List<Component> getTraversalComps() {
            return this.traversalComps;
        }

        private boolean checkIsCycleRoot() {
            Component component = this.component;
            if (component instanceof Container) {
                Container container = (Container)component;
                return this.component.isFocusCycleRoot(container);
            }
            return false;
        }

        public boolean isCycleRoot() {
            return this.isCycleRoot;
        }

        public String getNameAndId() {
            return this.nameAndId;
        }

        public String getClassSimpleName() {
            String name = this.component.getClass().getName();
            int lastIndexOf = name.lastIndexOf(".");
            if (lastIndexOf < 0) {
                return name;
            }
            return name.substring(lastIndexOf + 1);
        }

        public Boolean isFocusable() {
            return this.component.isFocusable();
        }

        public String getName() {
            return this.component.getName();
        }

        public int getId() {
            return this.id;
        }

        public Component getComponent() {
            return this.component;
        }

        public ComponentInfo getParent() {
            return this.parent;
        }

        public int getDepth() {
            return this.depth;
        }

        public static void resetIds() {
            nextId = 0;
        }
    }

    class ComponentTableModel
    extends GDynamicColumnTableModel<ComponentInfo, Object> {
        private List<ComponentInfo> modelData;

        public ComponentTableModel() {
            super((ServiceProvider)new ServiceProviderStub());
            this.modelData = new ArrayList<ComponentInfo>();
        }

        void setModelData(List<ComponentInfo> data) {
            this.modelData = new ArrayList<ComponentInfo>(data);
            this.fireTableDataChanged();
        }

        @Override
        public String getName() {
            return ComponentInfoDialog.ACTION_OWNER;
        }

        @Override
        public List<ComponentInfo> getModelData() {
            return this.modelData;
        }

        @Override
        protected TableColumnDescriptor<ComponentInfo> createTableColumnDescriptor() {
            TableColumnDescriptor<ComponentInfo> descriptor = new TableColumnDescriptor<ComponentInfo>();
            descriptor.addVisibleColumn(new ComponentIdColumn(this), 1, true);
            descriptor.addVisibleColumn(new ParentIdColumn(this));
            descriptor.addVisibleColumn(new CycleIndexColumn(this));
            descriptor.addVisibleColumn(new ComponentNameColumn(this));
            descriptor.addVisibleColumn(new ComponentClassColumn(this));
            descriptor.addVisibleColumn(new ToolTipColumn(this));
            descriptor.addVisibleColumn(new AccessibleNameColumn(this));
            descriptor.addVisibleColumn(new AccessibleDescriptionColumn(this));
            descriptor.addHiddenColumn(new FocusableColumn(this));
            descriptor.addHiddenColumn(new IsFocusCycleRootColumn(this));
            descriptor.addHiddenColumn(new focusCycleRootColumn());
            descriptor.addVisibleColumn(new TraversalKeysColumn(this));
            return descriptor;
        }

        @Override
        public Object getDataSource() {
            return null;
        }

        private class ComponentIdColumn
        extends AbstractDynamicTableColumn<ComponentInfo, Integer, Object> {
            private ComponentIdColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Id";
            }

            @Override
            public Integer getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                return info.getId();
            }

            @Override
            public int getColumnPreferredWidth() {
                return 50;
            }
        }

        private class ParentIdColumn
        extends AbstractDynamicTableColumn<ComponentInfo, String, Object> {
            private ParentIdColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Parent Id";
            }

            @Override
            public String getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                ComponentInfo parent = info.getParent();
                return parent == null ? null : parent.getNameAndId();
            }

            @Override
            public int getColumnPreferredWidth() {
                return 50;
            }
        }

        private class CycleIndexColumn
        extends AbstractDynamicTableColumn<ComponentInfo, Integer, Object> {
            private CycleIndexColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Cycle Index";
            }

            @Override
            public Integer getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                return info.getCycleRootIndex();
            }

            @Override
            public int getColumnPreferredWidth() {
                return 200;
            }
        }

        private class ComponentNameColumn
        extends AbstractDynamicTableColumn<ComponentInfo, String, Object> {
            private ComponentNameColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Name";
            }

            @Override
            public String getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                return info.getName();
            }

            @Override
            public int getColumnPreferredWidth() {
                return 200;
            }
        }

        private class ComponentClassColumn
        extends AbstractDynamicTableColumn<ComponentInfo, String, Object> {
            private ComponentClassColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Class";
            }

            @Override
            public String getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                return info.getClassSimpleName();
            }

            @Override
            public int getColumnPreferredWidth() {
                return 300;
            }
        }

        private class ToolTipColumn
        extends AbstractDynamicTableColumn<ComponentInfo, String, Object> {
            private ToolTipColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Tool Tip";
            }

            @Override
            public String getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                return info.getToolTip();
            }

            @Override
            public int getColumnPreferredWidth() {
                return 200;
            }
        }

        private class AccessibleNameColumn
        extends AbstractDynamicTableColumn<ComponentInfo, String, Object> {
            private AccessibleNameColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Accessible Name";
            }

            @Override
            public String getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                AccessibleContext context = info.getComponent().getAccessibleContext();
                if (context != null) {
                    return context.getAccessibleName();
                }
                return "";
            }

            @Override
            public int getColumnPreferredWidth() {
                return 200;
            }
        }

        private class AccessibleDescriptionColumn
        extends AbstractDynamicTableColumn<ComponentInfo, String, Object> {
            private AccessibleDescriptionColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Accessible Description";
            }

            @Override
            public String getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                AccessibleContext context = info.getComponent().getAccessibleContext();
                if (context != null) {
                    return context.getAccessibleDescription();
                }
                return "";
            }

            @Override
            public int getColumnPreferredWidth() {
                return 200;
            }
        }

        private class FocusableColumn
        extends AbstractDynamicTableColumn<ComponentInfo, Boolean, Object> {
            private FocusableColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Focusable";
            }

            @Override
            public Boolean getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                return info.isFocusable();
            }

            @Override
            public int getColumnPreferredWidth() {
                return 50;
            }
        }

        private class IsFocusCycleRootColumn
        extends AbstractDynamicTableColumn<ComponentInfo, Boolean, Object> {
            private IsFocusCycleRootColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Is Cycle Root";
            }

            @Override
            public Boolean getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                return info.isCycleRoot();
            }

            @Override
            public int getColumnPreferredWidth() {
                return 200;
            }
        }

        private class focusCycleRootColumn
        extends AbstractDynamicTableColumn<ComponentInfo, String, Object> {
            private focusCycleRootColumn() {
            }

            @Override
            public String getColumnName() {
                return "Cycle Root";
            }

            @Override
            public String getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                Component component = info.getComponent();
                Container cycleRoot = component.getFocusCycleRootAncestor();
                ComponentInfo cycleRootInfo = ComponentInfoDialog.this.getComponentInfo(cycleRoot);
                if (cycleRootInfo != null) {
                    return cycleRootInfo.getNameAndId();
                }
                return null;
            }

            @Override
            public int getColumnPreferredWidth() {
                return 200;
            }
        }

        private class TraversalKeysColumn
        extends AbstractDynamicTableColumn<ComponentInfo, String, Object> {
            private TraversalKeysColumn(ComponentTableModel componentTableModel) {
            }

            @Override
            public String getColumnName() {
                return "Traversal Keys";
            }

            @Override
            public String getValue(ComponentInfo info, Settings settings, Object data, ServiceProvider provider) throws IllegalArgumentException {
                Set<AWTKeyStroke> keys = info.getComponent().getFocusTraversalKeys(0);
                return keys == null ? "" : keys.toString();
            }

            @Override
            public int getColumnPreferredWidth() {
                return 50;
            }
        }
    }
}

