/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.microsoft;

import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.Demangler;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.program.model.listing.Program;
import mdemangler.MDException;
import mdemangler.MDMangGhidra;

public class MicrosoftDemangler
implements Demangler {
    public boolean canDemangle(Program program) {
        String executableFormat = program.getExecutableFormat();
        return executableFormat != null && (executableFormat.indexOf("Portable Executable (PE)") != -1 || executableFormat.indexOf("MS Common Object File Format (COFF)") != -1);
    }

    @Deprecated(since="9.2", forRemoval=true)
    public DemangledObject demangle(String mangled, boolean demangleOnlyKnownPatterns) throws DemangledException {
        try {
            DemangledObject demangled = this.demangleMS(mangled, demangleOnlyKnownPatterns);
            return demangled;
        }
        catch (DemangledException e) {
            throw new DemangledException(true);
        }
    }

    public DemangledObject demangle(String mangled, DemanglerOptions options) throws DemangledException {
        try {
            DemangledObject demangled = this.demangleMS(mangled, options.demangleOnlyKnownPatterns());
            return demangled;
        }
        catch (DemangledException e) {
            throw new DemangledException(true);
        }
    }

    private DemangledObject demangleMS(String mangled, boolean demangleOnlyKnownPatterns) throws DemangledException {
        if (mangled == null || mangled.length() == 0) {
            throw new DemangledException(true);
        }
        MDMangGhidra demangler = new MDMangGhidra();
        try {
            demangler.demangle(mangled, true, demangleOnlyKnownPatterns);
            DemangledObject object = demangler.getObject();
            return object;
        }
        catch (MDException e) {
            DemangledException de = new DemangledException("Unable to demangle symbol: " + mangled);
            de.initCause((Throwable)e);
            throw de;
        }
    }
}

