/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.agent;

import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.InvalidatableTargetObjectIf;
import ghidra.dbg.agent.SpiTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@Deprecated(forRemoval=true, since="11.2")
public abstract class AbstractTargetObject<P extends TargetObject>
implements SpiTargetObject {
    protected static final ProxyFactory<Void> THIS_FACTORY = (d, i) -> d;
    protected static final CompletableFuture<Map<String, TargetObject>> COMPLETED_EMPTY_ELEMENTS = CompletableFuture.completedFuture(Map.of());
    protected static final CompletableFuture<Map<String, Object>> COMPLETED_EMPTY_ATTRIBUTES = CompletableFuture.completedFuture(Map.of());
    protected final AbstractDebuggerObjectModel model;
    protected final SpiTargetObject proxy;
    protected final P parent;
    protected final List<String> path;
    protected final int hash;
    protected final String typeHint;
    protected final TargetObjectSchema schema;
    protected volatile boolean valid = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I> AbstractTargetObject(ProxyFactory<I> proxyFactory, I proxyInfo, AbstractDebuggerObjectModel model, P parent, String key, String typeHint, TargetObjectSchema schema) {
        this.model = model;
        this.parent = parent;
        this.path = parent == null ? (key == null ? List.of() : List.of(key)) : PathUtils.extend(parent.getPath(), key);
        Object object = model.lock;
        synchronized (object) {
            model.removeExisting(this.path);
            this.hash = this.computeHashCode();
            this.typeHint = typeHint;
            this.schema = schema;
            this.proxy = proxyFactory.createProxy(this, proxyInfo);
            this.fireCreated();
        }
    }

    public AbstractTargetObject(AbstractDebuggerObjectModel model, P parent, String key, String typeHint, TargetObjectSchema schema) {
        this(THIS_FACTORY, null, model, parent, key, typeHint, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCreated() {
        SpiTargetObject proxy = this.getProxy();
        assert (proxy != null);
        Object object = this.model.lock;
        synchronized (object) {
            this.model.objectCreated(proxy);
            this.broadcast().created(proxy);
        }
    }

    public SpiTargetObject getProxy() {
        return this.proxy;
    }

    public P getParent() {
        return this.parent;
    }

    @Override
    public <T extends TargetObject> T as(Class<T> iface) {
        return DebuggerObjectModel.requireIface(iface, this.getProxy(), this.path);
    }

    @Override
    public Collection<String> getInterfaceNames() {
        return TargetObject.Protected.getInterfaceNamesOf(this.getProxy().getClass());
    }

    @Override
    public boolean enforcesStrictSchema() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        return this.doEquals(obj);
    }

    @Override
    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return String.format("<%s: path=%s model=%s schema=%s>", this.getClass().getSimpleName(), this.getJoinedPath("."), this.getModel(), this.schema.getName());
    }

    @Override
    public String getTypeHint() {
        return this.typeHint;
    }

    @Override
    public TargetObjectSchema getSchema() {
        return this.schema;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public AbstractDebuggerObjectModel getModel() {
        return this.model;
    }

    @Override
    public CompletableFuture<? extends Map<String, ? extends TargetObject>> fetchElements() {
        return COMPLETED_EMPTY_ELEMENTS;
    }

    @Override
    public CompletableFuture<? extends TargetObject> fetchElement(String index) {
        return this.fetchElements().thenApply(elements -> (TargetObject)elements.get(index));
    }

    @Override
    public CompletableFuture<? extends Map<String, ?>> fetchAttributes() {
        return COMPLETED_EMPTY_ATTRIBUTES;
    }

    @Override
    public Object getProtocolID() {
        return this.getPath();
    }

    @Override
    public List<String> getPath() {
        return this.path;
    }

    protected void doInvalidate(TargetObject branch, String reason) {
        if (!this.valid) {
            return;
        }
        this.valid = false;
        this.model.objectInvalidated(this.getProxy());
        this.broadcast().invalidated(this.getProxy(), branch, reason);
    }

    protected void doInvalidateElements(Map<String, ?> elems, String reason) {
        for (Map.Entry<String, ?> ent : elems.entrySet()) {
            String name = ent.getKey();
            Object e = ent.getValue();
            if (!(e instanceof InvalidatableTargetObjectIf) || !(e instanceof TargetObject)) continue;
            InvalidatableTargetObjectIf obj = (InvalidatableTargetObjectIf)e;
            if (PathUtils.isElementLink(this.getPath(), name, obj.getPath())) continue;
            obj.doInvalidateSubtree((TargetObject)e, reason);
        }
    }

    protected void doInvalidateElements(TargetObject branch, Map<String, ?> elems, String reason) {
        for (Map.Entry<String, ?> ent : elems.entrySet()) {
            String name = ent.getKey();
            Object e = ent.getValue();
            if (!(e instanceof InvalidatableTargetObjectIf)) continue;
            InvalidatableTargetObjectIf obj = (InvalidatableTargetObjectIf)e;
            if (PathUtils.isElementLink(this.getPath(), name, obj.getPath())) continue;
            obj.doInvalidateSubtree(branch, reason);
        }
    }

    protected void doInvalidateAttributes(Map<String, ?> attrs, String reason) {
        for (Map.Entry<String, ?> ent : attrs.entrySet()) {
            String name = ent.getKey();
            Object a = ent.getValue();
            if (!(a instanceof InvalidatableTargetObjectIf) || !(a instanceof TargetObject)) continue;
            InvalidatableTargetObjectIf obj = (InvalidatableTargetObjectIf)a;
            if (PathUtils.isLink(this.getPath(), name, obj.getPath())) continue;
            obj.doInvalidateSubtree((TargetObject)a, reason);
        }
    }

    protected void doInvalidateAttributes(TargetObject branch, Map<String, ?> attrs, String reason) {
        for (Map.Entry<String, ?> ent : attrs.entrySet()) {
            String name = ent.getKey();
            Object a = ent.getValue();
            if (!(a instanceof InvalidatableTargetObjectIf)) continue;
            InvalidatableTargetObjectIf obj = (InvalidatableTargetObjectIf)a;
            if (PathUtils.isLink(this.getPath(), name, obj.getPath())) continue;
            obj.doInvalidateSubtree(branch, reason);
        }
    }

    @Override
    public void doInvalidateSubtree(TargetObject branch, String reason) {
        this.doInvalidate(branch, reason);
        this.doInvalidateElements(branch, this.getCachedElements(), reason);
        this.doInvalidateAttributes(branch, this.getCachedAttributes(), reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateSubtree(TargetObject branch, String reason) {
        Object object = this.model.lock;
        synchronized (object) {
            this.doInvalidateSubtree(branch, reason);
        }
    }

    @Override
    public DebuggerModelListener broadcast() {
        return this.model.broadcast();
    }

    public static interface ProxyFactory<I> {
        public SpiTargetObject createProxy(AbstractTargetObject<?> var1, I var2);
    }
}

