/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.agent;

import ghidra.framework.LoggingInitialization;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.SocketAddress;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import log.LogListener;
import log.LogPanelAppender;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;

@Deprecated(forRemoval=true, since="11.2")
public class AgentWindow
extends JFrame
implements WindowListener,
LogListener {
    public static final int MAX_LOG_CHARS = 100000;
    protected final JTextPane logPane = new JTextPane();
    protected final JScrollPane logScroll = new JScrollPane(this.logPane);

    public AgentWindow(String title, SocketAddress localAddress) {
        super(title);
        this.setLayout(new BorderLayout());
        this.addWindowListener(this);
        this.add((Component)new JLabel("<html>This agent is listening at <b>" + String.valueOf(localAddress) + "</b>. Close this window to terminate it.</html>"), "North");
        this.logPane.setEditable(false);
        this.logPane.setFont(Font.decode("Monospaced"));
        this.logPane.setAutoscrolls(true);
        this.logScroll.setAutoscrolls(true);
        DefaultCaret caret = (DefaultCaret)this.logPane.getCaret();
        caret.setUpdatePolicy(2);
        this.add(this.logScroll);
        this.setMinimumSize(new Dimension(400, 300));
        this.setVisible(true);
        System.setProperty("log4j.configurationFile", "agent.log4j.xml");
        LoggingInitialization.initializeLoggingSystem();
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        Appender appender = config.getAppender("logPanel");
        if (!(appender instanceof LogPanelAppender)) {
            Msg.error((Object)this, (Object)"Couldn't find LogPanelAppender instance in the Log4j context. Nothing will be logged to the agent's window.");
        } else {
            LogPanelAppender logPanelAppender = (LogPanelAppender)appender;
            logPanelAppender.setLogListener((LogListener)this);
        }
    }

    public void messageLogged(String message, boolean isError) {
        Swing.runIfSwingOrRunLater(() -> {
            SimpleAttributeSet attributes = new SimpleAttributeSet();
            if (isError) {
                StyleConstants.setForeground(attributes, Color.RED);
            }
            StyledDocument document = this.logPane.getStyledDocument();
            try {
                document.insertString(document.getLength(), message + "\n", attributes);
                if (document.getLength() > 100000) {
                    document.remove(0, document.getLength() - 100000);
                }
            }
            catch (BadLocationException e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.out.println("User closed agent window. Exiting");
        System.exit(0);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

