/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.agent;

import ghidra.async.AsyncUtils;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.agent.AbstractDebuggerObjectModel;
import ghidra.dbg.agent.AbstractTargetObject;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.CollectionUtils;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Deprecated(forRemoval=true, since="11.2")
public class DefaultTargetObject<E extends TargetObject, P extends TargetObject>
extends AbstractTargetObject<P> {
    protected final Map<String, E> elements = new HashMap<String, E>();
    protected final Map<String, E> cbElements = new HashMap<String, E>();
    protected final Map<String, E> roCbElements = Collections.unmodifiableMap(this.cbElements);
    protected CompletableFuture<Void> curElemsRequest;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected final Map<String, Object> cbAttributes = new HashMap<String, Object>();
    protected final Map<String, Object> roCbAttributes = Collections.unmodifiableMap(this.cbAttributes);
    protected CompletableFuture<Void> curAttrsRequest;

    public DefaultTargetObject(AbstractDebuggerObjectModel model, P parent, String key, String typeHint) {
        this(model, parent, key, typeHint, parent.getSchema().getChildSchema(key));
    }

    public DefaultTargetObject(AbstractDebuggerObjectModel model, P parent, String key, String typeHint, TargetObjectSchema schema) {
        this(THIS_FACTORY, null, model, parent, key, typeHint, schema);
    }

    public <I> DefaultTargetObject(AbstractTargetObject.ProxyFactory<I> proxyFactory, I proxyInfo, AbstractDebuggerObjectModel model, P parent, String key, String typeHint, TargetObjectSchema schema) {
        super(proxyFactory, proxyInfo, model, parent, key, typeHint, schema);
        this.changeAttributes(List.of(), List.of(), Map.ofEntries(Map.entry("_display", key == null ? "<root>" : key)), "Default");
    }

    public <I> DefaultTargetObject(AbstractTargetObject.ProxyFactory<I> proxyFactory, I proxyInfo, AbstractDebuggerObjectModel model, P parent, String key, String typeHint) {
        this(proxyFactory, proxyInfo, model, parent, key, typeHint, parent.getSchema().getChildSchema(key));
    }

    @Override
    public CompletableFuture<Void> resync(DebuggerObjectModel.RefreshBehavior refreshAttributes, DebuggerObjectModel.RefreshBehavior refreshElements) {
        return CompletableFuture.allOf(this.fetchAttributes(refreshAttributes), this.fetchElements(refreshElements));
    }

    protected CompletableFuture<Void> requestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        return AsyncUtils.nil();
    }

    private boolean shouldRequestElements(DebuggerObjectModel.RefreshBehavior refresh) {
        if (refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            return true;
        }
        TargetObjectSchema.ResyncMode resync = this.getSchema().getElementResyncMode();
        return resync.shouldResync(this.curElemsRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<? extends Map<String, ? extends E>> fetchElements(DebuggerObjectModel.RefreshBehavior refresh) {
        CompletableFuture<Void> req;
        Map<String, E> map = this.elements;
        synchronized (map) {
            if (this.shouldRequestElements(refresh)) {
                this.curElemsRequest = this.model.gateFuture(this.requestElements(refresh));
            }
            req = this.curElemsRequest == null ? AsyncUtils.nil() : this.curElemsRequest;
        }
        return req.thenApply(__ -> this.getCachedElements());
    }

    @Override
    public CompletableFuture<? extends Map<String, ? extends E>> fetchElements() {
        return this.fetchElements(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, E> getCachedElements() {
        Object object = this.model.lock;
        synchronized (object) {
            return this.elements == null ? Map.of() : Map.copyOf(this.elements);
        }
    }

    public Map<String, E> getCallbackElements() {
        return this.roCbElements;
    }

    @Override
    public CompletableFuture<E> fetchElement(String index) {
        return this.fetchElements().thenApply(elems -> (TargetObject)elems.get(index));
    }

    protected Map<String, E> combineElements(Collection<? extends E> autoKeyed, Map<String, ? extends E> mapKeyed) {
        LinkedHashMap<String, TargetObject> asMap = new LinkedHashMap<String, TargetObject>();
        for (TargetObject e : autoKeyed) {
            asMap.put(e.getIndex(), e);
        }
        asMap.putAll(mapKeyed);
        return asMap;
    }

    public CollectionUtils.Delta<E, E> setElements(Collection<? extends E> autoKeyed, Map<String, ? extends E> mapKeyed, String reason) {
        if (!this.valid) {
            return CollectionUtils.Delta.empty();
        }
        Map<String, ? extends E> elements = this.combineElements(autoKeyed, mapKeyed);
        return this.setElements(elements, reason);
    }

    public CollectionUtils.Delta<E, E> setElements(Collection<? extends E> elements, String reason) {
        return this.setElements(elements, Map.of(), reason);
    }

    private void updateCallbackElements(CollectionUtils.Delta<E, E> delta) {
        CompletableFuture.runAsync(() -> {
            Object object = this.model.cbLock;
            synchronized (object) {
                delta.apply(this.cbElements, CollectionUtils.Delta.SAME);
            }
        }, this.model.clientExecutor).exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Error updating elements before callback");
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CollectionUtils.Delta<E, E> setElements(Map<String, E> elements, String reason) {
        CollectionUtils.Delta<Object, Object> delta;
        Object object = this.model.lock;
        synchronized (object) {
            if (!this.valid) {
                return CollectionUtils.Delta.empty();
            }
            delta = CollectionUtils.Delta.computeAndSet(this.elements, elements, CollectionUtils.Delta.SAME);
            this.getSchema().validateElementDelta(this.getPath(), delta, this.enforcesStrictSchema());
            this.doInvalidateElements(delta.removed, reason);
            if (!delta.isEmpty()) {
                this.updateCallbackElements(delta);
                this.broadcast().elementsChanged(this.getProxy(), delta.getKeysRemoved(), delta.added);
            }
        }
        return delta;
    }

    public CollectionUtils.Delta<E, E> changeElements(Collection<String> remove, Collection<? extends E> autoKeyed, Map<String, ? extends E> mapKeyed, String reason) {
        if (!this.valid) {
            return CollectionUtils.Delta.empty();
        }
        Map<String, ? extends E> add = this.combineElements(autoKeyed, mapKeyed);
        return this.changeElements(remove, add, reason);
    }

    public CollectionUtils.Delta<E, E> changeElements(Collection<String> remove, Collection<? extends E> add, String reason) {
        return this.changeElements(remove, add, Map.of(), reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionUtils.Delta<E, E> changeElements(Collection<String> remove, Map<String, E> add, String reason) {
        CollectionUtils.Delta<Object, Object> delta;
        Object object = this.model.lock;
        synchronized (object) {
            if (!this.valid) {
                return CollectionUtils.Delta.empty();
            }
            delta = CollectionUtils.Delta.apply(this.elements, remove, add, CollectionUtils.Delta.SAME);
            this.getSchema().validateElementDelta(this.getPath(), delta, this.enforcesStrictSchema());
            this.doInvalidateElements(delta.removed, reason);
            if (!delta.isEmpty()) {
                this.updateCallbackElements(delta);
                this.broadcast().elementsChanged(this.getProxy(), delta.getKeysRemoved(), delta.added);
            }
        }
        return delta;
    }

    protected CompletableFuture<Void> requestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        return AsyncUtils.nil();
    }

    private boolean shouldRequestAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        if (refresh.equals((Object)DebuggerObjectModel.RefreshBehavior.REFRESH_ALWAYS)) {
            return true;
        }
        TargetObjectSchema.ResyncMode resync = this.getSchema().getAttributeResyncMode();
        return resync.shouldResync(this.curAttrsRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<? extends Map<String, ?>> fetchAttributes(DebuggerObjectModel.RefreshBehavior refresh) {
        CompletableFuture<Void> req;
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            if (this.shouldRequestAttributes(refresh)) {
                this.curAttrsRequest = this.model.gateFuture(this.requestAttributes(refresh));
            }
            req = this.curAttrsRequest == null ? AsyncUtils.nil() : this.curAttrsRequest;
        }
        return req.thenApply(__ -> {
            Object object = this.model.lock;
            synchronized (object) {
                if (this.schema != null) {
                    this.schema.validateRequiredAttributes(this, this.enforcesStrictSchema());
                }
                return this.getCachedAttributes();
            }
        });
    }

    @Override
    public CompletableFuture<? extends Map<String, ?>> fetchAttributes() {
        return this.fetchAttributes(DebuggerObjectModel.RefreshBehavior.REFRESH_NEVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ?> getCachedAttributes() {
        Object object = this.model.lock;
        synchronized (object) {
            return this.attributes == null ? Map.of() : Map.copyOf(this.attributes);
        }
    }

    @Override
    public Map<String, ?> getCallbackAttributes() {
        return this.roCbAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCachedAttribute(String name) {
        Object object = this.model.lock;
        synchronized (object) {
            return this.attributes == null ? null : this.attributes.get(name);
        }
    }

    protected Map<String, Object> combineAttributes(Collection<? extends TargetObject> autoKeyed, Map<String, ?> mapKeyed) {
        LinkedHashMap<String, Object> asMap = new LinkedHashMap<String, Object>();
        for (TargetObject targetObject : autoKeyed) {
            asMap.put(targetObject.getName(), targetObject);
        }
        asMap.putAll(mapKeyed);
        return asMap;
    }

    public CollectionUtils.Delta<?, ?> setAttributes(Collection<? extends TargetObject> autoKeyed, Map<String, ?> mapKeyed, String reason) {
        if (!this.valid) {
            return CollectionUtils.Delta.empty();
        }
        Map<String, Object> attributes = this.combineAttributes(autoKeyed, mapKeyed);
        return this.setAttributes(attributes, reason);
    }

    private void updateCallbackAttributes(CollectionUtils.Delta<Object, ?> delta) {
        CompletableFuture.runAsync(() -> {
            Object object = this.model.cbLock;
            synchronized (object) {
                delta.apply(this.cbAttributes, CollectionUtils.Delta.EQUAL);
            }
        }, this.model.clientExecutor).exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Error updating elements before callback");
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionUtils.Delta<?, ?> setAttributes(Map<String, ?> attributes, String reason) {
        CollectionUtils.Delta<Object, Object> delta;
        Object object = this.model.lock;
        synchronized (object) {
            if (!this.valid) {
                return CollectionUtils.Delta.empty();
            }
            delta = CollectionUtils.Delta.computeAndSet(this.attributes, attributes, CollectionUtils.Delta.EQUAL);
            this.getSchema().validateAttributeDelta(this.getPath(), delta, this.enforcesStrictSchema());
            this.doInvalidateAttributes(delta.removed, reason);
            if (!delta.isEmpty()) {
                this.updateCallbackAttributes(delta);
                this.broadcast().attributesChanged(this.getProxy(), delta.getKeysRemoved(), delta.added);
            }
        }
        return delta;
    }

    public CollectionUtils.Delta<?, ?> changeAttributes(List<String> remove, Collection<? extends TargetObject> autoKeyed, Map<String, ?> mapKeyed, String reason) {
        if (!this.valid) {
            return CollectionUtils.Delta.empty();
        }
        Map<String, Object> add = this.combineAttributes(autoKeyed, mapKeyed);
        return this.changeAttributes(remove, add, reason);
    }

    public <T> Map<String, T> filterValid(String name, Map<String, T> map) {
        return map.entrySet().stream().filter(ent -> {
            Object val = ent.getValue();
            if (!(val instanceof TargetObject)) {
                return true;
            }
            TargetObject obj = (TargetObject)val;
            if (obj.isValid()) {
                return true;
            }
            Msg.error((Object)this, (Object)(name + " " + (String)ent.getKey() + " of " + this.getJoinedPath(".") + " linked to invalid object: " + obj.getJoinedPath(".")));
            return false;
        }).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionUtils.Delta<?, ?> changeAttributes(List<String> remove, Map<String, ?> add, String reason) {
        CollectionUtils.Delta<Object, Object> delta;
        Object object = this.model.lock;
        synchronized (object) {
            if (!this.valid) {
                return CollectionUtils.Delta.empty();
            }
            delta = CollectionUtils.Delta.apply(this.attributes, remove, add, CollectionUtils.Delta.EQUAL);
            this.getSchema().validateAttributeDelta(this.getPath(), delta, this.enforcesStrictSchema());
            this.doInvalidateAttributes(delta.removed, reason);
            if (!delta.isEmpty()) {
                this.updateCallbackAttributes(delta);
                this.broadcast().attributesChanged(this.getProxy(), delta.getKeysRemoved(), delta.added);
            }
        }
        return delta;
    }
}

